/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.screening.service.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.domain.models.Result;
import com.bcxin.backend.domain.models.ScreeningDTO;
import com.bcxin.backend.domain.screening.service.BackgrounpScreeningProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="bsp_common")
public class BackgrounpScreeningProviderImpl
implements BackgrounpScreeningProvider {
    private static final Logger log = LoggerFactory.getLogger(BackgrounpScreeningProviderImpl.class);
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;
    String isProblem = "1";
    @Value(value="${myapps.screeninng.api}")
    private String BaseUrl;

    private ScreeningDTO getScreeningDTO(String idnum, List<String> logList) {
        String detail = "";
        HttpResponse execute = HttpUtil.createGet((String)(this.BaseUrl + idnum)).execute();
        if (execute.isOk()) {
            JSONObject jsonObject = JSON.parseObject((String)execute.body());
            if (jsonObject.get((Object)"data") != null) {
                JSONObject dataJson = (JSONObject)jsonObject.get((Object)"data");
                String censorResult = dataJson.get((Object)"censorResult").toString();
                if (censorResult.equals("[]")) {
                    this.isProblem = "0";
                    detail = "";
                } else {
                    this.isProblem = "1";
                    JSONArray censorArry = JSONArray.parseArray((String)censorResult);
                    for (int i = 0; i < censorArry.size(); ++i) {
                        JSONObject object = (JSONObject)censorArry.get(i);
                        JSONObject data = (JSONObject)object.get((Object)"data");
                        detail = detail + data.get((Object)"detail").toString() + ",";
                    }
                    if (detail.length() > 0) {
                        detail = detail.substring(0, detail.length() - 1);
                    }
                }
            } else {
                this.isProblem = "0";
                detail = "";
            }
        } else {
            return null;
        }
        this.setLogList(logList, "2", idnum, detail, execute.body());
        return new ScreeningDTO(idnum, this.isProblem, detail);
    }

    public Result screening(String idnum) {
        ArrayList<String> logList = new ArrayList<String>();
        ScreeningDTO screeningDTO = this.getScreeningDTO(idnum, logList);
        this.saveLog(logList);
        return new Result<ScreeningDTO>().success("\u64cd\u4f5c\u6210\u529f\uff01", screeningDTO);
    }

    @Override
    public Result<List<ScreeningDTO>> screenings(String[] idnums) {
        ArrayList<String> logList = new ArrayList<String>();
        ArrayList list = Lists.newArrayList();
        for (String idnum : idnums) {
            ScreeningDTO screen = this.getScreeningDTO(idnum, logList);
            if (screen == null) continue;
            list.add(screen);
        }
        this.saveLog(logList);
        return new Result<ArrayList>().success("\u64cd\u4f5c\u6210\u529f\uff01", list);
    }

    private void setLogList(List<String> list, String type, String idnum, String short_result, String result) {
        list.add("( '" + type + "',NOW(),'" + idnum + "','" + short_result + "','" + result + "' )");
    }

    private void saveLog(List<String> list) {
        if (list.size() > 0) {
            String lStr = list.toString();
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO bg_screening_user_exec_logs (type,created_time,idnum,short_result,result) values" + lStr.substring(1, lStr.length() - 1));
            this.jdbcTemplate.update(sb.toString());
        }
    }
}

