/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.repositories;

import com.bcxin.backend.domain.models.SignatureQueuesDocument;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

public interface SignatureQueuesDocumentRepository
extends JpaRepository<SignatureQueuesDocument, Long> {
    @Query(value="select s from SignatureQueuesDocument s where s.status=?1 order by s.created desc")
    public Page<SignatureQueuesDocument> pageQueues(int var1, PageRequest var2);

    @Query(value="select s from SignatureQueuesDocument s where s.status=2 and s.file_url='null' order by s.created desc")
    public List<SignatureQueuesDocument> queuesFileNull();

    @Query(value="select s from SignatureQueuesDocument s where s.status=?1 and s.business_type in ('15','25','45','55','65') and (s.jt_code is null or s.jt_code='') order by s.created desc")
    public Page<SignatureQueuesDocument> pageQueuesBy5Minute(int var1, PageRequest var2);

    @Query(value="select s from SignatureQueuesDocument s where s.status=?1 and s.business_type in ('15','25','45','55','65') and s.jt_code='\u5e9f\u6b62' order by s.created desc")
    public Page<SignatureQueuesDocument> pageQueuesByCodeFZ(int var1, PageRequest var2);

    @Query(value="select s from SignatureQueuesDocument s where s.status in (?1) and s.lastmodified >= ?2 order by s.created desc")
    public Page<SignatureQueuesDocument> pageQueuesByLastmodified(List<Integer> var1, Date var2, PageRequest var3);

    @Query(value="select s.business_id from SignatureQueuesDocument s where s.id=?1")
    public String getBuId(Long var1);

    @Query(value="select s from SignatureQueuesDocument s where s.business_id=?1 and s.business_type=?2")
    public SignatureQueuesDocument getSignatureQueuesDocument(String var1, String var2);

    @Modifying
    @Transactional
    @Query(value="UPDATE SignatureQueuesDocument s SET s.status=?1,s.lastmodified=?2,s.processed_result=?3 WHERE s.id=?4")
    public void updateSignatureQueuesDocument(int var1, Date var2, String var3, Long var4);

    @Modifying
    @Transactional
    @Query(value="UPDATE SignatureQueuesDocument s SET s.status=?1,s.lastmodified=?2,s.processed_result=?3,s.jt_code=?4 WHERE s.id=?5")
    public void updateSignatureQueuesDocument(int var1, Date var2, String var3, String var4, Long var5);

    @Modifying
    @Transactional
    @Query(value="UPDATE SignatureQueuesDocument s SET s.jt_code=?1,s.lastmodified=?2,s.processed_result=?3 WHERE s.id=?4")
    public void updateJtCode(String var1, Date var2, String var3, Long var4);

    @Modifying
    @Transactional
    @Query(value="UPDATE SignatureQueuesDocument s SET s.status=?1,s.lastmodified=?2,s.processed_result=?3 WHERE s.id in (?4)")
    public void updateSignatureQueuesDocuments(int var1, Date var2, String var3, List<Long> var4);

    @Modifying
    @Transactional
    @Query(value="UPDATE SignatureQueuesDocument s SET s.status=?1,s.lastmodified=?2,s.file_url=?3,s.jt_code=?4 WHERE s.id=?5")
    public void resetDocumentPath(int var1, Date var2, String var3, String var4, Long var5);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM SignatureQueuesDocument s where s.status=4 and s.lastmodified<?1")
    public void deleteNonDocumentSignatureQueues(Date var1);
}

