package com.bcxin.backend.domain.repositories;

import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;


public interface SignatureQueuesRepository extends JpaRepository<SignatureQueuesDTO, Long> {
    @Query("select s from SignatureQueuesDTO s where s.status=?1 order by s.createdTime desc")
    Page<SignatureQueuesDTO> pageQueues(int status,PageRequest pageRequest);
    @Query("select s from SignatureQueuesDTO s where s.status=?1 and (s.jt_code is null or s.jt_code='') and s.last_processed_result!='靓证中' order by s.certificatedate desc")
    Page<SignatureQueuesDTO> pageQueuesBy5Minute(int status,PageRequest pageRequest);
    @Query("select s from SignatureQueuesDTO s where s.status=?1 and s.jt_code='废止' order by s.last_processed_time desc")
    Page<SignatureQueuesDTO> pageQueuesByCodeFZ(int status,PageRequest pageRequest);
    @Query("select s from SignatureQueuesDTO s where s.status=2 and s.last_processed_result='PDF生成失败：无头像信息' and s.last_processed_time>=?1 and s.last_processed_time<=?2 ")
    List<SignatureQueuesDTO> findQueuesByLastHouse(Date starTime,Date endTime);

    @Query("select s.business_id from SignatureQueuesDTO s where s.id=?1")
    String getBuId(Long id);
    @Query("select s.data from SignatureQueuesDTO s where s.id=?1")
    String getData(String id);

    List<SignatureQueuesDTO> findByDataLike(String date);

    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDTO s SET s.status=?1,s.last_processed_time=?2,s.last_processed_result=?3 WHERE s.id=?4")
    void updateSignature(int status, Date lastTime, String result, Long id);
    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDTO s SET s.jt_code=?1,s.last_processed_time=?2,s.last_processed_result=?3 WHERE s.id=?4")
    void updateJtCode(String jtCode, Date lastTime, String result, Long id);
    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDTO s SET s.last_processed_time=?1,s.last_processed_result=?2 WHERE s.id=?3")
    void updateResult(Date lastTime, String result, Long id);

    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDTO s SET s.status=?1,s.last_processed_time=?2,s.last_processed_result=?3 WHERE s.id in (?4)")
    void updateSignatures(int status, Date lastTime, String result, List<Long> ids);

    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDTO s SET s.status=0 WHERE s.status=2 and s.last_processed_result='PDF生成失败：无头像信息' and s.last_processed_time>=?1 and s.last_processed_time<=?2")
    void updateLastHousePhoto(Date starTime,Date endTime);
}
