package com.bcxin.backend.domain.auth.service.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.domain.auth.dtos.AuthLog;
import com.bcxin.backend.domain.auth.dtos.AuthRequestDto;
import com.bcxin.backend.domain.auth.service.AuthenticationService;
import com.bcxin.backend.domain.models.Result;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Slf4j
@Component("auth_common")
public class AuthenticationServiceImpl implements AuthenticationService {


    private final String BaseUrl;

    private final JdbcTemplate jdbcTemplate;

    public AuthenticationServiceImpl(@Value("${myapps.authentication.api}")String baseUrl,@Qualifier("primaryJdbcTemplate")JdbcTemplate jdbcTemplate) {
        BaseUrl = baseUrl;
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public Result auth(Collection<AuthRequestDto> list) {
        List<AuthLog> result=new ArrayList<>();
        List<String> loggingList=new ArrayList<>();

        //请求参数
        Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
        paramMap.put("authLogs",JSON.toJSONString(list));
        //构建请求
        HttpResponse response = HttpUtil
                .createRequest(Method.POST, BaseUrl)
                .form(paramMap)
                //设置三十秒超时时间
                .timeout(180000)
                .execute();
        //System.out.println("实名认证参数"+paramMap);
        JSONObject jsonObject = JSON.parseObject(response.body());//body转换json对象
        //System.out.println("实名认证结果"+jsonObject);
        if (!(jsonObject.get("data")==null)) {//判断data是否为空
            result=JSONObject.parseArray(jsonObject.getString("data"),AuthLog.class);
            setLogList(loggingList,"1",result);
        }
        saveLog(loggingList);
        return new Result().success(Result.SUCCESS_MSG,result);
    }

    /**
     * <b> 日志sql组装多次数据 </b>
     * @author ZXF
     * @create 2022/09/22 0022 16:58
     * @version
     * @注意事项 </b>
     */
    private void setLogList(List<String> list,String type,List<AuthLog> result){
        for (AuthLog authLog : result) {
            list.add("( '" + type + "',NOW(),'" + authLog.getIdNumber() + "','实名认证','" + authLog.getAuthResult() + "' )");
        }

    }

    /**
     * <b> 日志sql组装后保存 </b>
     * @author ZXF
     * @create 2022/09/22 0022 16:58
     * @version
     * @注意事项 </b>
     */
    private void saveLog(List<String> list){
        if(list.size()>0){
            String lStr = list.toString();
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO bg_screening_user_exec_logs (type,created_time,idnum,short_result,result) values" + lStr.substring(1,lStr.length()-1));
            jdbcTemplate.update(sb.toString());
        }
    }
}
