/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.services.impls;

import cn.hutool.http.HttpResponse;
import com.bcxin.backend.core.AppConfigProperty;
import com.bcxin.backend.core.components.StorageProvider;
import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.core.exceptions.SaasExceptionAbstract;
import com.bcxin.backend.core.exceptions.SaasIgnoredException;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.SimpleLocalLockComponent;
import com.bcxin.backend.domain.configs.SyncLimiter;
import com.bcxin.backend.domain.enums.SyncType;
import com.bcxin.backend.domain.models.SuperviseDTO;
import com.bcxin.backend.domain.repositories.DomainSuperviseRepository;
import com.bcxin.backend.domain.syncs.components.HttpRequestProvider;
import com.bcxin.backend.domain.syncs.dtos.DataSyncParameter;
import com.bcxin.backend.domain.syncs.dtos.DbDataImportRequestDto;
import com.bcxin.backend.domain.syncs.dtos.FtpDataImportRequestDto;
import com.bcxin.backend.domain.syncs.dtos.FtpDataImportResponseDto;
import com.bcxin.backend.domain.syncs.dtos.SyncDataMeta;
import com.bcxin.backend.domain.syncs.dtos.SyncDataResponse;
import com.bcxin.backend.domain.syncs.dtos.SyncDataSetDTO;
import com.bcxin.backend.domain.syncs.repositories.DataSyncQueueRepository;
import com.bcxin.backend.domain.syncs.services.CleanQueuesCacheService;
import com.bcxin.backend.domain.syncs.services.DataSyncQueueService;
import com.bcxin.backend.domain.syncs.services.impls.DataSyncQueueServiceBase;
import com.bcxin.backend.domain.system.configs.SyncLimiterConfig;
import com.bcxin.runtime.domain.constants.FieldNames;
import com.bcxin.runtime.domain.snapshoots.FormSyncTargetConfigSnapshot;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.bcxin.runtime.domain.syncs.entities.DataSyncQueueEntity;
import com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus;
import com.bcxin.saas.core.components.JsonProvider;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.http.client.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="FtpDataSyncQueueServiceImpl")
public class FtpDataSyncQueueServiceImpl
extends DataSyncQueueServiceBase
implements DataSyncQueueService {
    @Autowired
    private SyncLimiterConfig syncLimiterConfig;
    @Autowired
    private CleanQueuesCacheService cleanQueuesCacheService;
    private static Map<String, SyncLimiter> syncLimiterMap = new ConcurrentHashMap<String, SyncLimiter>();
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public FtpDataSyncQueueServiceImpl(DataSyncQueueRepository dataSyncQueueRepository, JsonProvider jsonProvider, HttpRequestProvider httpRequestProvider, AppConfigProperty appConfigProperty, StorageProvider storageProvider, DomainSuperviseRepository domainSuperviseRepository, SimpleLocalLockComponent simpleLocalLockComponent) {
        super(dataSyncQueueRepository, jsonProvider, httpRequestProvider, appConfigProperty, storageProvider, domainSuperviseRepository, simpleLocalLockComponent);
    }

    @Override
    public void dispatchData() {
        this.dispatch(SyncType.DataViaFtp);
    }

    @Override
    public void dispatchFile() {
        this.dispatch(SyncType.FileViaFtp);
    }

    protected FtpDataImportRequestDto createFtpDataImportRequest(SyncDataSetDTO syncDataSetDTO, boolean dispatchFile, DataSyncParameter dataSyncParameter) {
        StringBuilder trackingLog = new StringBuilder("\u5f00\u59cb\u6267\u884ccreateFtpDataImportRequest;");
        try {
            DataSyncQueueEntity data = dataSyncParameter.getDataSyncQueueEntity();
            trackingLog.append("syncDataSetDTO.getDataSetDto();");
            DataSetDto dataSetDto = syncDataSetDTO.getDataSetDto();
            trackingLog.append("DbDataImportRequestDto.DataSet.create();");
            DbDataImportRequestDto.DataSet dbDataSet = DbDataImportRequestDto.DataSet.create(data.getId(), dataSyncParameter.getMapKey(), dataSetDto.getRows(), dataSetDto.getDeletedIds());
            trackingLog.append("Done.DbDataImportRequestDto.DataSet.create();");
            if (dbDataSet.getDataRecords() == null) {
                throw new SaasBadException("dbDataSet.getDataRecords()\u5bf9\u8c61\u4e3a\u7a7a\u65e0\u6548!");
            }
            if (syncDataSetDTO.getDomainSuperviseDTO() == null) {
                throw new SaasIgnoredException("\u65e0\u5f52\u5c5e\u5730\u4fe1\u606f, \u56e0\u6b64\uff0c\u65e0\u6cd5\u786e\u5b9a\u63a8\u9001\u5230\u54ea\u91cc(syncDataSetDTO.getDomainSuperviseDTO())");
            }
            if (syncDataSetDTO.getDomainSuperviseDTO().getSupervise() == null) {
                throw new SaasIgnoredException("\u65e0\u5f52\u5c5e\u5730\u4fe1\u606f, \u56e0\u6b64\uff0c\u65e0\u6cd5\u786e\u5b9a\u63a8\u9001\u5230\u54ea\u91cc(syncDataSetDTO.getDomainSuperviseDTO().getSupervise())");
            }
            trackingLog.append("syncDataSetDTO.getDomainSuperviseDTO().getSupervise();");
            SuperviseDTO supervise = syncDataSetDTO.getDomainSuperviseDTO().getSupervise();
            FtpDataImportRequestDto requestDto = this.getFtpDataImportRequest(supervise, dataSyncParameter);
            trackingLog.append("Done.FtpDataImportRequestDto.create;");
            DbDataImportRequestDto requestPlayData = DbDataImportRequestDto.create(data.getData(), Collections.singleton(dbDataSet));
            String fileUrls = null;
            Map<String, String> pathMap = null;
            if (dispatchFile) {
                fileUrls = dbDataSet.getDataRecords().stream().flatMap(ii -> ii.getFieldValues().stream()).filter(ii -> ii.getIsFileValue() && ii.getFileUrls() != null && ii.getFileUrls().size() > 0).flatMap(ii -> ii.getFileUrls().stream()).filter(ii -> ii != null).distinct().collect(Collectors.joining(","));
                pathMap = dbDataSet.getDataRecords().stream().flatMap(ii -> ii.getFieldValues().stream()).filter(ii -> ii.getIsFileValue() && ii.getFileUrls() != null && ii.getFileUrls().size() > 0).flatMap(ii -> ii.getPathOptions().stream()).filter(ii -> ii != null).collect(Collectors.toMap(FieldNames.PathOption::getOriginalPath, FieldNames.PathOption::getPath, (v1, v2) -> v1));
            }
            String jsonPlayData = this.jsonProvider.getJson((Object)requestPlayData);
            trackingLog.append("requestDto.assign(dispatchFile, jsonPlayData);");
            requestDto.assign(dispatchFile, jsonPlayData, fileUrls, pathMap);
            return requestDto;
        }
        catch (Exception ex) {
            if (ex instanceof SaasExceptionAbstract) {
                throw ex;
            }
            throw new SaasBadException(String.format("createFtpDataImportRequest\u7cfb\u7edf\u5f02\u5e38:%s", trackingLog), ex);
        }
    }

    private SyncDataMeta saveFtpRequestData(FtpDataImportRequestDto dataImportRequestDto) {
        String path = String.format("/uploads/sync/response/ftp/%s/%s-%s.txt", simpleDateFormat.format(new Date()), dataImportRequestDto.getFileType(), UUID.randomUUID());
        String data = this.jsonProvider.getJson((Object)dataImportRequestDto);
        byte[] content = data.getBytes(StandardCharsets.UTF_8);
        String realPath = this.storageProvider.save(path, content);
        return SyncDataMeta.create(path, content.length, realPath, Collections.EMPTY_LIST);
    }

    @Override
    protected void executeSyncDataCore(DataSyncParameter dataSyncParameter) {
        this.executeSync(false, dataSyncParameter);
    }

    @Override
    protected void executeSyncFileCore(DataSyncParameter dataSyncParameter) {
        this.executeSync(true, dataSyncParameter);
    }

    @Override
    protected boolean isMatchExecuteCondition(boolean isDispatchFile, DataSyncQueueEntity data) {
        return (data.getStatus() == SyncProcessStatus.SyncViaFTP && !isDispatchFile || data.getFileSyncStatus() == SyncProcessStatus.SyncViaFTP && isDispatchFile) && super.isMatchExecuteCondition(isDispatchFile, data);
    }

    private void executeSync(boolean dispatchFile, DataSyncParameter dataSyncParameter) {
        block30: {
            DataSyncQueueEntity data = dataSyncParameter.getDataSyncQueueEntity();
            StringBuilder sb = new StringBuilder();
            try {
                FormSyncTargetConfigSnapshot formSyncTargetConfig = dataSyncParameter.getFormSyncTargetConfig();
                sb.append("\u5f00\u59cb\u83b7\u53d6this.jsonProvider.getData(getSyncRealData(data), DataSetDto.class)");
                SyncDataSetDTO syncDataSetDTO = (SyncDataSetDTO)this.jsonProvider.getData(this.getSyncRealData(data), SyncDataSetDTO.class);
                FtpDataImportRequestDto requestDto = null;
                try {
                    sb.append("\uff1b\u5f00\u59cb\u83b7\u53d6DbDataImportRequestDto.create(Collections.singleton(dbDataSet))");
                    try {
                        requestDto = this.createFtpDataImportRequest(syncDataSetDTO, dispatchFile, dataSyncParameter);
                        if (dispatchFile && !requestDto.isNeedFile2Execute()) {
                            data.changeFileSyncStatus(SyncProcessStatus.Done, String.format("\u65e0\u6548\u53c2\u6570,\u65e0\u9700\u6267\u884c", new Object[0]));
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        sb.append(String.format("\u521b\u5efa\u5bf9\u8c61\u5f02\u5e38:%s", this.jsonProvider.getJson((Object)syncDataSetDTO)));
                        throw new SaasBadException(String.format("createFtpDataImportRequest\u53d1\u751f\u5f02\u5e38:%s", ExceptionUtils.getStackMessage((Throwable)ex)));
                    }
                    sb.append("\uff1bSyncDataResponse syncDataResponse = SyncDataResponse.create(");
                    String ftpUrl = requestDto.getRequestUrl(formSyncTargetConfig);
                    SyncLimiterConfig.Limiter limiter = null;
                    if (!CollectionUtils.isEmpty(this.syncLimiterConfig.getReplenishRate()) && !CollectionUtils.isEmpty(this.syncLimiterConfig.getReplenishRate().get(requestDto.getRegionId()))) {
                        Collection<SyncLimiterConfig.Limiter> limiters = this.syncLimiterConfig.getReplenishRate().get(requestDto.getRegionId());
                        ArrayList<SyncLimiterConfig.Limiter> list = new ArrayList<SyncLimiterConfig.Limiter>(limiters);
                        ftpUrl = ((SyncLimiterConfig.Limiter)list.get(0)).getFtpUrl();
                    }
                    SyncLimiter syncLimiter = null;
                    if (syncLimiterMap.get(ftpUrl) == null) {
                        int limitMax = this.syncLimiterConfig.getDefaultMax();
                        if (limiter != null) {
                            limitMax = limiter.getMax();
                        }
                        syncLimiter = new SyncLimiter();
                        syncLimiter.setMaxCount(limitMax);
                        syncLimiter.setInterval(this.syncLimiterConfig.getInterval());
                        syncLimiterMap.put(ftpUrl, syncLimiter);
                    } else {
                        syncLimiter = syncLimiterMap.get(ftpUrl);
                    }
                    if (!syncLimiter.get()) {
                        logger.error("\u5f53\u524d\u65f6\u95f4\u6bb5\u5185\u8c03\u7528\u6446\u6e21\u670d\u52a1url={},\u5df2\u7ecf\u8fbe\u5230\u6700\u5927\u8c03\u7528\u6b21\u6570{}\uff0c\u7b49\u5f85\u4e0b\u4e00\u4e2a\u65f6\u95f4\u6bb5\u5185\u518d\u6267\u884c", (Object)ftpUrl, (Object)syncLimiter.getMaxCount());
                        return;
                    }
                    SyncDataResponse syncDataResponse = SyncDataResponse.create(ftpUrl, formSyncTargetConfig.getHeaders(), String.format("\u6682\u4e0d\u5b58\u50a8\u8bf7\u6c42\u53c2\u6570:(isSyncViaFtp=%s;targetApp=%s;targetServiceUrl=%s;configUrl=%s)", requestDto.isSyncViaFtp(), requestDto.getTargetApp(), requestDto.getTargetServiceUrl(), formSyncTargetConfig.getUrl()));
                    String requestBody = this.jsonProvider.getJson((Object)requestDto);
                    String dateKey = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
                    if (!CollectionUtils.isEmpty(this.cleanQueuesCacheService.getQueuesIds().get(dateKey)) && this.cleanQueuesCacheService.getQueuesIds().get(dateKey).containsKey(data.getId())) {
                        String msgId = this.cleanQueuesCacheService.getQueuesIds().get(dateKey).get(data.getId());
                        data.assignThirdParty(dispatchFile, SyncProcessStatus.DoneViaFTP, msgId, "\u8c03\u7528\u6446\u6e21\u670d\u52a1\u6210\u529f");
                        logger.error("queues\u8868id\u4e3a{}\u5df2\u8c03\u7528\u6446\u6e21\u670d\u52a1\u6210\u529f,\u6d88\u606fid\u4e3a{}\uff0c\u65e0\u9700\u91cd\u590d\u8c03\u7528", (Object)data.getId(), (Object)msgId);
                        return;
                    }
                    logger.error("queues\u8868id\u4e3a{}\uff0c\u5f00\u59cb\u8c03\u7528\u6446\u6e21\u670d\u52a1{}", (Object)data.getId(), (Object)ftpUrl);
                    HttpResponse result = this.executePostRequest(syncDataResponse.getRequestUrl(), syncDataResponse.getRequestHeaders(), requestBody);
                    if (result.getStatus() == 200) {
                        syncLimiter.set();
                    }
                    syncDataResponse.assign(result.getStatus(), result.body());
                    String syncResponseBody = null;
                    if (dispatchFile) {
                        syncDataResponse.assignOriginalRequestBody(requestBody);
                        syncResponseBody = this.jsonProvider.getJson((Object)syncDataResponse);
                    } else {
                        syncResponseBody = this.jsonProvider.getJson((Object)syncDataResponse);
                    }
                    try {
                        FtpDataImportResponseDto responseDto = (FtpDataImportResponseDto)this.jsonProvider.getData(syncDataResponse.getBody(), FtpDataImportResponseDto.class);
                        if (StringUtils.hasLength((String)syncDataResponse.getBody()) && syncDataResponse.getBody().length() > 795) {
                            data.setShortResult(syncDataResponse.getBody().substring(0, 795));
                        } else {
                            data.setShortResult(syncDataResponse.getBody());
                        }
                        logger.error("queues\u8868id\u4e3a{}\u8c03\u7528\u6446\u6e21\u670d\u52a1\u54cd\u5e94\u7ed3\u679c\u4e3a{}", (Object)data.getId(), (Object)data.getShortResult());
                        if (result.getStatus() >= 200 && responseDto != null && responseDto.IsSucceed()) {
                            data.assignThirdParty(dispatchFile, SyncProcessStatus.DoneViaFTP, responseDto.getData(), syncResponseBody);
                            if (!StringUtils.isEmpty((Object)data.getThirdPartyReferenceId())) {
                                Map<String, String> queuesIdsMap = this.cleanQueuesCacheService.getQueuesIds().get(dateKey);
                                if (CollectionUtils.isEmpty(queuesIdsMap)) {
                                    queuesIdsMap = new HashMap<String, String>();
                                }
                                queuesIdsMap.put(data.getId(), data.getThirdPartyReferenceId());
                                this.cleanQueuesCacheService.getQueuesIds().put(dateKey, queuesIdsMap);
                            }
                        } else {
                            syncDataResponse.assignOriginalRequestBody(requestBody);
                            syncResponseBody = this.jsonProvider.getJson((Object)syncDataResponse);
                            data.assignThirdParty(dispatchFile, SyncProcessStatus.ErrorViaFTP, responseDto == null ? "EMPTY" : responseDto.getData(), syncResponseBody);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        SyncDataResponse.ProcessMsg processMsg = SyncDataResponse.ProcessMsg.create(ExceptionUtils.getStackMessage((Throwable)ex), syncDataResponse.getBody());
                        syncDataResponse.assignProcessedMsg(this.jsonProvider.getJson((Object)processMsg));
                        syncResponseBody = this.jsonProvider.getJson((Object)syncDataResponse);
                        if (!dispatchFile) {
                            data.changeDataSyncStatus(SyncProcessStatus.ErrorViaFTP, syncResponseBody);
                        }
                        data.changeFileSyncStatus(SyncProcessStatus.ErrorViaFTP, syncResponseBody);
                    }
                    sb.append(String.format("%s:\u5f02\u5e38: DataSyncQueueServiceImpl.dispatchData:url=%s; \u54cd\u5e94\u72b6\u6001=%s; \u8be6\u7ec6= %s", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()), ftpUrl, result.getStatus(), data.getResult()));
                    this.printBusinessMsg(sb.toString());
                }
                catch (SaasIgnoredException cEx) {
                    cEx.printStackTrace();
                    String domainId = null;
                    Optional<String> firstDomainIdOptional = syncDataSetDTO.getDataSetDto().getRows().stream().map(ix -> ix.getDomainId()).filter(ii -> StringUtils.hasLength((String)ii)).findFirst();
                    if (firstDomainIdOptional.isPresent()) {
                        domainId = firstDomainIdOptional.get();
                    }
                    if (!dispatchFile) {
                        data.changeDataSyncStatus(SyncProcessStatus.DoneViaFTP, String.format("\u5f02\u5e38: %s: \u4f01\u4e1a(%s), \u660e\u7ec6: %s; \u5177\u4f53:%s", cEx.getMessage(), domainId, sb, ExceptionUtils.getStackMessage((Throwable)cEx)));
                        break block30;
                    }
                    data.changeFileSyncStatus(SyncProcessStatus.DoneViaFTP, String.format("\u5f02\u5e38: %s: \u4f01\u4e1a(%s), \u660e\u7ec6: %s; \u5177\u4f53:%s", cEx.getMessage(), domainId, sb, ExceptionUtils.getStackMessage((Throwable)cEx)));
                }
                catch (Exception cEx) {
                    cEx.printStackTrace();
                    String domainId = String.format("\u3010\u65e0\u627e\u5230\u4f01\u4e1a\u5f52\u5c5e\u5730\u4fe1\u606f(%s)\u3011", data.getName());
                    if (syncDataSetDTO.getDomainSuperviseDTO() != null) {
                        domainId = String.format("\u3010\u65e0\u627e\u5230\u4f01\u4e1a(%s)\u5f52\u5c5e\u5730\u4fe1\u606f(%s)\u3011", syncDataSetDTO.getDomainSuperviseDTO().getDomainId(), data.getName());
                    }
                    if (!dispatchFile) {
                        data.changeDataSyncStatus(SyncProcessStatus.ErrorViaFTP, String.format("\u6446\u6e21\u540c\u6b65\u5f02\u5e38: \u4f01\u4e1a(%s), \u660e\u7ec6: %s, \u5177\u4f53\uff1a%s", domainId, sb, ExceptionUtils.getStackMessage((Throwable)cEx)));
                        break block30;
                    }
                    data.changeFileSyncStatus(SyncProcessStatus.ErrorViaFTP, String.format("\u6446\u6e21\u540c\u6b65\u5f02\u5e38: \u4f01\u4e1a(%s), \u660e\u7ec6: %s, \u5177\u4f53\uff1a%s", domainId, sb, ExceptionUtils.getStackMessage((Throwable)cEx)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String msg = String.format("%s:\u5f02\u5e38: DataSyncQueueServiceImpl.dispatchData:\u3010\u8ddf\u8e2a\uff1a%s\u3011%s; \u8be6\u7ec6: %s", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()), sb, dataSyncParameter.getDataSyncQueueEntity().getId(), ExceptionUtils.getStackMessage((Throwable)ex));
                throw new SaasBadException(msg, ex);
            }
        }
    }

    private FtpDataImportRequestDto getFtpDataImportRequest(SuperviseDTO supervise, DataSyncParameter dataSyncParameter) {
        StringBuilder trackingLog = new StringBuilder();
        String regionId = supervise.getRegionId();
        String srcApp = supervise.getSrcApp();
        String targetApp = supervise.getTargetApp();
        if (dataSyncParameter.getOtherTargetApp() != null && dataSyncParameter.getOtherTargetApp() != "") {
            targetApp = dataSyncParameter.getOtherTargetApp();
        }
        String targetServiceUrl = supervise.getTargetServiceUrl();
        String callbackUrl = supervise.getCallbackUrl();
        trackingLog.append(String.format("\u5df2\u7ecf\u6709srcApp\u4fe1\u606f:%s;", srcApp));
        if (!StringUtils.hasLength((String)srcApp)) {
            throw new SaasBadException("\u76d1\u7ba1\u5f52\u5c5e\u5730SrcApp\u65e0\u6548");
        }
        boolean isSyncViaFtp = this.appConfigProperty.isSyncViaFtp(targetApp);
        trackingLog.append(String.format("original.srcApp=%s;", srcApp));
        if (isSyncViaFtp) {
            if (srcApp.contains("113.246.57.21:7002") || srcApp.contains("v5gaout.pre.baibaodun.cn")) {
                srcApp = "http://119.3.247.211/obpm";
            } else if (srcApp.contains("117.78.35.63:8060")) {
                srcApp = "http://117.78.35.63:8080/obpm";
            }
        }
        targetServiceUrl = "/v2/sync/ftp/data-import";
        callbackUrl = String.format("%s/v2/sync/ftp/callback", srcApp);
        String outRequsetDirKey = this.storageProvider.getDir();
        FtpDataImportRequestDto requestDto = FtpDataImportRequestDto.create(regionId, srcApp, targetApp, targetServiceUrl, callbackUrl, isSyncViaFtp, outRequsetDirKey);
        return requestDto;
    }
}

