/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.dtos;

import com.bcxin.runtime.domain.snapshoots.FormSyncTargetConfigSnapshot;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class FtpDataImportRequestDto {
    private final String regionId;
    private final String srcApp;
    private final String targetApp;
    private final String targetServiceUrl;
    private final String callbackUrl;
    private final String outRequsetDirKey;
    private boolean isPostFile;
    private String fileUrls;
    private String data;
    private Map<String, String> headers;
    private final boolean isSyncViaFtp;
    private Map<String, String> pathMap;

    public FtpDataImportRequestDto(String regionId, String srcApp, String targetApp, String targetServiceUrl, String callbackUrl, Boolean isSyncViaFtp, String outRequsetDirKey) {
        this.regionId = regionId;
        this.srcApp = srcApp;
        this.targetApp = targetApp;
        this.targetServiceUrl = targetServiceUrl;
        this.callbackUrl = callbackUrl;
        this.outRequsetDirKey = outRequsetDirKey;
        this.isSyncViaFtp = isSyncViaFtp;
        this.headers = new HashMap<String, String>();
        this.headers.put("data-from-body", "true");
        this.headers.put("content-type", "application/json");
    }

    public String getBusinessType() {
        return "1001";
    }

    public String getBusinessId() {
        return "1001000000001";
    }

    public String getFileType() {
        if (this.isPostFile) {
            return "annex";
        }
        return "normal";
    }

    public boolean isNeedFile2Execute() {
        if (this.isPostFile()) {
            return this.getFileUrls() != null && Arrays.stream(this.getFileUrls().split(",")).anyMatch(ii -> StringUtils.hasLength((String)ii) && !"null".equalsIgnoreCase((String)ii));
        }
        return true;
    }

    public void assign(boolean isPostFile, String data, String fileUrls, Map<String, String> pathMap) {
        this.setPostFile(isPostFile);
        this.setFileUrls(fileUrls);
        this.setData(data);
        this.setPathMap(pathMap);
    }

    public static FtpDataImportRequestDto create(String regionId, String srcApp, String targetApp, String targetServiceUrl, String callbackUrl, Boolean isSyncViaFtp, String outRequsetDirKey) {
        return new FtpDataImportRequestDto(regionId, srcApp, targetApp, targetServiceUrl, callbackUrl, isSyncViaFtp, outRequsetDirKey);
    }

    public String getRequestUrl(FormSyncTargetConfigSnapshot configSnapshot) {
        if (!this.isSyncViaFtp) {
            return String.format("%s/%s", this.srcApp, this.targetServiceUrl);
        }
        return configSnapshot.getUrl();
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getSrcApp() {
        return this.srcApp;
    }

    public String getTargetApp() {
        return this.targetApp;
    }

    public String getTargetServiceUrl() {
        return this.targetServiceUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getOutRequsetDirKey() {
        return this.outRequsetDirKey;
    }

    public boolean isPostFile() {
        return this.isPostFile;
    }

    public String getFileUrls() {
        return this.fileUrls;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isSyncViaFtp() {
        return this.isSyncViaFtp;
    }

    public Map<String, String> getPathMap() {
        return this.pathMap;
    }

    private void setPostFile(boolean isPostFile) {
        this.isPostFile = isPostFile;
    }

    private void setFileUrls(String fileUrls) {
        this.fileUrls = fileUrls;
    }

    private void setData(String data) {
        this.data = data;
    }

    private void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    private void setPathMap(Map<String, String> pathMap) {
        this.pathMap = pathMap;
    }
}

