/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.snapshoots;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.utils.SecurityUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.springframework.util.StringUtils;

public class RequestSnapshoot {
    private String method;
    private String path;
    private String query;
    private String proxy;
    private JSONObject headers;
    private String body;
    @JsonProperty(value="X-url")
    private String xUrl;
    private Collection<FileItem> fileItems;

    public void addFileItem(String srcFileUrl) {
        if (!StringUtils.hasLength((String)srcFileUrl)) {
            return;
        }
        if (this.getFileItems() == null) {
            this.setFileItems(new ArrayList<FileItem>());
        }
        FileItem fileItem = new FileItem();
        fileItem.setSrcFileUrl(srcFileUrl);
        SimpleDateFormat dt = new SimpleDateFormat("yyyyMM");
        String targetUrl = String.format("/uploads/sync/%s/%s-%s", dt.format(new Date()), UUID.randomUUID().toString(), Paths.get(srcFileUrl, new String[0]).toFile().getName());
        fileItem.setTargetFileUrl(targetUrl);
        this.getFileItems().add(fileItem);
    }

    public String getUserId() {
        Optional<String> accessTokenOptional;
        JSONObject request = this.headers.getJSONObject("request");
        String token = null;
        if (request != null && !StringUtils.hasLength((String)(token = request.getString("accesstoken"))) && StringUtils.hasLength((String)this.query) && this.query.contains("accessToken") && (accessTokenOptional = Arrays.stream(this.query.split("&")).filter(ii -> ii.contains("accessToken")).map(ii -> ii.substring(ii.indexOf("=") + 1)).findFirst()).isPresent()) {
            token = accessTokenOptional.get();
        }
        if (!StringUtils.hasLength(token)) {
            return null;
        }
        return SecurityUtil.getUserIdFromTokenWithoutVerify((String)token);
    }

    public boolean getHasFiles() {
        return this.getFileItems() != null && this.getFileItems().size() > 0;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getProxy() {
        return this.proxy;
    }

    public JSONObject getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public String getXUrl() {
        return this.xUrl;
    }

    public Collection<FileItem> getFileItems() {
        return this.fileItems;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setHeaders(JSONObject headers) {
        this.headers = headers;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @JsonProperty(value="X-url")
    public void setXUrl(String xUrl) {
        this.xUrl = xUrl;
    }

    public void setFileItems(Collection<FileItem> fileItems) {
        this.fileItems = fileItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestSnapshoot)) {
            return false;
        }
        RequestSnapshoot other = (RequestSnapshoot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        JSONObject this$headers = this.getHeaders();
        JSONObject other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$xUrl = this.getXUrl();
        String other$xUrl = other.getXUrl();
        if (this$xUrl == null ? other$xUrl != null : !this$xUrl.equals(other$xUrl)) {
            return false;
        }
        Collection<FileItem> this$fileItems = this.getFileItems();
        Collection<FileItem> other$fileItems = other.getFileItems();
        return !(this$fileItems == null ? other$fileItems != null : !((Object)this$fileItems).equals(other$fileItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestSnapshoot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        JSONObject $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $xUrl = this.getXUrl();
        result = result * 59 + ($xUrl == null ? 43 : $xUrl.hashCode());
        Collection<FileItem> $fileItems = this.getFileItems();
        result = result * 59 + ($fileItems == null ? 43 : ((Object)$fileItems).hashCode());
        return result;
    }

    public String toString() {
        return "RequestSnapshoot(method=" + this.getMethod() + ", path=" + this.getPath() + ", query=" + this.getQuery() + ", proxy=" + this.getProxy() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", xUrl=" + this.getXUrl() + ", fileItems=" + this.getFileItems() + ")";
    }

    public static class FileItem {
        private String srcFileUrl;
        private String targetFileUrl;

        public String getSrcFileUrl() {
            return this.srcFileUrl;
        }

        public String getTargetFileUrl() {
            return this.targetFileUrl;
        }

        public void setSrcFileUrl(String srcFileUrl) {
            this.srcFileUrl = srcFileUrl;
        }

        public void setTargetFileUrl(String targetFileUrl) {
            this.targetFileUrl = targetFileUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileItem)) {
                return false;
            }
            FileItem other = (FileItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$srcFileUrl = this.getSrcFileUrl();
            String other$srcFileUrl = other.getSrcFileUrl();
            if (this$srcFileUrl == null ? other$srcFileUrl != null : !this$srcFileUrl.equals(other$srcFileUrl)) {
                return false;
            }
            String this$targetFileUrl = this.getTargetFileUrl();
            String other$targetFileUrl = other.getTargetFileUrl();
            return !(this$targetFileUrl == null ? other$targetFileUrl != null : !this$targetFileUrl.equals(other$targetFileUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $srcFileUrl = this.getSrcFileUrl();
            result = result * 59 + ($srcFileUrl == null ? 43 : $srcFileUrl.hashCode());
            String $targetFileUrl = this.getTargetFileUrl();
            result = result * 59 + ($targetFileUrl == null ? 43 : $targetFileUrl.hashCode());
            return result;
        }

        public String toString() {
            return "RequestSnapshoot.FileItem(srcFileUrl=" + this.getSrcFileUrl() + ", targetFileUrl=" + this.getTargetFileUrl() + ")";
        }
    }
}

