/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.dtos;

import com.bcxin.backend.domain.models.DomainSuperviseDTO;
import com.bcxin.backend.domain.models.SuperviseDTO;
import com.bcxin.runtime.domain.snapshoots.enums.SyncTargetType;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class SyncDataSetDTO {
    private DataSetDto dataSetDto;
    private DomainSuperviseDTO domainSuperviseDTO;
    private SyncTargetType syncTargetType;
    private String note;

    public SyncDataSetDTO() {
    }

    public SyncDataSetDTO(SyncTargetType syncTargetType, DataSetDto dataSetDto, DomainSuperviseDTO domainSuperviseDTO) {
        this.syncTargetType = syncTargetType;
        this.dataSetDto = dataSetDto;
        this.domainSuperviseDTO = domainSuperviseDTO;
    }

    public static SyncDataSetDTO create(SyncTargetType syncTargetType, DataSetDto dataSetDto, DomainSuperviseDTO domainSuperviseDTO) {
        return new SyncDataSetDTO(syncTargetType, dataSetDto, domainSuperviseDTO);
    }

    @JsonIgnore
    public String getIdentityValue() {
        SuperviseDTO supervise;
        if (this.domainSuperviseDTO != null && (supervise = this.domainSuperviseDTO.getSupervise()) != null) {
            return String.format("Sync_%s_%s_%s", this.syncTargetType, this.dataSetDto.getTableName(), supervise.getRegionId());
        }
        return String.format("type_%s_name_%s", this.syncTargetType.name(), this.dataSetDto.getTableName());
    }

    @JsonIgnore
    public String getKeyValue() {
        if (this.getDomainSuperviseDTO() == null) {
            return this.getSyncTargetType().name();
        }
        return this.getDomainSuperviseDTO().getDomainId();
    }

    public void markNote(String note) {
        this.setNote(note);
    }

    public DataSetDto getDataSetDto() {
        return this.dataSetDto;
    }

    public DomainSuperviseDTO getDomainSuperviseDTO() {
        return this.domainSuperviseDTO;
    }

    public SyncTargetType getSyncTargetType() {
        return this.syncTargetType;
    }

    public String getNote() {
        return this.note;
    }

    public void setDataSetDto(DataSetDto dataSetDto) {
        this.dataSetDto = dataSetDto;
    }

    public void setDomainSuperviseDTO(DomainSuperviseDTO domainSuperviseDTO) {
        this.domainSuperviseDTO = domainSuperviseDTO;
    }

    public void setSyncTargetType(SyncTargetType syncTargetType) {
        this.syncTargetType = syncTargetType;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncDataSetDTO)) {
            return false;
        }
        SyncDataSetDTO other = (SyncDataSetDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSetDto this$dataSetDto = this.getDataSetDto();
        DataSetDto other$dataSetDto = other.getDataSetDto();
        if (this$dataSetDto == null ? other$dataSetDto != null : !this$dataSetDto.equals(other$dataSetDto)) {
            return false;
        }
        DomainSuperviseDTO this$domainSuperviseDTO = this.getDomainSuperviseDTO();
        DomainSuperviseDTO other$domainSuperviseDTO = other.getDomainSuperviseDTO();
        if (this$domainSuperviseDTO == null ? other$domainSuperviseDTO != null : !((Object)this$domainSuperviseDTO).equals(other$domainSuperviseDTO)) {
            return false;
        }
        SyncTargetType this$syncTargetType = this.getSyncTargetType();
        SyncTargetType other$syncTargetType = other.getSyncTargetType();
        if (this$syncTargetType == null ? other$syncTargetType != null : !this$syncTargetType.equals(other$syncTargetType)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        return !(this$note == null ? other$note != null : !this$note.equals(other$note));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SyncDataSetDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSetDto $dataSetDto = this.getDataSetDto();
        result = result * 59 + ($dataSetDto == null ? 43 : $dataSetDto.hashCode());
        DomainSuperviseDTO $domainSuperviseDTO = this.getDomainSuperviseDTO();
        result = result * 59 + ($domainSuperviseDTO == null ? 43 : $domainSuperviseDTO.hashCode());
        SyncTargetType $syncTargetType = this.getSyncTargetType();
        result = result * 59 + ($syncTargetType == null ? 43 : $syncTargetType.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        return result;
    }

    public String toString() {
        return "SyncDataSetDTO(dataSetDto=" + this.getDataSetDto() + ", domainSuperviseDTO=" + this.getDomainSuperviseDTO() + ", syncTargetType=" + this.getSyncTargetType() + ", note=" + this.getNote() + ")";
    }
}

