package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.syncs.services.DataSyncQueueService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SyncFileViaDirectlyJobTask extends TaskAbstract {
    private final DataSyncQueueService dataSyncQueueService;

    public SyncFileViaDirectlyJobTask(
            @Qualifier("DataSyncQueueServiceImpl") DataSyncQueueService dataSyncQueueService) {
        this.dataSyncQueueService = dataSyncQueueService;
    }

    @Override
    protected void runCore() {
        dataSyncQueueService.dispatchFile();
    }

    @Override
    public String getTaskName() {
        return "sync.file.directly.data";
    }
}
