package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.syncs.services.RetryDataService;
import org.springframework.stereotype.Component;

@Component
public class RetrySyncDataJobTask extends TaskAbstract {
    private final RetryDataService retryDataService;

    public RetrySyncDataJobTask(RetryDataService retryDataService) {
        this.retryDataService = retryDataService;
    }

    @Override
    protected void runCore() {
        retryDataService.retrySync();
    }

    @Override
    public String getTaskName() {
        return "retry.sync.data";
    }
}
