package com.bcxin.signature.components;

import com.bcxin.backend.core.edis.EDIConstants;
import com.bcxin.signature.util.ftp.FtpConnection;
import com.bcxin.signature.util.ftp.FtpUtil;
import com.bcxin.signature.util.ftp.ThreadFtpContext;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
public class JTLZPendingQueueComponent {
    /**
     * 获取待处理的全部队列信息
     * @return
     */
    public Collection<String> getPendingContentFiles(String filePrefix) {
        FtpConnection topFtp = ThreadFtpContext.getFtpConnection();
        Collection<String> directlyFiles = FtpUtil.getDirectlyFiles(topFtp, filePrefix);

        return directlyFiles;
    }

    public Collection<String> getMetaFiles(DocumentPushProvider.DocumentType documentType,int limit) {

        String filePrefixMeta = EDIConstants.PUSH_IN_FILE_PREFIX_META_ZGZ;
        if (documentType == DocumentPushProvider.DocumentType.Document) {
            filePrefixMeta = EDIConstants.PUSH_IN_FILE_PREFIX_META_DOCUMENT;
        }

        return getMetaFilesWithPrefix(filePrefixMeta, limit);
    }

    public Collection<String> getMetaFilesWithPrefix(String filePrefixMeta, int limit){
        FtpConnection topFtp = ThreadFtpContext.getFtpConnection();

        Collection<String> metaFiles = FtpUtil.getFiles(topFtp, filePrefixMeta, limit);

        return metaFiles;
    }
}
