/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.approval.utils;

import com.bcxin.backend.domain.approval.entities.dest.BjGaServiceStatisticOdsEntity;
import com.bcxin.backend.domain.approval.entities.source.BjApprovalDataEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public class DataTransformUtil {
    public static Collection<BjGaServiceStatisticOdsEntity> trans2BjGaServiceStatisticOdsEntity(Collection<BjApprovalDataEntity> approvalDatas) {
        if (approvalDatas == null || approvalDatas.isEmpty()) {
            return Collections.emptyList();
        }
        Collection bjGaServiceStatisticOdsEntities = approvalDatas.stream().map(approvalData -> {
            BjGaServiceStatisticOdsEntity entity = new BjGaServiceStatisticOdsEntity();
            entity.setProjectNo(approvalData.getId());
            entity.setTaskName(approvalData.getType());
            entity.setApplyerName(approvalData.getApplicantName());
            entity.setApplyerCode(approvalData.getApplicantIdCardNumber());
            entity.setOrgName(approvalData.getOrgName());
            entity.setPoliceStation(approvalData.getPoliceStation());
            int auditStatus = 5;
            try {
                auditStatus = Integer.parseInt(approvalData.getAuditStatus());
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (auditStatus) {
                case 0: 
                case 1: 
                case 4: {
                    entity.setTransactionState(2);
                    break;
                }
                case 2: 
                case 3: {
                    entity.setTransactionState(1);
                    break;
                }
                default: {
                    entity.setTransactionState(3);
                }
            }
            entity.setApplyDate(approvalData.getCreatedTime());
            return entity;
        }).collect(Collectors.toList());
        return bjGaServiceStatisticOdsEntities;
    }
}

