/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.core.utils;

import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.core.exceptions.SaasRetryableException;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class RetryUtil {
    public static <T> T execute(Callable<T> function, int retryCount) {
        try {
            Retryer retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(SaasRetryableException.class).withStopStrategy(StopStrategies.stopAfterAttempt((int)retryCount)).withWaitStrategy(WaitStrategies.fixedWait((long)50L, (TimeUnit)TimeUnit.MILLISECONDS)).build();
            return (T)retryer.call(() -> {
                try {
                    return function.call();
                }
                catch (Exception e) {
                    if (!ExceptionUtils.getStackMessage(e).contains("504")) {
                        throw new SaasRetryableException(e);
                    }
                    throw e;
                }
            });
        }
        catch (Exception e) {
            throw new SaasBadException(e);
        }
    }

    public static <T> T execute(Callable<T> function) {
        return RetryUtil.execute(function, 5);
    }
}

