/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.core.utils;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.core.utils.JsonUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpRequestUtil {
    public static JSONObject get(String requestUrl, String outputStr) throws Exception {
        return HttpRequestUtil.request(requestUrl, "GET", outputStr);
    }

    public static JSONObject post(String requestUrl, String outputStr) throws Exception {
        return HttpRequestUtil.request(requestUrl, "POST", outputStr);
    }

    public static JSONObject put(String requestUrl, String outputStr) throws Exception {
        return HttpRequestUtil.request(requestUrl, "PUT", outputStr);
    }

    public static JSONObject delete(String requestUrl, String outputStr) throws Exception {
        return HttpRequestUtil.request(requestUrl, "DELETE", outputStr);
    }

    private static JSONObject request(String requestUrl, String requestMethod, String outputStr) throws Exception {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        String message = "\u5b8c\u6210";
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestProperty("contentType", "UTF-8");
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            } else {
                httpUrlConn.setRequestProperty("content-type", "application/json");
                httpUrlConn.setRequestProperty("dataType", "json");
            }
            if (null != outputStr) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            jsonObject = (JSONObject)JsonUtil.parseObject(buffer.toString());
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                message = ExceptionUtils.getStackMessage(e);
                if (e instanceof ConnectException) {
                    throw new Exception("server connection timed out.");
                }
                throw new Exception("http request error:" + e.getMessage());
            }
            catch (Throwable throwable) {
                JSONObject logParams = new JSONObject();
                logParams.put("requestUrl", (Object)requestUrl);
                logParams.put("requestMethod", (Object)requestMethod);
                logParams.put("outputStr", (Object)outputStr);
                logParams.put("error", (Object)message);
                logParams.put("response", jsonObject);
                throw throwable;
            }
        }
        JSONObject logParams = new JSONObject();
        logParams.put("requestUrl", (Object)requestUrl);
        logParams.put("requestMethod", (Object)requestMethod);
        logParams.put("outputStr", (Object)outputStr);
        logParams.put("error", (Object)message);
        logParams.put("response", (Object)jsonObject);
        return jsonObject;
    }
}

