/*
 * Decompiled with CFR 0.152.
 */
package com.vivo.push.sdk.server;

import com.vivo.push.sdk.common.Constants;
import com.vivo.push.sdk.common.ExceptionStatusEnum;
import com.vivo.push.sdk.notofication.Message;
import com.vivo.push.sdk.notofication.TargetMessage;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Validation {
    public static void validatePublicMessage(Message publicMessage) {
        if (Validation.isBlank(publicMessage.getRequestId())) {
            Validation.errorDisplay(ExceptionStatusEnum.REQUEST_ID_EMPTY);
        }
        if (publicMessage.getRequestId().length() > 64) {
            Validation.errorDisplay(ExceptionStatusEnum.REQUEST_ID_LENGTH_INVALID);
        }
        if (Validation.isBlank(publicMessage.getTitle())) {
            Validation.errorDisplay(ExceptionStatusEnum.TITLE_EMPTY);
        }
        if (Validation.caculateCharSize(publicMessage.getTitle()) > 40) {
            Validation.errorDisplay(ExceptionStatusEnum.TITLE_LENGTH_INVALID);
        }
        if (Validation.isBlank(publicMessage.getContent())) {
            Validation.errorDisplay(ExceptionStatusEnum.CONTENT_EMPTY);
        }
        if (Validation.caculateCharSize(publicMessage.getContent()) > 100) {
            Validation.errorDisplay(ExceptionStatusEnum.CONTENT_LENGTH_INVALID);
        }
        if (publicMessage.getNotifyType() == 0 || publicMessage.getNotifyType() < 1 || publicMessage.getNotifyType() > 4) {
            Validation.errorDisplay(ExceptionStatusEnum.NOTIFY_TYPE_INVALID);
        }
        if (publicMessage.getSkipType() == 0 || publicMessage.getSkipType() < 1 || publicMessage.getSkipType() > 4) {
            Validation.errorDisplay(ExceptionStatusEnum.SKIP_TYPE_INVALID);
        }
        if (publicMessage.getSkipType() == 2) {
            if (Validation.isBlank(publicMessage.getSkipContent())) {
                Validation.errorDisplay(ExceptionStatusEnum.SKIP_TYPE_2_SKIP_CONTENT_EMPTY);
            }
            if (publicMessage.getSkipContent().length() > 1000) {
                Validation.errorDisplay(ExceptionStatusEnum.SKIP_TYPE_2_SKIP_CONTENT_LENGTH_INVALID);
            }
        }
        if (publicMessage.getSkipType() == 3) {
            if (Validation.isBlank(publicMessage.getSkipContent())) {
                Validation.errorDisplay(ExceptionStatusEnum.SKIP_TYPE_3_SKIP_CONTENT_EMPTY);
            }
            if (publicMessage.getSkipContent().length() > 1024) {
                Validation.errorDisplay(ExceptionStatusEnum.SKIP_TYPE_3_SKIP_CONTENT_LENGTH_INVALID);
            }
        }
        if (publicMessage.getSkipType() == 4) {
            if (Validation.isBlank(publicMessage.getSkipContent())) {
                Validation.errorDisplay(ExceptionStatusEnum.SKIP_TYPE_4_SKIP_CONTENT_EMPTY);
            }
            if (publicMessage.getSkipContent().length() > 1024) {
                Validation.errorDisplay(ExceptionStatusEnum.SKIP_TYPE_4_SKIP_CONTENT_LENGTH_INVALID);
            }
        }
        if (publicMessage.getNetworkType() != -1 && publicMessage.getNetworkType() != 1) {
            Validation.errorDisplay(ExceptionStatusEnum.NETWORK_TYPE_INVALID);
        }
        if (publicMessage.getClientCustomMap() != null) {
            Set<Map.Entry<String, String>> set = publicMessage.getClientCustomMap().entrySet();
            if (set.size() > 10) {
                Validation.errorDisplay(ExceptionStatusEnum.CLIENT_CUSTOM_MAP_SIZE_INVALID);
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : set) {
                if (entry.getKey() == null || entry.getKey().length() > 1024 || entry.getValue() == null || entry.getValue().length() > 1024) {
                    Validation.errorDisplay(ExceptionStatusEnum.CLIENT_CUSTOM_MAP_INVALID);
                }
                sb.append(entry.getKey()).append(entry.getValue());
            }
            if (sb != null && sb.toString().length() > 1024) {
                Validation.errorDisplay(ExceptionStatusEnum.CLIENT_CUSTOM_MAP_INVALID);
            }
        }
    }

    protected static void validateSingleMessage(Message singleMessage) {
        if (Validation.isBlank(singleMessage.getAlias()) && Validation.isBlank(singleMessage.getRegId())) {
            Validation.errorDisplay(ExceptionStatusEnum.ALIAS_AND_REGID_EMPTY);
        }
        if (Validation.isBlank(singleMessage.getRegId()) && !Validation.isBlank(singleMessage.getAlias()) && singleMessage.getAlias().length() > 40) {
            Validation.errorDisplay(ExceptionStatusEnum.ALIAS_LENGTH_INVALID);
        }
        if (!Validation.isBlank(singleMessage.getRegId()) && singleMessage.getRegId().length() != 23) {
            Validation.errorDisplay(ExceptionStatusEnum.REGID_INVALID);
        }
        if (!Validation.isEmpty(singleMessage.getExtra().get("callback")) && singleMessage.getExtra().get("callback").length() > 128) {
            Validation.errorDisplay(ExceptionStatusEnum.EXTRA_CALLBACK_LENGTH_INVALID);
        }
        if (!Validation.isEmpty(singleMessage.getExtra().get("callback.param")) && singleMessage.getExtra().get("callback.param").length() > 64) {
            Validation.errorDisplay(ExceptionStatusEnum.EXTRA_CALLBACKPARAM_LENGTH_INVALID);
        }
        if (singleMessage.getTimeToLive() != 0 && (singleMessage.getTimeToLive() > Constants.MAX_TIME_TO_LIVE || singleMessage.getTimeToLive() < Constants.SINGLE_MIN_TIME_TO_LIVE)) {
            Validation.errorDisplay(ExceptionStatusEnum.TIME_TO_LIVE_INVALID);
        }
    }

    protected static void validateLiveTime(Message listMessage) {
        if (listMessage.getTimeToLive() != 0 && (listMessage.getTimeToLive() > Constants.MAX_TIME_TO_LIVE || listMessage.getTimeToLive() < Constants.MIN_TIME_TO_LIVE)) {
            Validation.errorDisplay(ExceptionStatusEnum.TIME_TO_LIVE_INVALID);
        }
    }

    public static void validateTargetMessage(TargetMessage targetMessage) {
        if (Validation.isBlank(targetMessage.getRequestId())) {
            Validation.errorDisplay(ExceptionStatusEnum.REQUEST_ID_EMPTY);
        }
        if (targetMessage.getRequestId().length() > 64) {
            Validation.errorDisplay(ExceptionStatusEnum.REQUEST_ID_LENGTH_INVALID);
        }
        if (Validation.isBlank(targetMessage.getTaskId())) {
            Validation.errorDisplay(ExceptionStatusEnum.TASK_ID_EMPTY);
        }
        if (Validation.isEmpty(targetMessage.getRegIds()) && Validation.isEmpty(targetMessage.getAliases())) {
            Validation.errorDisplay(ExceptionStatusEnum.ALIASES_AND_REGIDS_EMPTY);
        }
        if (!Validation.isEmpty(targetMessage.getAliases())) {
            if (targetMessage.getAliases().size() > 1000 || targetMessage.getAliases().size() < 2) {
                Validation.errorDisplay(ExceptionStatusEnum.ALIASES_SIZE_INVALID);
            }
            for (String alias : targetMessage.getAliases()) {
                if (alias.length() <= 40) continue;
                Validation.errorDisplay(ExceptionStatusEnum.ALIAS_LENGTH_INVALID);
            }
        }
        if (!Validation.isEmpty(targetMessage.getRegIds())) {
            if (targetMessage.getRegIds().size() > 1000 || targetMessage.getRegIds().size() < 2) {
                Validation.errorDisplay(ExceptionStatusEnum.REGIDS_SIZE_INVALID);
            }
            for (String regId : targetMessage.getRegIds()) {
                if (regId.length() == 23) continue;
                Validation.errorDisplay(ExceptionStatusEnum.REGID_INVALID);
            }
        }
    }

    protected static void validateTaskIds(Set<String> taskIds) {
        if (Validation.isEmpty(taskIds)) {
            Validation.errorDisplay(ExceptionStatusEnum.TASK_IDS_EMPTY);
        } else if (taskIds.size() > 100) {
            Validation.errorDisplay(ExceptionStatusEnum.TASK_IDS_SIZE_INVALID);
        }
    }

    private static int caculateCharSize(String str) {
        if (str == null) {
            return 0;
        }
        int chineseCharSize = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!Validation.isChinese(str.charAt(i))) continue;
            ++chineseCharSize;
        }
        return str.length() + chineseCharSize;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D) {
            return true;
        }
        if (ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
            return true;
        }
        return ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    static <T> T nonNull(T argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        return argument;
    }

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    private static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static void errorDisplay(ExceptionStatusEnum statusEnum) {
        throw new IllegalArgumentException("ParameterError: " + statusEnum.getCode() + ", \u201c" + statusEnum.getMessage() + "\u201d");
    }
}

