/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.push.sdk.ErrorCode;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Region;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.TargetedMessage;
import com.xiaomi.xmpush.server.XMStringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Sender
extends HttpBase {
    protected JSONObject lastResult;
    private static final int BROADCAST_TOPIC_MAX = 5;
    private static final String TOPIC_SPLITTER = ";$;";

    public Sender(String security) {
        super(Sender.nonNull(security));
    }

    public Sender(String security, boolean isVip) {
        super(Sender.nonNull(security), isVip);
    }

    public Sender(String security, Region region) {
        super(Sender.nonNull(security), region);
    }

    public Sender(String security, String token) {
        super(Sender.nonNull(security), Sender.nonNull(token));
    }

    public Sender(String security, String token, boolean isVip) {
        super(Sender.nonNull(security), Sender.nonNull(token), isVip);
    }

    public Sender(String security, String token, Region region) {
        super(Sender.nonNull(security), Sender.nonNull(token), region);
    }

    public Result send(Message message, String registrationId, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send message " + message + " to regIds " + registrationId);
            }
            boolean bl = tryAgain = (result = this.sendNoRetry(message, registrationId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private Result sendHybridMessageByRegId(Message message, String registrationId, boolean isDebug, int retries) throws IOException, ParseException {
        boolean tryAgain;
        message.getExtra().put("push_server_action", "hybrid_message");
        if (isDebug) {
            message.getExtra().put("hybrid_debug", "1");
        }
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send message " + message + " to regIds " + registrationId);
            }
            boolean bl = tryAgain = (result = this.sendHybridMessageByRegIdNoRetry(message, registrationId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result broadcastHybridAll(Message message, int retries) throws IOException, ParseException {
        return this.broadcastHybridAll(message, false, retries);
    }

    public Result broadcastHybridAll(Message message, boolean isDebug, int retries) throws IOException, ParseException {
        message.getExtra().put("push_server_action", "hybrid_message");
        if (isDebug) {
            message.getExtra().put("hybrid_debug", "1");
        }
        return this.broadcastAll(message, retries);
    }

    public Result broadcast(Message message, String topic, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to broadcast message " + message + " to topic: " + topic);
            }
            boolean bl = tryAgain = (result = this.broadcastNoRetry(message, topic)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result multiTopicBroadcast(Message message, List<String> topics, BROADCAST_TOPIC_OP topicOp, int retries) throws IOException, ParseException, IllegalArgumentException {
        Result result;
        if (topics == null || topics.size() <= 0 || topics.size() > 5) {
            throw new IllegalArgumentException("topics size invalid");
        }
        if (topics.size() == 1) {
            return this.broadcast(message, topics.get(0), retries);
        }
        int attempt = 0;
        int backoff = 1000;
        boolean tryAgain = false;
        do {
            logger.fine("Attempt #" + ++attempt + " to broadcast message " + message + " to topic: " + topics.get(0) + " op=" + topicOp.toString());
            result = this.multiTopicBroadcastNoRetry(message, topics, topicOp);
            boolean bl = tryAgain = result == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result broadcastAll(Message message, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to broadcast message " + message + " to all");
            }
            boolean bl = tryAgain = (result = this.broadcastAllNoRetry(message)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result sendToAlias(Message message, String alias, int retries) throws IOException, ParseException {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(alias);
        return this.sendToAlias(message, aliases, retries);
    }

    public Result sendToAlias(Message message, List<String> aliases, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send message " + message + " to alias " + aliases);
            }
            boolean bl = tryAgain = (result = this.sendToAliasNoRetry(message, aliases)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result sendToRegion(Message message, List<String> regions, int retries) throws IOException, ParseException {
        Result result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send message " + message + " to regions " + regions);
            }
            boolean bl = tryAgain = (result = this.sendToRegionNoRetry(message, regions)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private Result sendToAliasNoRetry(Message message, List<String> aliases) throws IOException, ParseException {
        StringBuilder body = Sender.newBodyWithArrayParameters("alias", aliases);
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V3_ALIAS_MESSAGE, message, body);
    }

    private Result sendToRegionNoRetry(Message message, List<String> regions) throws IOException, ParseException {
        StringBuilder body = Sender.newBodyWithArrayParameters("region", regions);
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V2_REGION_MESSAGE, message, body);
    }

    public Result sendToUserAccount(Message message, String userAccount, int retries) throws IOException, ParseException {
        ArrayList<String> userAccounts = new ArrayList<String>();
        userAccounts.add(userAccount);
        return this.sendToUserAccount(message, userAccounts, retries);
    }

    public Result sendToGeoFencing(Message message, List<String> geoFencingIds, int geoAction, int retries) throws IOException, ParseException {
        Result result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send message " + message + " to geo fencing " + geoFencingIds);
            }
            boolean bl = tryAgain = (result = this.sendToGeoFencingNoRetry(message, geoFencingIds, geoAction)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result sendHybridMessageByRegId(Message message, List<String> regIds, int retries) throws IOException, ParseException {
        return this.sendHybridMessageByRegId(message, regIds, false, retries);
    }

    public Result sendHybridMessageByRegId(Message message, List<String> regIds, boolean isDebug, int retries) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder(regIds.get(0));
        for (int i = 1; i < regIds.size(); ++i) {
            sb.append(",").append(regIds.get(i));
        }
        return this.sendHybridMessageByRegId(message, sb.toString(), isDebug, retries);
    }

    public Result sendToGeoGroup(Message message, String geoGroupId, int geoAction, int retries) throws IOException, ParseException {
        Result result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send message " + message + " to geo group " + geoGroupId);
            }
            boolean bl = tryAgain = (result = this.sendToGeoGroupNoRetry(message, geoGroupId, geoAction)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private Result sendToGeoFencingNoRetry(Message message, List<String> geoFencingIds, int geoAction) throws IOException, ParseException {
        StringBuilder body = Sender.newBodyWithArrayParameters("geo_id", geoFencingIds);
        Sender.addParameter(body, "geo_action", URLEncoder.encode(Integer.toString(geoAction), "UTF-8"));
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V2_GEO_MESSAGE, message, body);
    }

    private Result sendToGeoGroupNoRetry(Message message, String geoGroupId, int geoAction) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("geo_group_id", URLEncoder.encode(geoGroupId, "UTF-8"));
        Sender.addParameter(body, "geo_action", URLEncoder.encode(Integer.toString(geoAction), "UTF-8"));
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V2_GEO_GROUP_MESSAGE, message, body);
    }

    public Result sendToUserAccount(Message message, List<String> userAccounts, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send message " + message + " to user account " + userAccounts);
            }
            boolean bl = tryAgain = (result = this.sendToUserAccountNoRetry(message, userAccounts)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private Result sendToUserAccountNoRetry(Message message, List<String> userAccounts) throws IOException, ParseException {
        StringBuilder body = Sender.newBodyWithArrayParameters("user_account", userAccounts);
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V2_USERACCOUNT_MESSAGE, message, body);
    }

    private Result sendNoRetry(Message message, String registrationId) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("registration_id", URLEncoder.encode(registrationId, "UTF-8"));
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V3_REGID_MESSAGE, message, body);
    }

    private Result sendHybridMessageByRegIdNoRetry(Message message, String registrationId) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("registration_id", URLEncoder.encode(registrationId, "UTF-8"));
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V2_REGID_MESSAGE, message, body);
    }

    private Result broadcastNoRetry(Message message, String topic) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("topic", URLEncoder.encode(topic, "UTF-8"));
        if (Sender.isMultiPackageName(message)) {
            return this.sendMultiPackageNameMessageNoRetry(Constants.XmPushRequestPath.V3_BROADCAST, message, body);
        }
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V2_BROADCAST, message, body);
    }

    private Result multiTopicBroadcastNoRetry(Message message, List<String> topics, BROADCAST_TOPIC_OP topicOp) throws IOException, ParseException, IllegalArgumentException {
        if (topics == null || topics.size() <= 0 || topics.size() > 5) {
            throw new IllegalArgumentException("topics size invalid");
        }
        if (topics.size() == 1) {
            return this.broadcastNoRetry(message, topics.get(0));
        }
        StringBuilder body = Sender.newBody("topic_op", topicOp.toString());
        StringBuilder topicsStr = new StringBuilder();
        for (String topic : topics) {
            if (topicsStr.length() != 0) {
                topicsStr.append(TOPIC_SPLITTER);
            }
            topicsStr.append(topic);
        }
        Sender.addParameter(body, "topics", URLEncoder.encode(topicsStr.toString(), "UTF-8"));
        if (Sender.isMultiPackageName(message)) {
            return this.sendMultiPackageNameMessageNoRetry(Constants.XmPushRequestPath.V3_MULTI_TOPIC_BROADCAST, message, body);
        }
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V2_MULTI_TOPIC_BROADCAST, message, body);
    }

    private Result broadcastAllNoRetry(Message message) throws IOException, ParseException {
        StringBuilder body = new StringBuilder("");
        if (Sender.isMultiPackageName(message)) {
            return this.sendMultiPackageNameMessageNoRetry(Constants.XmPushRequestPath.V3_BROADCAST_TO_ALL, message, body);
        }
        return this.sendMessageNoRetry(Constants.XmPushRequestPath.V2_BROADCAST_TO_ALL, message, body);
    }

    /*
     * WARNING - void declaration
     */
    private Result sendMessageNoRetry(Constants.XmPushRequestPath requestPath, Message message, StringBuilder target) throws IOException, ParseException {
        void var8_13;
        String string;
        Map<String, String> apsProperFieldsInfo;
        Long timeToLive;
        Map<String, String> extraInfo = message.getExtra();
        StringBuilder body = new StringBuilder(target);
        if (!XMStringUtils.isEmpty(message.getCollapseKey())) {
            Sender.addParameter(body, "collapse_key", URLEncoder.encode(message.getCollapseKey(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(message.getRestrictedPackageName())) {
            Sender.addParameter(body, "restricted_package_name", URLEncoder.encode(message.getRestrictedPackageName(), "UTF-8"));
        }
        if ((timeToLive = message.getTimeToLive()) != null) {
            Sender.addParameter(body, "time_to_live", Long.toString(timeToLive));
        }
        if (!XMStringUtils.isEmpty(message.getPayload())) {
            Sender.addParameter(body, "payload", URLEncoder.encode(message.getPayload(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(message.getTitle())) {
            Sender.addParameter(body, "title", URLEncoder.encode(message.getTitle(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(message.getDescription())) {
            Sender.addParameter(body, "description", URLEncoder.encode(message.getDescription(), "UTF-8"));
        }
        if (message.getNotifyType() != null) {
            Sender.addParameter(body, "notify_type", Integer.toString(message.getNotifyType()));
        }
        if (message.getPassThrough() != null) {
            Sender.addParameter(body, "pass_through", Integer.toString(message.getPassThrough()));
        }
        if (message.getNotifyId() != null) {
            Sender.addParameter(body, "notify_id", Integer.toString(message.getNotifyId()));
        }
        if (message.getTimeToSend() != null) {
            Sender.addParameter(body, "time_to_send", Long.toString(message.getTimeToSend()));
        }
        if (extraInfo != null && !extraInfo.isEmpty()) {
            for (Map.Entry<String, String> entry : extraInfo.entrySet()) {
                Sender.addParameter(body, URLEncoder.encode("extra." + entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        if ((apsProperFieldsInfo = message.getApsProperFields()) != null && !apsProperFieldsInfo.isEmpty()) {
            for (Map.Entry<String, String> entry : apsProperFieldsInfo.entrySet()) {
                Sender.addParameter(body, URLEncoder.encode("aps_proper_fields." + entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        if (!(string = body.toString()).isEmpty() && string.charAt(0) == '&') {
            String string2 = body.toString().substring(1);
        }
        return this.sendMessage(requestPath, (String)var8_13);
    }

    /*
     * WARNING - void declaration
     */
    private Result sendMultiPackageNameMessageNoRetry(Constants.XmPushRequestPath requestPath, Message message, StringBuilder target) throws IOException, ParseException {
        void var8_13;
        String string;
        Map<String, String> apsProperFieldsInfo;
        Map<String, String> extraInfo;
        Long timeToLive;
        StringBuilder body = new StringBuilder(target);
        if (message.getRestrictedPackageNames() != null && message.getRestrictedPackageNames().length != 0) {
            Sender.nonNull(body).append('&').append((CharSequence)Sender.newBodyWithArrayParameters("restricted_package_name", Arrays.asList(message.getRestrictedPackageNames())));
        }
        if (!XMStringUtils.isEmpty(message.getCollapseKey())) {
            Sender.addParameter(body, "collapse_key", URLEncoder.encode(message.getCollapseKey(), "UTF-8"));
        }
        if ((timeToLive = message.getTimeToLive()) != null) {
            Sender.addParameter(body, "time_to_live", Long.toString(timeToLive));
        }
        if (!XMStringUtils.isEmpty(message.getPayload())) {
            Sender.addParameter(body, "payload", URLEncoder.encode(message.getPayload(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(message.getTitle())) {
            Sender.addParameter(body, "title", URLEncoder.encode(message.getTitle(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(message.getDescription())) {
            Sender.addParameter(body, "description", URLEncoder.encode(message.getDescription(), "UTF-8"));
        }
        if (message.getNotifyType() != null) {
            Sender.addParameter(body, "notify_type", Integer.toString(message.getNotifyType()));
        }
        if (message.getPassThrough() != null) {
            Sender.addParameter(body, "pass_through", Integer.toString(message.getPassThrough()));
        }
        if (message.getNotifyId() != null) {
            Sender.addParameter(body, "notify_id", Integer.toString(message.getNotifyId()));
        }
        if (message.getTimeToSend() != null) {
            Sender.addParameter(body, "time_to_send", Long.toString(message.getTimeToSend()));
        }
        if ((extraInfo = message.getExtra()) != null && !extraInfo.isEmpty()) {
            for (Map.Entry<String, String> entry : extraInfo.entrySet()) {
                Sender.addParameter(body, URLEncoder.encode("extra." + entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        if ((apsProperFieldsInfo = message.getApsProperFields()) != null && !apsProperFieldsInfo.isEmpty()) {
            for (Map.Entry<String, String> entry : apsProperFieldsInfo.entrySet()) {
                Sender.addParameter(body, URLEncoder.encode("aps_proper_fields." + entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        if (!(string = body.toString()).isEmpty() && string.charAt(0) == '&') {
            String string2 = body.toString().substring(1);
        }
        return this.sendMessage(requestPath, (String)var8_13);
    }

    private Result execScheduleJobNoRetry(Constants.XmPushRequestPath requestPath, StringBuilder target) throws IOException, ParseException {
        return this.sendMessage(requestPath, target.toString());
    }

    public Result send(Message message, List<String> regIds, int retries) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder(regIds.get(0));
        for (int i = 1; i < regIds.size(); ++i) {
            sb.append(",").append(regIds.get(i));
        }
        return this.send(message, sb.toString(), retries);
    }

    public Result send(List<TargetedMessage> messages, int retries) throws IOException, ParseException {
        return this.send(messages, retries, 0L);
    }

    public Result send(List<TargetedMessage> messages, int retries, long timeToSend) throws IOException, ParseException {
        boolean tryAgain;
        if (messages.isEmpty()) {
            logger.log(Level.WARNING, "Empty message, returned. Remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return new Result.Builder().errorCode(ErrorCode.Success).build();
        }
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        Constants.XmPushRequestPath requestPath = messages.get(0).getTargetType() == 2 ? Constants.XmPushRequestPath.V2_SEND_MULTI_MESSAGE_WITH_ALIAS : (messages.get(0).getTargetType() == 3 ? Constants.XmPushRequestPath.V2_SEND_MULTI_MESSAGE_WITH_ACCOUNT : Constants.XmPushRequestPath.V2_SEND_MULTI_MESSAGE_WITH_REGID);
        StringBuilder body = Sender.newBody("messages", URLEncoder.encode(this.toString(messages), "UTF-8"));
        Sender.addParameter(body, "time_to_send", Long.toString(timeToSend));
        String message = body.toString();
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send messages " + messages.size());
            }
            boolean bl = tryAgain = (result = this.sendMessage(requestPath, message)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result deleteScheduleJob(String jobId) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("job_id", URLEncoder.encode(jobId, "UTF-8"));
        return this.execScheduleJobNoRetry(Constants.XmPushRequestPath.V2_DELETE_SCHEDULE_JOB, body);
    }

    public Result deleteScheduleJobByJobKey(String jobKey) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("jobkey", URLEncoder.encode(jobKey, "UTF-8"));
        return this.execScheduleJobNoRetry(Constants.XmPushRequestPath.V3_DELETE_SCHEDULE_JOB, body);
    }

    public Result checkScheduleJobExist(String jobId) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("job_id", URLEncoder.encode(jobId, "UTF-8"));
        return this.execScheduleJobNoRetry(Constants.XmPushRequestPath.V2_CHECK_SCHEDULE_JOB_EXIST, body);
    }

    protected Result sendMessage(Constants.RequestPath requestPath, String message) throws IOException, ParseException {
        String responseBody;
        int status;
        HttpURLConnection conn = null;
        try {
            logger.fine("post to: " + requestPath.getPath());
            conn = this.doPost(requestPath, message);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            String msg = "Failed to send http request: remote server " + this.remoteHost + "(" + this.remoteIp + ")";
            logger.log(Level.WARNING, msg, e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Sender.getAndClose(conn.getErrorStream());
                logger.finest("Plain post error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                this.lastException = e;
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Sender.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        try {
            JSONObject json;
            JSONParser parser = new JSONParser();
            this.lastResult = json = (JSONObject)parser.parse(responseBody);
            return new Result.Builder().fromJson(json);
        }
        catch (ParseException e) {
            logger.log(Level.WARNING, "Exception parsing response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            throw new IOException("Invalid response from XmPush: " + responseBody + "\n server " + this.remoteHost + " ip " + this.remoteIp);
        }
    }

    private String toString(List<TargetedMessage> messages) {
        JSONArray jsonArray = new JSONArray();
        for (TargetedMessage message : messages) {
            JSONObject jsonMessage = new JSONObject();
            JSONObject msg = this.toJson(message.getMessage());
            Sender.tryAddJson(jsonMessage, "target", message.getTarget());
            Sender.tryAddJson(jsonMessage, "message", msg);
            jsonArray.add((Object)jsonMessage);
        }
        return jsonArray.toString();
    }

    private JSONObject toJson(Message msg) {
        JSONObject json = new JSONObject();
        Sender.tryAddJson(json, "payload", msg.getPayload());
        Sender.tryAddJson(json, "title", msg.getTitle());
        Sender.tryAddJson(json, "description", msg.getDescription());
        Sender.tryAddJson(json, "notify_type", msg.getNotifyType());
        Sender.tryAddJson(json, "notify_id", msg.getNotifyId());
        Sender.tryAddJson(json, "pass_through", msg.getPassThrough());
        Sender.tryAddJson(json, "restricted_package_name", msg.getRestrictedPackageName());
        Sender.tryAddJson(json, "time_to_live", msg.getTimeToLive());
        Sender.tryAddJson(json, "time_to_send", msg.getTimeToSend());
        Sender.tryAddJson(json, "collapse_key", msg.getCollapseKey());
        Map<String, String> extraInfo = msg.getExtra();
        if (extraInfo != null && !extraInfo.isEmpty()) {
            JSONObject extraJson = new JSONObject();
            for (Map.Entry<String, String> entry : extraInfo.entrySet()) {
                Sender.tryAddJson(extraJson, entry.getKey(), entry.getValue());
            }
            Sender.tryAddJson(json, "extra", extraJson);
        }
        return json;
    }

    protected static void tryAddJson(JSONObject json, String parameterName, Object value) {
        if (!XMStringUtils.isEmpty(parameterName) && value != null) {
            json.put((Object)parameterName, value);
        }
    }

    private static final Map<String, String> newKeyValues(String key, String value) {
        HashMap<String, String> keyValues = new HashMap<String, String>(1);
        keyValues.put(Sender.nonNull(key), Sender.nonNull(value));
        return keyValues;
    }

    private static boolean isMultiPackageName(Message message) {
        String[] packageNames = message.getRestrictedPackageNames();
        return packageNames == null || packageNames.length == 0 || message.getRestrictedPackageNames().length >= 2;
    }

    @Override
    protected void prepareConnection(HttpURLConnection conn) {
        super.prepareConnection(conn);
        if (Constants.INCLUDE_LAST_METRICS && this.lastResult != null && this.lastResult.containsKey((Object)"trace_id")) {
            String traceId = (String)this.lastResult.get((Object)"trace_id");
            conn.setRequestProperty("X-PUSH-LAST-REQUEST-ID", traceId);
        }
    }

    public static enum BROADCAST_TOPIC_OP {
        UNION,
        INTERSECTION,
        EXCEPT;

    }
}

