'use strict';

exports.__esModule = true;
exports.getOffset = getOffset;
exports.traverseTreeNodes = traverseTreeNodes;
exports.updateCheckState = updateCheckState;
exports.getCheck = getCheck;
exports.getStrictlyValue = getStrictlyValue;
exports.isPositionPrefix = isPositionPrefix;

var _react = require('react');

function getOffset(ele) {
  if (!ele.getClientRects().length) {
    return { top: 0, left: 0 };
  }

  var rect = ele.getBoundingClientRect();
  if (rect.width || rect.height) {
    var doc = ele.ownerDocument;
    var win = doc.defaultView;
    var docElem = doc.documentElement;

    return {
      top: rect.top + win.pageYOffset - docElem.clientTop,
      left: rect.left + win.pageXOffset - docElem.clientLeft
    };
  }

  return rect;
} /* eslint no-loop-func: 0*/
function traverseTreeNodes(treeNodes, callback) {
  var traverse = function traverse(subTreeNodes, level, parentsChildrenPos, parentPos) {
    if (Array.isArray(subTreeNodes)) {
      subTreeNodes = subTreeNodes.filter(function (item) {
        return !!item;
      });
    }
    _react.Children.forEach(subTreeNodes, function (item, index) {
      var pos = level + '-' + index;
      parentsChildrenPos.push(pos); // Note: side effect

      var childrenPos = [];
      if (item.props.children && item.type && item.type.isTreeNode) {
        traverse(item.props.children, pos, childrenPos, pos);
      }
      callback(item, index, pos, item.key || pos, childrenPos, parentPos);
    });
  };
  traverse(treeNodes, 0, []);
}

function updateCheckState(obj, checkedPosition, checkIt) {
  var childrenLoop = function childrenLoop(parentObj) {
    parentObj.childrenPos.forEach(function (childPos) {
      var childObj = obj[childPos];
      // User click don't change disabled item checked state
      if (!childObj.disableCheckbox && !childObj.disabled) {
        childObj.halfChecked = false;
        childObj.checked = checkIt;
      }
      childrenLoop(childObj);
    });
  };

  childrenLoop(obj[checkedPosition]);

  var parentLoop = function parentLoop(childObj) {
    if (!childObj.parentPos) return;
    var parentObj = obj[childObj.parentPos];

    var childrenCount = parentObj.childrenPos.length;

    var checkedChildrenCount = 0;
    parentObj.childrenPos.forEach(function (childPos) {
      if (obj[childPos].disableCheckbox) {
        childrenCount -= 1;
        return;
      }
      if (obj[childPos].checked === true) checkedChildrenCount++;else if (obj[childPos].halfChecked === true) checkedChildrenCount += 0.5;
    });

    if (checkedChildrenCount === childrenCount) {
      parentObj.checked = true;
      parentObj.halfChecked = false;
    } else if (checkedChildrenCount > 0) {
      parentObj.halfChecked = true;
      parentObj.checked = false;
    } else {
      parentObj.checked = false;
      parentObj.halfChecked = false;
    }
    parentLoop(parentObj);
  };

  parentLoop(obj[checkedPosition]);
}

function getCheck(treeNodesStates) {
  var halfCheckedKeys = [];
  var checkedKeys = [];
  var checkedNodes = [];
  var checkedNodesPositions = [];
  Object.keys(treeNodesStates).forEach(function (item) {
    var itemObj = treeNodesStates[item];
    if (itemObj.checked) {
      checkedKeys.push(itemObj.key);
      checkedNodes.push(itemObj.node);
      checkedNodesPositions.push({ node: itemObj.node, pos: item });
    } else if (itemObj.halfChecked) {
      halfCheckedKeys.push(itemObj.key);
    }
  });
  return {
    halfCheckedKeys: halfCheckedKeys,
    checkedKeys: checkedKeys,
    checkedNodes: checkedNodes,
    checkedNodesPositions: checkedNodesPositions
  };
}

function getStrictlyValue(checkedKeys, halfChecked) {
  if (halfChecked) {
    return { checked: checkedKeys, halfChecked: halfChecked };
  }
  return checkedKeys;
}

function isPositionPrefix(smallPos, bigPos) {
  if (bigPos.length < smallPos.length) {
    return false;
  }
  // attention: "0-0-1" "0-0-10"
  if (bigPos.length > smallPos.length && bigPos.charAt(smallPos.length) !== '-') {
    return false;
  }
  return bigPos.substr(0, smallPos.length) === smallPos;
}