'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _rcTrigger = require('rc-trigger');

var _rcTrigger2 = _interopRequireDefault(_rcTrigger);

var _Panel = require('./Panel');

var _Panel2 = _interopRequireDefault(_Panel);

var _placements = require('./placements');

var _placements2 = _interopRequireDefault(_placements);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function noop() {}

function refFn(field, component) {
  this[field] = component;
}

var Picker = function (_Component) {
  (0, _inherits3['default'])(Picker, _Component);

  function Picker(props) {
    (0, _classCallCheck3['default'])(this, Picker);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Picker.__proto__ || Object.getPrototypeOf(Picker)).call(this, props));

    _initialiseProps.call(_this);

    _this.saveInputRef = refFn.bind(_this, 'picker');
    _this.savePanelRef = refFn.bind(_this, 'panelInstance');
    var defaultOpen = props.defaultOpen,
        defaultValue = props.defaultValue,
        _props$open = props.open,
        open = _props$open === undefined ? defaultOpen : _props$open,
        _props$value = props.value,
        value = _props$value === undefined ? defaultValue : _props$value;

    _this.state = {
      open: open,
      value: value
    };
    return _this;
  }

  (0, _createClass3['default'])(Picker, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var value = nextProps.value,
          open = nextProps.open;

      if ('value' in nextProps) {
        this.setState({
          value: value
        });
      }
      if (open !== undefined) {
        this.setState({ open: open });
      }
    }
  }, {
    key: 'setValue',
    value: function setValue(value) {
      if (!('value' in this.props)) {
        this.setState({
          value: value
        });
      }
      this.props.onChange(value);
    }
  }, {
    key: 'getFormat',
    value: function getFormat() {
      var _props = this.props,
          format = _props.format,
          showHour = _props.showHour,
          showMinute = _props.showMinute,
          showSecond = _props.showSecond,
          use12Hours = _props.use12Hours;

      if (format) {
        return format;
      }

      if (use12Hours) {
        var fmtString = [showHour ? 'h' : '', showMinute ? 'mm' : '', showSecond ? 'ss' : ''].filter(function (item) {
          return !!item;
        }).join(':');

        return fmtString.concat(' a');
      }

      return [showHour ? 'HH' : '', showMinute ? 'mm' : '', showSecond ? 'ss' : ''].filter(function (item) {
        return !!item;
      }).join(':');
    }
  }, {
    key: 'getPanelElement',
    value: function getPanelElement() {
      var _props2 = this.props,
          prefixCls = _props2.prefixCls,
          placeholder = _props2.placeholder,
          disabledHours = _props2.disabledHours,
          disabledMinutes = _props2.disabledMinutes,
          disabledSeconds = _props2.disabledSeconds,
          hideDisabledOptions = _props2.hideDisabledOptions,
          allowEmpty = _props2.allowEmpty,
          showHour = _props2.showHour,
          showMinute = _props2.showMinute,
          showSecond = _props2.showSecond,
          defaultOpenValue = _props2.defaultOpenValue,
          clearText = _props2.clearText,
          addon = _props2.addon,
          use12Hours = _props2.use12Hours;

      return _react2['default'].createElement(_Panel2['default'], {
        clearText: clearText,
        prefixCls: prefixCls + '-panel',
        ref: this.savePanelRef,
        value: this.state.value,
        onChange: this.onPanelChange,
        onClear: this.onPanelClear,
        defaultOpenValue: defaultOpenValue,
        showHour: showHour,
        showMinute: showMinute,
        showSecond: showSecond,
        onEsc: this.onEsc,
        allowEmpty: allowEmpty,
        format: this.getFormat(),
        placeholder: placeholder,
        disabledHours: disabledHours,
        disabledMinutes: disabledMinutes,
        disabledSeconds: disabledSeconds,
        hideDisabledOptions: hideDisabledOptions,
        use12Hours: use12Hours,
        addon: addon
      });
    }
  }, {
    key: 'getPopupClassName',
    value: function getPopupClassName() {
      var _props3 = this.props,
          showHour = _props3.showHour,
          showMinute = _props3.showMinute,
          showSecond = _props3.showSecond,
          use12Hours = _props3.use12Hours,
          prefixCls = _props3.prefixCls;

      var popupClassName = this.props.popupClassName;
      // Keep it for old compatibility
      if ((!showHour || !showMinute || !showSecond) && !use12Hours) {
        popupClassName += ' ' + prefixCls + '-panel-narrow';
      }
      var selectColumnCount = 0;
      if (showHour) {
        selectColumnCount += 1;
      }
      if (showMinute) {
        selectColumnCount += 1;
      }
      if (showSecond) {
        selectColumnCount += 1;
      }
      if (use12Hours) {
        selectColumnCount += 1;
      }
      popupClassName += ' ' + prefixCls + '-panel-column-' + selectColumnCount;
      return popupClassName;
    }
  }, {
    key: 'setOpen',
    value: function setOpen(open) {
      var _props4 = this.props,
          onOpen = _props4.onOpen,
          onClose = _props4.onClose;

      if (this.state.open !== open) {
        if (!('open' in this.props)) {
          this.setState({ open: open });
        }
        if (open) {
          onOpen({ open: open });
        } else {
          onClose({ open: open });
        }
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.picker.focus();
    }
  }, {
    key: 'render',
    value: function render() {
      var _props5 = this.props,
          prefixCls = _props5.prefixCls,
          placeholder = _props5.placeholder,
          placement = _props5.placement,
          align = _props5.align,
          disabled = _props5.disabled,
          transitionName = _props5.transitionName,
          style = _props5.style,
          className = _props5.className,
          getPopupContainer = _props5.getPopupContainer,
          name = _props5.name,
          autoComplete = _props5.autoComplete;
      var _state = this.state,
          open = _state.open,
          value = _state.value;

      var popupClassName = this.getPopupClassName();
      return _react2['default'].createElement(
        _rcTrigger2['default'],
        {
          prefixCls: prefixCls + '-panel',
          popupClassName: popupClassName,
          popup: this.getPanelElement(),
          popupAlign: align,
          builtinPlacements: _placements2['default'],
          popupPlacement: placement,
          action: disabled ? [] : ['click'],
          destroyPopupOnHide: true,
          getPopupContainer: getPopupContainer,
          popupTransitionName: transitionName,
          popupVisible: open,
          onPopupVisibleChange: this.onVisibleChange
        },
        _react2['default'].createElement(
          'span',
          { className: prefixCls + ' ' + className, style: style },
          _react2['default'].createElement('input', {
            className: prefixCls + '-input',
            ref: this.saveInputRef,
            type: 'text',
            placeholder: placeholder,
            name: name,
            readOnly: true,
            onKeyDown: this.onKeyDown,
            disabled: disabled, value: value && value.format(this.getFormat()) || '',
            autoComplete: autoComplete
          }),
          _react2['default'].createElement('span', { className: prefixCls + '-icon' })
        )
      );
    }
  }]);
  return Picker;
}(_react.Component);

Picker.propTypes = {
  prefixCls: _propTypes2['default'].string,
  clearText: _propTypes2['default'].string,
  value: _propTypes2['default'].object,
  defaultOpenValue: _propTypes2['default'].object,
  disabled: _propTypes2['default'].bool,
  allowEmpty: _propTypes2['default'].bool,
  defaultValue: _propTypes2['default'].object,
  open: _propTypes2['default'].bool,
  defaultOpen: _propTypes2['default'].bool,
  align: _propTypes2['default'].object,
  placement: _propTypes2['default'].any,
  transitionName: _propTypes2['default'].string,
  getPopupContainer: _propTypes2['default'].func,
  placeholder: _propTypes2['default'].string,
  format: _propTypes2['default'].string,
  showHour: _propTypes2['default'].bool,
  showMinute: _propTypes2['default'].bool,
  showSecond: _propTypes2['default'].bool,
  style: _propTypes2['default'].object,
  className: _propTypes2['default'].string,
  popupClassName: _propTypes2['default'].string,
  disabledHours: _propTypes2['default'].func,
  disabledMinutes: _propTypes2['default'].func,
  disabledSeconds: _propTypes2['default'].func,
  hideDisabledOptions: _propTypes2['default'].bool,
  onChange: _propTypes2['default'].func,
  onOpen: _propTypes2['default'].func,
  onClose: _propTypes2['default'].func,
  addon: _propTypes2['default'].func,
  name: _propTypes2['default'].string,
  autoComplete: _propTypes2['default'].string,
  use12Hours: _propTypes2['default'].bool
};
Picker.defaultProps = {
  clearText: 'clear',
  prefixCls: 'rc-time-picker',
  defaultOpen: false,
  style: {},
  className: '',
  popupClassName: '',
  align: {},
  defaultOpenValue: (0, _moment2['default'])(),
  allowEmpty: true,
  showHour: true,
  showMinute: true,
  showSecond: true,
  disabledHours: noop,
  disabledMinutes: noop,
  disabledSeconds: noop,
  hideDisabledOptions: false,
  placement: 'bottomLeft',
  onChange: noop,
  onOpen: noop,
  onClose: noop,
  addon: noop,
  use12Hours: false
};

var _initialiseProps = function _initialiseProps() {
  var _this2 = this;

  this.onPanelChange = function (value) {
    _this2.setValue(value);
  };

  this.onPanelClear = function () {
    _this2.setValue(null);
    _this2.setOpen(false);
  };

  this.onVisibleChange = function (open) {
    _this2.setOpen(open);
  };

  this.onEsc = function () {
    _this2.setOpen(false);
    _this2.focus();
  };

  this.onKeyDown = function (e) {
    if (e.keyCode === 40) {
      _this2.setOpen(true);
    }
  };
};

exports['default'] = Picker;
module.exports = exports['default'];