'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _TableCell = require('./TableCell');

var _TableCell2 = _interopRequireDefault(_TableCell);

var _ExpandIcon = require('./ExpandIcon');

var _ExpandIcon2 = _interopRequireDefault(_ExpandIcon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var TableRow = function (_React$Component) {
  (0, _inherits3['default'])(TableRow, _React$Component);

  function TableRow() {
    var _ref;

    var _temp, _this, _ret;

    (0, _classCallCheck3['default'])(this, TableRow);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = (0, _possibleConstructorReturn3['default'])(this, (_ref = TableRow.__proto__ || Object.getPrototypeOf(TableRow)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      hovered: false,
      height: null
    }, _this.onRowClick = function (event) {
      var _this$props = _this.props,
          record = _this$props.record,
          index = _this$props.index,
          onRowClick = _this$props.onRowClick,
          expandable = _this$props.expandable,
          expandRowByClick = _this$props.expandRowByClick,
          expanded = _this$props.expanded,
          onExpand = _this$props.onExpand;

      if (expandable && expandRowByClick) {
        onExpand(!expanded, record, event, index);
      }
      onRowClick(record, index, event);
    }, _this.onRowDoubleClick = function (event) {
      var _this$props2 = _this.props,
          record = _this$props2.record,
          index = _this$props2.index,
          onRowDoubleClick = _this$props2.onRowDoubleClick;

      onRowDoubleClick(record, index, event);
    }, _this.onContextMenu = function (event) {
      var _this$props3 = _this.props,
          record = _this$props3.record,
          index = _this$props3.index,
          onRowContextMenu = _this$props3.onRowContextMenu;

      onRowContextMenu(record, index, event);
    }, _this.onMouseEnter = function (event) {
      var _this$props4 = _this.props,
          record = _this$props4.record,
          index = _this$props4.index,
          onRowMouseEnter = _this$props4.onRowMouseEnter,
          onHover = _this$props4.onHover,
          hoverKey = _this$props4.hoverKey;

      onHover(true, hoverKey);
      onRowMouseEnter(record, index, event);
    }, _this.onMouseLeave = function (event) {
      var _this$props5 = _this.props,
          record = _this$props5.record,
          index = _this$props5.index,
          onRowMouseLeave = _this$props5.onRowMouseLeave,
          onHover = _this$props5.onHover,
          hoverKey = _this$props5.hoverKey;

      onHover(false, hoverKey);
      onRowMouseLeave(record, index, event);
    }, _temp), (0, _possibleConstructorReturn3['default'])(_this, _ret);
  }

  (0, _createClass3['default'])(TableRow, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _this2 = this;

      var store = this.props.store;

      this.pushHeight();
      this.pullHeight();
      this.unsubscribe = store.subscribe(function () {
        _this2.setHover();
        _this2.pullHeight();
      });
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      var _props = this.props,
          record = _props.record,
          onDestroy = _props.onDestroy,
          index = _props.index;

      onDestroy(record, index);
      if (this.unsubscribe) {
        this.unsubscribe();
      }
    }
  }, {
    key: 'setHover',
    value: function setHover() {
      var _props2 = this.props,
          store = _props2.store,
          hoverKey = _props2.hoverKey;

      var _store$getState = store.getState(),
          currentHoverKey = _store$getState.currentHoverKey;

      if (currentHoverKey === hoverKey) {
        this.setState({ hovered: true });
      } else if (this.state.hovered === true) {
        this.setState({ hovered: false });
      }
    }
  }, {
    key: 'pullHeight',
    value: function pullHeight() {
      var _props3 = this.props,
          store = _props3.store,
          expandedRow = _props3.expandedRow,
          fixed = _props3.fixed,
          rowKey = _props3.rowKey;

      var _store$getState2 = store.getState(),
          expandedRowsHeight = _store$getState2.expandedRowsHeight;

      if (expandedRow && fixed && expandedRowsHeight[rowKey]) {
        this.setState({ height: expandedRowsHeight[rowKey] });
      }
    }
  }, {
    key: 'pushHeight',
    value: function pushHeight() {
      var _props4 = this.props,
          store = _props4.store,
          expandedRow = _props4.expandedRow,
          fixed = _props4.fixed,
          rowKey = _props4.rowKey;

      if (expandedRow && !fixed) {
        var _store$getState3 = store.getState(),
            expandedRowsHeight = _store$getState3.expandedRowsHeight;

        var height = this.trRef.getBoundingClientRect().height;
        expandedRowsHeight[rowKey] = height;
        store.setState({ expandedRowsHeight: expandedRowsHeight });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this3 = this;

      var _props5 = this.props,
          prefixCls = _props5.prefixCls,
          columns = _props5.columns,
          record = _props5.record,
          visible = _props5.visible,
          index = _props5.index,
          expandIconColumnIndex = _props5.expandIconColumnIndex,
          expandIconAsCell = _props5.expandIconAsCell,
          expanded = _props5.expanded,
          expandRowByClick = _props5.expandRowByClick,
          expandable = _props5.expandable,
          onExpand = _props5.onExpand,
          needIndentSpaced = _props5.needIndentSpaced,
          indent = _props5.indent,
          indentSize = _props5.indentSize;
      var className = this.props.className;


      if (this.state.hovered) {
        className += ' ' + prefixCls + '-hover';
      }

      var cells = [];

      var expandIcon = _react2['default'].createElement(_ExpandIcon2['default'], {
        expandable: expandable,
        prefixCls: prefixCls,
        onExpand: onExpand,
        needIndentSpaced: needIndentSpaced,
        expanded: expanded,
        record: record
      });

      for (var i = 0; i < columns.length; i++) {
        if (expandIconAsCell && i === 0) {
          cells.push(_react2['default'].createElement(
            'td',
            {
              className: prefixCls + '-expand-icon-cell',
              key: 'rc-table-expand-icon-cell'
            },
            expandIcon
          ));
        }
        var isColumnHaveExpandIcon = expandIconAsCell || expandRowByClick ? false : i === expandIconColumnIndex;
        cells.push(_react2['default'].createElement(_TableCell2['default'], {
          prefixCls: prefixCls,
          record: record,
          indentSize: indentSize,
          indent: indent,
          index: index,
          column: columns[i],
          key: columns[i].key || columns[i].dataIndex,
          expandIcon: isColumnHaveExpandIcon ? expandIcon : null
        }));
      }
      var height = this.props.height || this.state.height;
      var style = { height: height };
      if (!visible) {
        style.display = 'none';
      }

      var rowClassName = (prefixCls + ' ' + className + ' ' + prefixCls + '-level-' + indent).trim();

      return _react2['default'].createElement(
        'tr',
        {
          ref: function ref(node) {
            return _this3.trRef = node;
          },
          onClick: this.onRowClick,
          onDoubleClick: this.onRowDoubleClick,
          onMouseEnter: this.onMouseEnter,
          onMouseLeave: this.onMouseLeave,
          onContextMenu: this.onContextMenu,
          className: rowClassName,
          style: style
        },
        cells
      );
    }
  }]);
  return TableRow;
}(_react2['default'].Component);

TableRow.propTypes = {
  onDestroy: _propTypes2['default'].func,
  onRowClick: _propTypes2['default'].func,
  onRowDoubleClick: _propTypes2['default'].func,
  onRowContextMenu: _propTypes2['default'].func,
  onRowMouseEnter: _propTypes2['default'].func,
  onRowMouseLeave: _propTypes2['default'].func,
  record: _propTypes2['default'].object,
  prefixCls: _propTypes2['default'].string,
  expandIconColumnIndex: _propTypes2['default'].number,
  onHover: _propTypes2['default'].func,
  columns: _propTypes2['default'].array,
  height: _propTypes2['default'].oneOfType([_propTypes2['default'].string, _propTypes2['default'].number]),
  visible: _propTypes2['default'].bool,
  index: _propTypes2['default'].number,
  hoverKey: _propTypes2['default'].any,
  expanded: _propTypes2['default'].bool,
  expandable: _propTypes2['default'].any,
  onExpand: _propTypes2['default'].func,
  needIndentSpaced: _propTypes2['default'].bool,
  className: _propTypes2['default'].string,
  indent: _propTypes2['default'].number,
  indentSize: _propTypes2['default'].number,
  expandIconAsCell: _propTypes2['default'].bool,
  expandRowByClick: _propTypes2['default'].bool,
  store: _propTypes2['default'].object.isRequired,
  expandedRow: _propTypes2['default'].bool,
  fixed: _propTypes2['default'].bool,
  rowKey: _propTypes2['default'].string
};
TableRow.defaultProps = {
  onRowClick: function onRowClick() {},
  onRowDoubleClick: function onRowDoubleClick() {},
  onRowContextMenu: function onRowContextMenu() {},
  onRowMouseEnter: function onRowMouseEnter() {},
  onRowMouseLeave: function onRowMouseLeave() {},
  onDestroy: function onDestroy() {},

  expandIconColumnIndex: 0,
  expandRowByClick: false,
  onHover: function onHover() {}
};
exports['default'] = TableRow;
module.exports = exports['default'];