'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _KeyCode = require('./KeyCode');

var _KeyCode2 = _interopRequireDefault(_KeyCode);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var Options = function (_React$Component) {
  (0, _inherits3['default'])(Options, _React$Component);

  function Options(props) {
    (0, _classCallCheck3['default'])(this, Options);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Options.__proto__ || Object.getPrototypeOf(Options)).call(this, props));

    _this.buildOptionText = function (value) {
      return value + ' ' + _this.props.locale.items_per_page;
    };

    _this.changeSize = function (value) {
      _this.props.changeSize(Number(value));
    };

    _this.handleChange = function (e) {
      _this.setState({
        goInputText: e.target.value
      });
    };

    _this.go = function (e) {
      var val = _this.state.goInputText;
      if (val === '') {
        return;
      }
      val = Number(val);
      if (isNaN(val)) {
        val = _this.state.current;
      }
      if (e.keyCode === _KeyCode2['default'].ENTER || e.type === 'click') {
        _this.setState({
          goInputText: '',
          current: _this.props.quickGo(val)
        });
      }
    };

    _this.state = {
      current: props.current,
      goInputText: ''
    };
    return _this;
  }

  (0, _createClass3['default'])(Options, [{
    key: 'render',
    value: function render() {
      var props = this.props;
      var state = this.state;
      var locale = props.locale;
      var prefixCls = props.rootPrefixCls + '-options';
      var changeSize = props.changeSize;
      var quickGo = props.quickGo;
      var goButton = props.goButton;
      var buildOptionText = props.buildOptionText || this.buildOptionText;
      var Select = props.selectComponentClass;
      var changeSelect = null;
      var goInput = null;
      var gotoButton = null;

      if (!(changeSize || quickGo)) {
        return null;
      }

      if (changeSize && Select) {
        var Option = Select.Option;
        var pageSize = props.pageSize || props.pageSizeOptions[0];
        var options = props.pageSizeOptions.map(function (opt, i) {
          return _react2['default'].createElement(
            Option,
            { key: i, value: opt },
            buildOptionText(opt)
          );
        });

        changeSelect = _react2['default'].createElement(
          Select,
          {
            prefixCls: props.selectPrefixCls,
            showSearch: false,
            className: prefixCls + '-size-changer',
            optionLabelProp: 'children',
            dropdownMatchSelectWidth: false,
            value: pageSize.toString(),
            onChange: this.changeSize,
            getPopupContainer: function getPopupContainer(triggerNode) {
              return triggerNode.parentNode;
            }
          },
          options
        );
      }

      if (quickGo) {
        if (goButton) {
          if (typeof goButton === 'boolean') {
            gotoButton = _react2['default'].createElement(
              'button',
              {
                type: 'button',
                onClick: this.go,
                onKeyUp: this.go
              },
              locale.jump_to_confirm
            );
          } else {
            gotoButton = goButton;
          }
        }
        goInput = _react2['default'].createElement(
          'div',
          { className: prefixCls + '-quick-jumper' },
          locale.jump_to,
          _react2['default'].createElement('input', {
            type: 'text',
            value: state.goInputText,
            onChange: this.handleChange,
            onKeyUp: this.go
          }),
          locale.page,
          gotoButton
        );
      }

      return _react2['default'].createElement(
        'li',
        { className: '' + prefixCls },
        changeSelect,
        goInput
      );
    }
  }]);
  return Options;
}(_react2['default'].Component);

Options.propTypes = {
  changeSize: _propTypes2['default'].func,
  quickGo: _propTypes2['default'].func,
  selectComponentClass: _propTypes2['default'].func,
  current: _propTypes2['default'].number,
  pageSizeOptions: _propTypes2['default'].arrayOf(_propTypes2['default'].string),
  pageSize: _propTypes2['default'].number,
  buildOptionText: _propTypes2['default'].func,
  locale: _propTypes2['default'].object
};
Options.defaultProps = {
  pageSizeOptions: ['10', '20', '30', '40']
};
exports['default'] = Options;
module.exports = exports['default'];