import React from 'react';
import PropTypes from 'prop-types';
import createReactClass from 'create-react-class';
import { Text, TextInput, TouchableWithoutFeedback, View } from 'react-native';
import mixin from './mixin';

var InputNumber = createReactClass({
  displayName: 'InputNumber',

  propTypes: {
    styles: PropTypes.object,
    style: PropTypes.object,
    upStyle: PropTypes.object,
    downStyle: PropTypes.object,
    inputStyle: PropTypes.object,
    onChange: PropTypes.func,
    onFocus: PropTypes.func,
    onBlur: PropTypes.func,
    max: PropTypes.number,
    min: PropTypes.number,
    autoFocus: PropTypes.bool,
    disabled: PropTypes.bool,
    step: PropTypes.number,
    value: PropTypes.number,
    defaultValue: PropTypes.number,
    readOnly: PropTypes.bool,
    keyboardType: PropTypes.string
  },

  mixins: [mixin],

  onPressIn: function onPressIn(type) {
    if (this.props.disabled) {
      return;
    }
    var styles = this.props.styles;

    this[type].setNativeProps({
      style: [styles.stepWrap, styles.highlightStepBorderColor]
    });
    this[type + 'Text'].setNativeProps({
      style: [styles.stepText, styles.highlightStepTextColor]
    });
  },
  onPressOut: function onPressOut(type) {
    if (this.props.disabled) {
      return;
    }
    var styles = this.props.styles;

    this[type].setNativeProps({
      style: [styles.stepWrap]
    });
    this[type + 'Text'].setNativeProps({
      style: [styles.stepText]
    });
  },
  onPressInDown: function onPressInDown(e) {
    this.onPressIn('_stepDown');
    this.down(e, true);
  },
  onPressOutDown: function onPressOutDown() {
    this.onPressOut('_stepDown');
    this.stop();
  },
  onPressInUp: function onPressInUp(e) {
    this.onPressIn('_stepUp');
    this.up(e, true);
  },
  onPressOutUp: function onPressOutUp() {
    this.onPressOut('_stepUp');
    this.stop();
  },
  getValueFromEvent: function getValueFromEvent(e) {
    return e.nativeEvent.text;
  },
  render: function render() {
    var _this = this;

    var props = this.props,
        state = this.state;
    var _props = this.props,
        style = _props.style,
        upStyle = _props.upStyle,
        downStyle = _props.downStyle,
        inputStyle = _props.inputStyle,
        styles = _props.styles;

    var editable = !this.props.readOnly && !this.props.disabled;

    var upDisabledStyle = null;
    var downDisabledStyle = null;
    var upDisabledTextStyle = null;
    var downDisabledTextStyle = null;
    var value = state.value;
    if (!isNaN(value)) {
      var val = Number(value);
      if (val >= props.max) {
        upDisabledStyle = styles.stepDisabled;
        upDisabledTextStyle = styles.disabledStepTextColor;
      }
      if (val <= props.min) {
        downDisabledStyle = styles.stepDisabled;
        downDisabledTextStyle = styles.disabledStepTextColor;
      }
    } else {
      upDisabledStyle = styles.stepDisabled;
      downDisabledStyle = styles.stepDisabled;
      upDisabledTextStyle = styles.disabledStepTextColor;
      downDisabledTextStyle = styles.disabledStepTextColor;
    }

    var inputDisabledStyle = null;
    if (props.disabled) {
      upDisabledStyle = styles.stepDisabled;
      downDisabledStyle = styles.stepDisabled;
      upDisabledTextStyle = styles.disabledStepTextColor;
      downDisabledTextStyle = styles.disabledStepTextColor;
      inputDisabledStyle = styles.disabledStepTextColor;
    }

    var inputDisplayValue = void 0;
    if (state.focused) {
      inputDisplayValue = '' + state.inputValue;
    } else {
      inputDisplayValue = '' + state.value;
    }

    if (inputDisplayValue === undefined) {
      inputDisplayValue = '';
    }

    return React.createElement(
      View,
      { style: [styles.container, style] },
      React.createElement(
        TouchableWithoutFeedback,
        {
          onPressIn: editable && !downDisabledStyle ? this.onPressInDown : undefined,
          onPressOut: editable && !downDisabledStyle ? this.onPressOutDown : undefined,
          accessible: true,
          accessibilityLabel: 'Decrease Value',
          accessibilityComponentType: 'button',
          accessibilityTraits: editable && !downDisabledStyle ? 'button' : 'disabled'
        },
        React.createElement(
          View,
          {
            ref: function ref(component) {
              return _this._stepDown = component;
            },
            style: [styles.stepWrap, downDisabledStyle, downStyle]
          },
          React.createElement(
            Text,
            {
              ref: function ref(component) {
                return _this._stepDownText = component;
              },
              style: [styles.stepText, downDisabledTextStyle]
            },
            '-'
          )
        )
      ),
      React.createElement(TextInput, {
        style: [styles.input, inputDisabledStyle, inputStyle],
        ref: 'input',
        value: inputDisplayValue,
        autoFocus: props.autoFocus,
        editable: editable,
        onFocus: this.onFocus,
        onEndEditing: this.onBlur,
        onChange: this.onChange,
        underlineColorAndroid: 'transparent',
        keyboardType: props.keyboardType
      }),
      React.createElement(
        TouchableWithoutFeedback,
        {
          onPressIn: editable && !upDisabledStyle ? this.onPressInUp : undefined,
          onPressOut: editable && !upDisabledStyle ? this.onPressOutUp : undefined,
          accessible: true,
          accessibilityLabel: 'Increase Value',
          accessibilityComponentType: 'button',
          accessibilityTraits: editable && !upDisabledStyle ? 'button' : 'disabled'
        },
        React.createElement(
          View,
          {
            ref: function ref(component) {
              return _this._stepUp = component;
            },
            style: [styles.stepWrap, upDisabledStyle, upStyle]
          },
          React.createElement(
            Text,
            {
              ref: function ref(component) {
                return _this._stepUpText = component;
              },
              style: [styles.stepText, upDisabledTextStyle]
            },
            '+'
          )
        )
      )
    );
  }
});

export default InputNumber;