'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var ROW = 4;
var COL = 3;


function goYear(direction) {
  var next = this.state.value.clone();
  next.add(direction, 'years');
  this.setState({
    value: next
  });
}

function chooseDecade(year, event) {
  var next = this.state.value.clone();
  next.year(year);
  next.month(this.state.value.month());
  this.props.onSelect(next);
  event.preventDefault();
}

var DecadePanel = function (_React$Component) {
  (0, _inherits3['default'])(DecadePanel, _React$Component);

  function DecadePanel(props) {
    (0, _classCallCheck3['default'])(this, DecadePanel);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (DecadePanel.__proto__ || Object.getPrototypeOf(DecadePanel)).call(this, props));

    _this.state = {
      value: props.value || props.defaultValue
    };

    // bind methods
    _this.prefixCls = props.rootPrefixCls + '-decade-panel';
    _this.nextCentury = goYear.bind(_this, 100);
    _this.previousCentury = goYear.bind(_this, -100);
    return _this;
  }

  (0, _createClass3['default'])(DecadePanel, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var value = this.state.value;
      var locale = this.props.locale;
      var currentYear = value.year();
      var startYear = parseInt(currentYear / 100, 10) * 100;
      var preYear = startYear - 10;
      var endYear = startYear + 99;
      var decades = [];
      var index = 0;
      var prefixCls = this.prefixCls;

      for (var rowIndex = 0; rowIndex < ROW; rowIndex++) {
        decades[rowIndex] = [];
        for (var colIndex = 0; colIndex < COL; colIndex++) {
          var startDecade = preYear + index * 10;
          var endDecade = preYear + index * 10 + 9;
          decades[rowIndex][colIndex] = {
            startDecade: startDecade,
            endDecade: endDecade
          };
          index++;
        }
      }

      var decadesEls = decades.map(function (row, decadeIndex) {
        var tds = row.map(function (decadeData) {
          var _classNameMap;

          var dStartDecade = decadeData.startDecade;
          var dEndDecade = decadeData.endDecade;
          var isLast = dStartDecade < startYear;
          var isNext = dEndDecade > endYear;
          var classNameMap = (_classNameMap = {}, (0, _defineProperty3['default'])(_classNameMap, prefixCls + '-cell', 1), (0, _defineProperty3['default'])(_classNameMap, prefixCls + '-selected-cell', dStartDecade <= currentYear && currentYear <= dEndDecade), (0, _defineProperty3['default'])(_classNameMap, prefixCls + '-last-century-cell', isLast), (0, _defineProperty3['default'])(_classNameMap, prefixCls + '-next-century-cell', isNext), _classNameMap);
          var content = dStartDecade + '-' + dEndDecade;
          var clickHandler = void 0;
          if (isLast) {
            clickHandler = _this2.previousCentury;
          } else if (isNext) {
            clickHandler = _this2.nextCentury;
          } else {
            clickHandler = chooseDecade.bind(_this2, dStartDecade);
          }
          return _react2['default'].createElement(
            'td',
            {
              key: dStartDecade,
              onClick: clickHandler,
              role: 'gridcell',
              className: (0, _classnames2['default'])(classNameMap)
            },
            _react2['default'].createElement(
              'a',
              {
                className: prefixCls + '-decade'
              },
              content
            )
          );
        });
        return _react2['default'].createElement(
          'tr',
          { key: decadeIndex, role: 'row' },
          tds
        );
      });

      return _react2['default'].createElement(
        'div',
        { className: this.prefixCls },
        _react2['default'].createElement(
          'div',
          { className: prefixCls + '-header' },
          _react2['default'].createElement('a', {
            className: prefixCls + '-prev-century-btn',
            role: 'button',
            onClick: this.previousCentury,
            title: locale.previousCentury
          }),
          _react2['default'].createElement(
            'div',
            { className: prefixCls + '-century' },
            startYear,
            '-',
            endYear
          ),
          _react2['default'].createElement('a', {
            className: prefixCls + '-next-century-btn',
            role: 'button',
            onClick: this.nextCentury,
            title: locale.nextCentury
          })
        ),
        _react2['default'].createElement(
          'div',
          { className: prefixCls + '-body' },
          _react2['default'].createElement(
            'table',
            { className: prefixCls + '-table', cellSpacing: '0', role: 'grid' },
            _react2['default'].createElement(
              'tbody',
              { className: prefixCls + '-tbody' },
              decadesEls
            )
          )
        )
      );
    }
  }]);
  return DecadePanel;
}(_react2['default'].Component);

exports['default'] = DecadePanel;


DecadePanel.propTypes = {
  locale: _propTypes2['default'].object,
  value: _propTypes2['default'].object,
  defaultValue: _propTypes2['default'].object,
  rootPrefixCls: _propTypes2['default'].string
};

DecadePanel.defaultProps = {
  onSelect: function onSelect() {}
};
module.exports = exports['default'];