import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import React from 'react';
import DateConstants from './DateConstants';
import moment from 'moment';

var DateTHead = function (_React$Component) {
  _inherits(DateTHead, _React$Component);

  function DateTHead() {
    _classCallCheck(this, DateTHead);

    return _possibleConstructorReturn(this, (DateTHead.__proto__ || Object.getPrototypeOf(DateTHead)).apply(this, arguments));
  }

  _createClass(DateTHead, [{
    key: 'render',
    value: function render() {
      var props = this.props;
      var value = props.value;
      var localeData = value.localeData();
      var prefixCls = props.prefixCls;
      var veryShortWeekdays = [];
      var weekDays = [];
      var firstDayOfWeek = localeData.firstDayOfWeek();
      var showWeekNumberEl = void 0;
      var now = moment();
      for (var dateColIndex = 0; dateColIndex < DateConstants.DATE_COL_COUNT; dateColIndex++) {
        var index = (firstDayOfWeek + dateColIndex) % DateConstants.DATE_COL_COUNT;
        now.day(index);
        veryShortWeekdays[dateColIndex] = localeData.weekdaysMin(now);
        weekDays[dateColIndex] = localeData.weekdaysShort(now);
      }

      if (props.showWeekNumber) {
        showWeekNumberEl = React.createElement(
          'th',
          {
            role: 'columnheader',
            className: prefixCls + '-column-header ' + prefixCls + '-week-number-header'
          },
          React.createElement(
            'span',
            { className: prefixCls + '-column-header-inner' },
            'x'
          )
        );
      }
      var weekDaysEls = weekDays.map(function (day, xindex) {
        return React.createElement(
          'th',
          {
            key: xindex,
            role: 'columnheader',
            title: day,
            className: prefixCls + '-column-header'
          },
          React.createElement(
            'span',
            { className: prefixCls + '-column-header-inner' },
            veryShortWeekdays[xindex]
          )
        );
      });
      return React.createElement(
        'thead',
        null,
        React.createElement(
          'tr',
          { role: 'row' },
          showWeekNumberEl,
          weekDaysEls
        )
      );
    }
  }]);

  return DateTHead;
}(React.Component);

export default DateTHead;