import * as PropTypes from 'prop-types';
import { CSSProperties, KeyboardEventHandler, MouseEventHandler, ReactNode, UIEventHandler } from 'react';
export declare type emptyFunction = (e?: any) => void;
export interface IILableValueType {
    key?: string | number;
    label?: ReactNode | string;
}
export declare type valueType = number | number[] | string | string[] | IILableValueType | IILableValueType[];
declare type renderNode = () => ReactNode;
export declare type filterOptionType = (inputValue: string, option?: any) => void;
export declare type renderSelect = ReactNode | renderNode;
export interface ISelectProps {
    id: string;
    defaultActiveFirstOption: boolean;
    multiple: boolean;
    combobox: boolean;
    autoClearSearchValue: boolean;
    filterOption: filterOptionType | boolean;
    children: JSX.Element[] | JSX.Element | any;
    showSearch: boolean;
    disabled: boolean;
    style: CSSProperties;
    allowClear: boolean;
    showArrow: boolean;
    tags: boolean;
    openClassName: string;
    autoFocus: boolean;
    prefixCls: string;
    className: string;
    transitionName: string;
    optionLabelProp: string;
    optionFilterProp: string;
    animation: string;
    choiceTransitionName: string;
    open: boolean;
    defaultOpen: boolean;
    inputValue: string;
    onChange: (value: valueType, option: JSX.Element | JSX.Element[]) => void;
    onBlur: emptyFunction;
    onFocus: emptyFunction;
    onSelect: (value: valueType, option: JSX.Element | JSX.Element[]) => void;
    onSearch: (value: string) => void;
    onDropdownVisibleChange: (open: boolean | undefined) => void;
    onPopupScroll: UIEventHandler<HTMLDivElement>;
    onMouseEnter: MouseEventHandler<HTMLDivElement>;
    onMouseLeave: MouseEventHandler<HTMLDivElement>;
    onInputKeyDown: KeyboardEventHandler<HTMLInputElement>;
    placeholder: string;
    onDeselect: (value: valueType, option: JSX.Element | JSX.Element[]) => void;
    labelInValue: boolean;
    loading: boolean;
    value: valueType;
    firstActiveValue: valueType;
    defaultValue: valueType;
    dropdownStyle: CSSProperties;
    maxTagTextLength: number;
    maxTagCount: number;
    maxTagPlaceholder: renderSelect;
    tokenSeparators: string[];
    getInputElement: () => JSX.Element;
    showAction: string[];
    clearIcon: ReactNode;
    inputIcon: ReactNode;
    removeIcon: ReactNode;
    menuItemSelectedIcon: renderSelect;
    getPopupContainer: renderSelect;
    dropdownRender: (menu: any) => JSX.Element;
    mode: 'multiple' | 'tags';
    backfill: boolean;
    dropdownAlign: any;
    dropdownClassName: string;
    dropdownMatchSelectWidth: boolean;
    dropdownMenuStyle: React.CSSProperties;
    notFoundContent: string | false;
    tabIndex: string | number;
}
declare function propsValueType(...args: [ISelectProps, string, string, any, any]): Error | null;
declare const SelectPropTypes: {
    id: PropTypes.Requireable<string>;
    defaultActiveFirstOption: PropTypes.Requireable<boolean>;
    multiple: PropTypes.Requireable<boolean>;
    filterOption: PropTypes.Requireable<any>;
    children: PropTypes.Requireable<any>;
    showSearch: PropTypes.Requireable<boolean>;
    disabled: PropTypes.Requireable<boolean>;
    allowClear: PropTypes.Requireable<boolean>;
    showArrow: PropTypes.Requireable<boolean>;
    tags: PropTypes.Requireable<boolean>;
    prefixCls: PropTypes.Requireable<string>;
    className: PropTypes.Requireable<string>;
    transitionName: PropTypes.Requireable<string>;
    optionLabelProp: PropTypes.Requireable<string>;
    optionFilterProp: PropTypes.Requireable<string>;
    animation: PropTypes.Requireable<string>;
    choiceTransitionName: PropTypes.Requireable<string>;
    open: PropTypes.Requireable<boolean>;
    defaultOpen: PropTypes.Requireable<boolean>;
    onChange: PropTypes.Requireable<(...args: any[]) => any>;
    onBlur: PropTypes.Requireable<(...args: any[]) => any>;
    onFocus: PropTypes.Requireable<(...args: any[]) => any>;
    onSelect: PropTypes.Requireable<(...args: any[]) => any>;
    onSearch: PropTypes.Requireable<(...args: any[]) => any>;
    onPopupScroll: PropTypes.Requireable<(...args: any[]) => any>;
    onMouseEnter: PropTypes.Requireable<(...args: any[]) => any>;
    onMouseLeave: PropTypes.Requireable<(...args: any[]) => any>;
    onInputKeyDown: PropTypes.Requireable<(...args: any[]) => any>;
    placeholder: PropTypes.Requireable<any>;
    onDeselect: PropTypes.Requireable<(...args: any[]) => any>;
    labelInValue: PropTypes.Requireable<boolean>;
    loading: PropTypes.Requireable<boolean>;
    value: typeof propsValueType;
    defaultValue: typeof propsValueType;
    dropdownStyle: PropTypes.Requireable<object>;
    maxTagTextLength: PropTypes.Requireable<number>;
    maxTagCount: PropTypes.Requireable<number>;
    maxTagPlaceholder: PropTypes.Requireable<string | number | boolean | {} | PropTypes.ReactElementLike | PropTypes.ReactNodeArray>;
    tokenSeparators: PropTypes.Requireable<(string | null | undefined)[]>;
    getInputElement: PropTypes.Requireable<(...args: any[]) => any>;
    showAction: PropTypes.Requireable<(string | null | undefined)[]>;
    clearIcon: PropTypes.Requireable<PropTypes.ReactNodeLike>;
    inputIcon: PropTypes.Requireable<PropTypes.ReactNodeLike>;
    removeIcon: PropTypes.Requireable<PropTypes.ReactNodeLike>;
    menuItemSelectedIcon: PropTypes.Requireable<string | number | boolean | {} | PropTypes.ReactElementLike | PropTypes.ReactNodeArray>;
    dropdownRender: PropTypes.Requireable<(...args: any[]) => any>;
};
export default SelectPropTypes;
