'use strict';

exports.__esModule = true;
exports.default = scssTokenize;
var SINGLE_QUOTE = 39;
var DOUBLE_QUOTE = 34;
var BACKSLASH = 92;
var SLASH = 47;
var NEWLINE = 10;
var SPACE = 32;
var FEED = 12;
var TAB = 9;
var CR = 13;
var OPEN_SQUARE = 91;
var CLOSE_SQUARE = 93;
var OPEN_PARENTHESES = 40;
var CLOSE_PARENTHESES = 41;
var OPEN_CURLY = 123;
var CLOSE_CURLY = 125;
var SEMICOLON = 59;
var ASTERISK = 42;
var COLON = 58;
var AT = 64;

// SCSS PATCH {
var COMMA = 44;
var HASH = 35;
// } SCSS PATCH

var RE_AT_END = /[ \n\t\r\f\{\}\(\)'"\\;/\[\]#]/g;
var RE_WORD_END = /[ \n\t\r\f\(\)\{\}:;@!'"\\\]\[#]|\/(?=\*)/g;
var RE_BAD_BRACKET = /.[\\\/\("'\n]/;
var RE_HEX_ESCAPE = /[a-f0-9]/i;

var RE_NEW_LINE = /[\r\f\n]/g; // SCSS PATCH

// SCSS PATCH function name was changed
function scssTokenize(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var css = input.css.valueOf();
    var ignore = options.ignoreErrors;

    var code = void 0,
        next = void 0,
        quote = void 0,
        lines = void 0,
        last = void 0,
        content = void 0,
        escape = void 0,
        nextLine = void 0,
        nextOffset = void 0,
        escaped = void 0,
        prev = void 0,
        n = void 0,
        currentToken = void 0;

    var brackets = void 0; // SCSS PATCH

    var length = css.length;
    var offset = -1;
    var line = 1;
    var pos = 0;
    var buffer = [];
    var returned = [];

    function unclosed(what) {
        throw input.error('Unclosed ' + what, line, pos - offset);
    }

    function endOfFile() {
        return returned.length === 0 && pos >= length;
    }

    // SCSS PATCH {
    function interpolation() {
        var deep = 1;
        var stringQuote = false;
        var stringEscaped = false;
        while (deep > 0) {
            next += 1;
            if (css.length <= next) unclosed('interpolation');

            code = css.charCodeAt(next);
            n = css.charCodeAt(next + 1);

            if (stringQuote) {
                if (!stringEscaped && code === stringQuote) {
                    stringQuote = false;
                    stringEscaped = false;
                } else if (code === BACKSLASH) {
                    stringEscaped = !escaped;
                } else if (stringEscaped) {
                    stringEscaped = false;
                }
            } else if (code === SINGLE_QUOTE || code === DOUBLE_QUOTE) {
                stringQuote = code;
            } else if (code === CLOSE_CURLY) {
                deep -= 1;
            } else if (code === HASH && n === OPEN_CURLY) {
                deep += 1;
            }
        }
    }
    // } SCSS PATCH

    function nextToken() {
        if (returned.length) return returned.pop();
        if (pos >= length) return;

        code = css.charCodeAt(pos);
        if (code === NEWLINE || code === FEED || code === CR && css.charCodeAt(pos + 1) !== NEWLINE) {
            offset = pos;
            line += 1;
        }

        switch (code) {
            case NEWLINE:
            case SPACE:
            case TAB:
            case CR:
            case FEED:
                next = pos;
                do {
                    next += 1;
                    code = css.charCodeAt(next);
                    if (code === NEWLINE) {
                        offset = next;
                        line += 1;
                    }
                } while (code === SPACE || code === NEWLINE || code === TAB || code === CR || code === FEED);

                currentToken = ['space', css.slice(pos, next)];
                pos = next - 1;
                break;

            case OPEN_SQUARE:
                currentToken = ['[', '[', line, pos - offset];
                break;

            case CLOSE_SQUARE:
                currentToken = [']', ']', line, pos - offset];
                break;

            case OPEN_CURLY:
                currentToken = ['{', '{', line, pos - offset];
                break;

            case CLOSE_CURLY:
                currentToken = ['}', '}', line, pos - offset];
                break;

            // SCSS PATCH {
            case COMMA:
                currentToken = ['word', ',', line, pos - offset, line, pos - offset + 1];
                break;
            // } SCSS PATCH

            case COLON:
                currentToken = [':', ':', line, pos - offset];
                break;

            case SEMICOLON:
                currentToken = [';', ';', line, pos - offset];
                break;

            case OPEN_PARENTHESES:
                prev = buffer.length ? buffer.pop()[1] : '';
                n = css.charCodeAt(pos + 1);

                // SCSS PATCH {
                if (prev === 'url' && n !== SINGLE_QUOTE && n !== DOUBLE_QUOTE) {
                    brackets = 1;
                    escaped = false;
                    next = pos + 1;
                    while (next <= css.length - 1) {
                        n = css.charCodeAt(next);
                        if (n === BACKSLASH) {
                            escaped = !escaped;
                        } else if (n === OPEN_PARENTHESES) {
                            brackets += 1;
                        } else if (n === CLOSE_PARENTHESES) {
                            brackets -= 1;
                            if (brackets === 0) break;
                        }
                        next += 1;
                    }

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    currentToken = ['brackets', content, line, pos - offset, nextLine, next - nextOffset];

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;
                    // } SCSS PATCH
                } else {
                    next = css.indexOf(')', pos + 1);
                    content = css.slice(pos, next + 1);

                    if (next === -1 || RE_BAD_BRACKET.test(content)) {
                        currentToken = ['(', '(', line, pos - offset];
                    } else {
                        currentToken = ['brackets', content, line, pos - offset, line, next - offset];
                        pos = next;
                    }
                }

                break;

            case CLOSE_PARENTHESES:
                currentToken = [')', ')', line, pos - offset];
                break;

            case SINGLE_QUOTE:
            case DOUBLE_QUOTE:
                // SCSS PATCH {
                quote = code;
                next = pos;

                escaped = false;
                while (next < length) {
                    next++;
                    if (next === length) unclosed('string');

                    code = css.charCodeAt(next);
                    n = css.charCodeAt(next + 1);

                    if (!escaped && code === quote) {
                        break;
                    } else if (code === BACKSLASH) {
                        escaped = !escaped;
                    } else if (escaped) {
                        escaped = false;
                    } else if (code === HASH && n === OPEN_CURLY) {
                        interpolation();
                    }
                }
                // } SCSS PATCH

                content = css.slice(pos, next + 1);
                lines = content.split('\n');
                last = lines.length - 1;

                if (last > 0) {
                    nextLine = line + last;
                    nextOffset = next - lines[last].length;
                } else {
                    nextLine = line;
                    nextOffset = offset;
                }

                currentToken = ['string', css.slice(pos, next + 1), line, pos - offset, nextLine, next - nextOffset];

                offset = nextOffset;
                line = nextLine;
                pos = next;
                break;

            case AT:
                RE_AT_END.lastIndex = pos + 1;
                RE_AT_END.test(css);
                if (RE_AT_END.lastIndex === 0) {
                    next = css.length - 1;
                } else {
                    next = RE_AT_END.lastIndex - 2;
                }

                currentToken = ['at-word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];

                pos = next;
                break;

            case BACKSLASH:
                next = pos;
                escape = true;
                while (css.charCodeAt(next + 1) === BACKSLASH) {
                    next += 1;
                    escape = !escape;
                }
                code = css.charCodeAt(next + 1);
                if (escape && code !== SLASH && code !== SPACE && code !== NEWLINE && code !== TAB && code !== CR && code !== FEED) {
                    next += 1;
                    if (RE_HEX_ESCAPE.test(css.charAt(next))) {
                        while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
                            next += 1;
                        }
                        if (css.charCodeAt(next + 1) === SPACE) {
                            next += 1;
                        }
                    }
                }

                currentToken = ['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];

                pos = next;
                break;

            default:
                // SCSS PATCH {
                n = css.charCodeAt(pos + 1);

                if (code === HASH && n === OPEN_CURLY) {
                    next = pos;
                    interpolation();

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    currentToken = ['word', content, line, pos - offset, nextLine, next - nextOffset];

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;
                } else if (code === SLASH && n === ASTERISK) {
                    // } SCSS PATCH
                    next = css.indexOf('*/', pos + 2) + 1;
                    if (next === 0) {
                        if (ignore) {
                            next = css.length;
                        } else {
                            unclosed('comment');
                        }
                    }

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    currentToken = ['comment', content, line, pos - offset, nextLine, next - nextOffset];

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;

                    // SCSS PATCH {
                } else if (code === SLASH && n === SLASH) {
                    RE_NEW_LINE.lastIndex = pos + 1;
                    RE_NEW_LINE.test(css);
                    if (RE_NEW_LINE.lastIndex === 0) {
                        next = css.length - 1;
                    } else {
                        next = RE_NEW_LINE.lastIndex - 2;
                    }

                    content = css.slice(pos, next + 1);

                    currentToken = ['comment', content, line, pos - offset, line, next - offset, 'inline'];

                    pos = next;
                    // } SCSS PATCH
                } else {
                    RE_WORD_END.lastIndex = pos + 1;
                    RE_WORD_END.test(css);
                    if (RE_WORD_END.lastIndex === 0) {
                        next = css.length - 1;
                    } else {
                        next = RE_WORD_END.lastIndex - 2;
                    }

                    currentToken = ['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];

                    buffer.push(currentToken);

                    pos = next;
                }

                break;
        }

        pos++;
        return currentToken;
    }

    function back(token) {
        returned.push(token);
    }

    return {
        back: back,
        nextToken: nextToken,
        endOfFile: endOfFile
    };
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNjc3MtdG9rZW5pemUuZXM2Il0sIm5hbWVzIjpbInNjc3NUb2tlbml6ZSIsIlNJTkdMRV9RVU9URSIsIkRPVUJMRV9RVU9URSIsIkJBQ0tTTEFTSCIsIlNMQVNIIiwiTkVXTElORSIsIlNQQUNFIiwiRkVFRCIsIlRBQiIsIkNSIiwiT1BFTl9TUVVBUkUiLCJDTE9TRV9TUVVBUkUiLCJPUEVOX1BBUkVOVEhFU0VTIiwiQ0xPU0VfUEFSRU5USEVTRVMiLCJPUEVOX0NVUkxZIiwiQ0xPU0VfQ1VSTFkiLCJTRU1JQ09MT04iLCJBU1RFUklTSyIsIkNPTE9OIiwiQVQiLCJDT01NQSIsIkhBU0giLCJSRV9BVF9FTkQiLCJSRV9XT1JEX0VORCIsIlJFX0JBRF9CUkFDS0VUIiwiUkVfSEVYX0VTQ0FQRSIsIlJFX05FV19MSU5FIiwiaW5wdXQiLCJvcHRpb25zIiwiY3NzIiwidmFsdWVPZiIsImlnbm9yZSIsImlnbm9yZUVycm9ycyIsImNvZGUiLCJuZXh0IiwicXVvdGUiLCJsaW5lcyIsImxhc3QiLCJjb250ZW50IiwiZXNjYXBlIiwibmV4dExpbmUiLCJuZXh0T2Zmc2V0IiwiZXNjYXBlZCIsInByZXYiLCJuIiwiY3VycmVudFRva2VuIiwiYnJhY2tldHMiLCJsZW5ndGgiLCJvZmZzZXQiLCJsaW5lIiwicG9zIiwiYnVmZmVyIiwicmV0dXJuZWQiLCJ1bmNsb3NlZCIsIndoYXQiLCJlcnJvciIsImVuZE9mRmlsZSIsImludGVycG9sYXRpb24iLCJkZWVwIiwic3RyaW5nUXVvdGUiLCJzdHJpbmdFc2NhcGVkIiwiY2hhckNvZGVBdCIsIm5leHRUb2tlbiIsInBvcCIsInNsaWNlIiwic3BsaXQiLCJpbmRleE9mIiwidGVzdCIsImxhc3RJbmRleCIsImNoYXJBdCIsInB1c2giLCJiYWNrIiwidG9rZW4iXSwibWFwcGluZ3MiOiI7OztrQkFpQ3dCQSxZO0FBakN4QixJQUFNQyxpQkFBTjtBQUNBLElBQU1DLGlCQUFOO0FBQ0EsSUFBTUMsY0FBTjtBQUNBLElBQU1DLFVBQU47QUFDQSxJQUFNQyxZQUFOO0FBQ0EsSUFBTUMsVUFBTjtBQUNBLElBQU1DLFNBQU47QUFDQSxJQUFNQyxPQUFOO0FBQ0EsSUFBTUMsT0FBTjtBQUNBLElBQU1DLGdCQUFOO0FBQ0EsSUFBTUMsaUJBQU47QUFDQSxJQUFNQyxxQkFBTjtBQUNBLElBQU1DLHNCQUFOO0FBQ0EsSUFBTUMsZ0JBQU47QUFDQSxJQUFNQyxpQkFBTjtBQUNBLElBQU1DLGNBQU47QUFDQSxJQUFNQyxhQUFOO0FBQ0EsSUFBTUMsVUFBTjtBQUNBLElBQU1DLE9BQU47O0FBRUE7QUFDQSxJQUFNQyxVQUFOO0FBQ0EsSUFBTUMsU0FBTjtBQUNBOztBQUVBLElBQU1DLFlBQWlCLGlDQUF2QjtBQUNBLElBQU1DLGNBQWlCLDRDQUF2QjtBQUNBLElBQU1DLGlCQUFpQixlQUF2QjtBQUNBLElBQU1DLGdCQUFpQixXQUF2Qjs7QUFFQSxJQUFNQyxjQUFpQixXQUF2QixDLENBQW9DOztBQUVwQztBQUNlLFNBQVMxQixZQUFULENBQXNCMkIsS0FBdEIsRUFBMkM7QUFBQSxRQUFkQyxPQUFjLHVFQUFKLEVBQUk7O0FBQ3RELFFBQUlDLE1BQU1GLE1BQU1FLEdBQU4sQ0FBVUMsT0FBVixFQUFWO0FBQ0EsUUFBSUMsU0FBU0gsUUFBUUksWUFBckI7O0FBRUEsUUFBSUMsYUFBSjtBQUFBLFFBQVVDLGFBQVY7QUFBQSxRQUFnQkMsY0FBaEI7QUFBQSxRQUF1QkMsY0FBdkI7QUFBQSxRQUE4QkMsYUFBOUI7QUFBQSxRQUFvQ0MsZ0JBQXBDO0FBQUEsUUFBNkNDLGVBQTdDO0FBQUEsUUFDSUMsaUJBREo7QUFBQSxRQUNjQyxtQkFEZDtBQUFBLFFBQzBCQyxnQkFEMUI7QUFBQSxRQUNtQ0MsYUFEbkM7QUFBQSxRQUN5Q0MsVUFEekM7QUFBQSxRQUM0Q0MscUJBRDVDOztBQUdBLFFBQUlDLGlCQUFKLENBUHNELENBT3hDOztBQUVkLFFBQUlDLFNBQVNsQixJQUFJa0IsTUFBakI7QUFDQSxRQUFJQyxTQUFTLENBQUMsQ0FBZDtBQUNBLFFBQUlDLE9BQU8sQ0FBWDtBQUNBLFFBQUlDLE1BQU0sQ0FBVjtBQUNBLFFBQUlDLFNBQVMsRUFBYjtBQUNBLFFBQUlDLFdBQVcsRUFBZjs7QUFFQSxhQUFTQyxRQUFULENBQWtCQyxJQUFsQixFQUF3QjtBQUNwQixjQUFNM0IsTUFBTTRCLEtBQU4sQ0FBWSxjQUFjRCxJQUExQixFQUFnQ0wsSUFBaEMsRUFBc0NDLE1BQU1GLE1BQTVDLENBQU47QUFDSDs7QUFFRCxhQUFTUSxTQUFULEdBQXFCO0FBQ2pCLGVBQU9KLFNBQVNMLE1BQVQsS0FBb0IsQ0FBcEIsSUFBeUJHLE9BQU9ILE1BQXZDO0FBQ0g7O0FBRUQ7QUFDQSxhQUFTVSxhQUFULEdBQXlCO0FBQ3JCLFlBQUlDLE9BQU8sQ0FBWDtBQUNBLFlBQUlDLGNBQWMsS0FBbEI7QUFDQSxZQUFJQyxnQkFBZ0IsS0FBcEI7QUFDQSxlQUFRRixPQUFPLENBQWYsRUFBbUI7QUFDZnhCLG9CQUFRLENBQVI7QUFDQSxnQkFBS0wsSUFBSWtCLE1BQUosSUFBY2IsSUFBbkIsRUFBMEJtQixTQUFTLGVBQVQ7O0FBRTFCcEIsbUJBQU9KLElBQUlnQyxVQUFKLENBQWUzQixJQUFmLENBQVA7QUFDQVUsZ0JBQU9mLElBQUlnQyxVQUFKLENBQWUzQixPQUFPLENBQXRCLENBQVA7O0FBRUEsZ0JBQUt5QixXQUFMLEVBQW1CO0FBQ2Ysb0JBQUssQ0FBQ0MsYUFBRCxJQUFrQjNCLFNBQVMwQixXQUFoQyxFQUE4QztBQUMxQ0Esa0NBQWMsS0FBZDtBQUNBQyxvQ0FBZ0IsS0FBaEI7QUFDSCxpQkFIRCxNQUdPLElBQUszQixTQUFTOUIsU0FBZCxFQUEwQjtBQUM3QnlELG9DQUFnQixDQUFDbEIsT0FBakI7QUFDSCxpQkFGTSxNQUVBLElBQUtrQixhQUFMLEVBQXFCO0FBQ3hCQSxvQ0FBZ0IsS0FBaEI7QUFDSDtBQUNKLGFBVEQsTUFTTyxJQUNIM0IsU0FBU2hDLFlBQVQsSUFBeUJnQyxTQUFTL0IsWUFEL0IsRUFFTDtBQUNFeUQsOEJBQWMxQixJQUFkO0FBQ0gsYUFKTSxNQUlBLElBQUtBLFNBQVNsQixXQUFkLEVBQTRCO0FBQy9CMkMsd0JBQVEsQ0FBUjtBQUNILGFBRk0sTUFFQSxJQUFLekIsU0FBU1osSUFBVCxJQUFpQnVCLE1BQU05QixVQUE1QixFQUF5QztBQUM1QzRDLHdCQUFRLENBQVI7QUFDSDtBQUNKO0FBQ0o7QUFDRDs7QUFFQSxhQUFTSSxTQUFULEdBQXFCO0FBQ2pCLFlBQUtWLFNBQVNMLE1BQWQsRUFBdUIsT0FBT0ssU0FBU1csR0FBVCxFQUFQO0FBQ3ZCLFlBQUtiLE9BQU9ILE1BQVosRUFBcUI7O0FBRXJCZCxlQUFPSixJQUFJZ0MsVUFBSixDQUFlWCxHQUFmLENBQVA7QUFDQSxZQUFLakIsU0FBUzVCLE9BQVQsSUFBb0I0QixTQUFTMUIsSUFBN0IsSUFDQTBCLFNBQVN4QixFQUFULElBQWVvQixJQUFJZ0MsVUFBSixDQUFlWCxNQUFNLENBQXJCLE1BQTRCN0MsT0FEaEQsRUFDMEQ7QUFDdEQyQyxxQkFBU0UsR0FBVDtBQUNBRCxvQkFBUSxDQUFSO0FBQ0g7O0FBRUQsZ0JBQVNoQixJQUFUO0FBQ0EsaUJBQUs1QixPQUFMO0FBQ0EsaUJBQUtDLEtBQUw7QUFDQSxpQkFBS0UsR0FBTDtBQUNBLGlCQUFLQyxFQUFMO0FBQ0EsaUJBQUtGLElBQUw7QUFDSTJCLHVCQUFPZ0IsR0FBUDtBQUNBLG1CQUFHO0FBQ0NoQiw0QkFBUSxDQUFSO0FBQ0FELDJCQUFPSixJQUFJZ0MsVUFBSixDQUFlM0IsSUFBZixDQUFQO0FBQ0Esd0JBQUtELFNBQVM1QixPQUFkLEVBQXdCO0FBQ3BCMkMsaUNBQVNkLElBQVQ7QUFDQWUsZ0NBQVEsQ0FBUjtBQUNIO0FBQ0osaUJBUEQsUUFPVWhCLFNBQVMzQixLQUFULElBQ0EyQixTQUFTNUIsT0FEVCxJQUVBNEIsU0FBU3pCLEdBRlQsSUFHQXlCLFNBQVN4QixFQUhULElBSUF3QixTQUFTMUIsSUFYbkI7O0FBYUFzQywrQkFBZSxDQUFDLE9BQUQsRUFBVWhCLElBQUltQyxLQUFKLENBQVVkLEdBQVYsRUFBZWhCLElBQWYsQ0FBVixDQUFmO0FBQ0FnQixzQkFBTWhCLE9BQU8sQ0FBYjtBQUNBOztBQUVKLGlCQUFLeEIsV0FBTDtBQUNJbUMsK0JBQWUsQ0FBQyxHQUFELEVBQU0sR0FBTixFQUFXSSxJQUFYLEVBQWlCQyxNQUFNRixNQUF2QixDQUFmO0FBQ0E7O0FBRUosaUJBQUtyQyxZQUFMO0FBQ0lrQywrQkFBZSxDQUFDLEdBQUQsRUFBTSxHQUFOLEVBQVdJLElBQVgsRUFBaUJDLE1BQU1GLE1BQXZCLENBQWY7QUFDQTs7QUFFSixpQkFBS2xDLFVBQUw7QUFDSStCLCtCQUFlLENBQUMsR0FBRCxFQUFNLEdBQU4sRUFBV0ksSUFBWCxFQUFpQkMsTUFBTUYsTUFBdkIsQ0FBZjtBQUNBOztBQUVKLGlCQUFLakMsV0FBTDtBQUNJOEIsK0JBQWUsQ0FBQyxHQUFELEVBQU0sR0FBTixFQUFXSSxJQUFYLEVBQWlCQyxNQUFNRixNQUF2QixDQUFmO0FBQ0E7O0FBRUo7QUFDQSxpQkFBSzVCLEtBQUw7QUFDSXlCLCtCQUFlLENBQ1gsTUFEVyxFQUVYLEdBRlcsRUFHWEksSUFIVyxFQUdMQyxNQUFNRixNQUhELEVBSVhDLElBSlcsRUFJTEMsTUFBTUYsTUFBTixHQUFlLENBSlYsQ0FBZjtBQU1BO0FBQ0o7O0FBRUEsaUJBQUs5QixLQUFMO0FBQ0kyQiwrQkFBZSxDQUFDLEdBQUQsRUFBTSxHQUFOLEVBQVdJLElBQVgsRUFBaUJDLE1BQU1GLE1BQXZCLENBQWY7QUFDQTs7QUFFSixpQkFBS2hDLFNBQUw7QUFDSTZCLCtCQUFlLENBQUMsR0FBRCxFQUFNLEdBQU4sRUFBV0ksSUFBWCxFQUFpQkMsTUFBTUYsTUFBdkIsQ0FBZjtBQUNBOztBQUVKLGlCQUFLcEMsZ0JBQUw7QUFDSStCLHVCQUFPUSxPQUFPSixNQUFQLEdBQWdCSSxPQUFPWSxHQUFQLEdBQWEsQ0FBYixDQUFoQixHQUFrQyxFQUF6QztBQUNBbkIsb0JBQU9mLElBQUlnQyxVQUFKLENBQWVYLE1BQU0sQ0FBckIsQ0FBUDs7QUFFQTtBQUNBLG9CQUFLUCxTQUFTLEtBQVQsSUFBa0JDLE1BQU0zQyxZQUF4QixJQUF3QzJDLE1BQU0xQyxZQUFuRCxFQUFrRTtBQUM5RDRDLCtCQUFXLENBQVg7QUFDQUosOEJBQVcsS0FBWDtBQUNBUiwyQkFBV2dCLE1BQU0sQ0FBakI7QUFDQSwyQkFBUWhCLFFBQVFMLElBQUlrQixNQUFKLEdBQWEsQ0FBN0IsRUFBaUM7QUFDN0JILDRCQUFJZixJQUFJZ0MsVUFBSixDQUFlM0IsSUFBZixDQUFKO0FBQ0EsNEJBQUtVLE1BQU16QyxTQUFYLEVBQXVCO0FBQ25CdUMsc0NBQVUsQ0FBQ0EsT0FBWDtBQUNILHlCQUZELE1BRU8sSUFBS0UsTUFBTWhDLGdCQUFYLEVBQThCO0FBQ2pDa0Msd0NBQVksQ0FBWjtBQUNILHlCQUZNLE1BRUEsSUFBS0YsTUFBTS9CLGlCQUFYLEVBQStCO0FBQ2xDaUMsd0NBQVksQ0FBWjtBQUNBLGdDQUFLQSxhQUFhLENBQWxCLEVBQXNCO0FBQ3pCO0FBQ0RaLGdDQUFRLENBQVI7QUFDSDs7QUFFREksOEJBQVVULElBQUltQyxLQUFKLENBQVVkLEdBQVYsRUFBZWhCLE9BQU8sQ0FBdEIsQ0FBVjtBQUNBRSw0QkFBVUUsUUFBUTJCLEtBQVIsQ0FBYyxJQUFkLENBQVY7QUFDQTVCLDJCQUFVRCxNQUFNVyxNQUFOLEdBQWUsQ0FBekI7O0FBRUEsd0JBQUtWLE9BQU8sQ0FBWixFQUFnQjtBQUNaRyxtQ0FBYVMsT0FBT1osSUFBcEI7QUFDQUkscUNBQWFQLE9BQU9FLE1BQU1DLElBQU4sRUFBWVUsTUFBaEM7QUFDSCxxQkFIRCxNQUdPO0FBQ0hQLG1DQUFhUyxJQUFiO0FBQ0FSLHFDQUFhTyxNQUFiO0FBQ0g7O0FBRURILG1DQUFlLENBQUMsVUFBRCxFQUFhUCxPQUFiLEVBQ1hXLElBRFcsRUFDREMsTUFBT0YsTUFETixFQUVYUixRQUZXLEVBRUROLE9BQU9PLFVBRk4sQ0FBZjs7QUFLQU8sNkJBQVNQLFVBQVQ7QUFDQVEsMkJBQVNULFFBQVQ7QUFDQVUsMEJBQVNoQixJQUFUO0FBQ0o7QUFFQyxpQkF2Q0QsTUF1Q087QUFDSEEsMkJBQVVMLElBQUlxQyxPQUFKLENBQVksR0FBWixFQUFpQmhCLE1BQU0sQ0FBdkIsQ0FBVjtBQUNBWiw4QkFBVVQsSUFBSW1DLEtBQUosQ0FBVWQsR0FBVixFQUFlaEIsT0FBTyxDQUF0QixDQUFWOztBQUVBLHdCQUFLQSxTQUFTLENBQUMsQ0FBVixJQUFlVixlQUFlMkMsSUFBZixDQUFvQjdCLE9BQXBCLENBQXBCLEVBQW1EO0FBQy9DTyx1Q0FBZSxDQUFDLEdBQUQsRUFBTSxHQUFOLEVBQVdJLElBQVgsRUFBaUJDLE1BQU1GLE1BQXZCLENBQWY7QUFDSCxxQkFGRCxNQUVPO0FBQ0hILHVDQUFlLENBQUMsVUFBRCxFQUFhUCxPQUFiLEVBQ1hXLElBRFcsRUFDTEMsTUFBT0YsTUFERixFQUVYQyxJQUZXLEVBRUxmLE9BQU9jLE1BRkYsQ0FBZjtBQUlBRSw4QkFBTWhCLElBQU47QUFDSDtBQUNKOztBQUVEOztBQUVKLGlCQUFLckIsaUJBQUw7QUFDSWdDLCtCQUFlLENBQUMsR0FBRCxFQUFNLEdBQU4sRUFBV0ksSUFBWCxFQUFpQkMsTUFBTUYsTUFBdkIsQ0FBZjtBQUNBOztBQUVKLGlCQUFLL0MsWUFBTDtBQUNBLGlCQUFLQyxZQUFMO0FBQ0k7QUFDQWlDLHdCQUFRRixJQUFSO0FBQ0FDLHVCQUFRZ0IsR0FBUjs7QUFFQVIsMEJBQVUsS0FBVjtBQUNBLHVCQUFRUixPQUFPYSxNQUFmLEVBQXdCO0FBQ3BCYjtBQUNBLHdCQUFLQSxTQUFTYSxNQUFkLEVBQXVCTSxTQUFTLFFBQVQ7O0FBRXZCcEIsMkJBQU9KLElBQUlnQyxVQUFKLENBQWUzQixJQUFmLENBQVA7QUFDQVUsd0JBQUlmLElBQUlnQyxVQUFKLENBQWUzQixPQUFPLENBQXRCLENBQUo7O0FBRUEsd0JBQUssQ0FBQ1EsT0FBRCxJQUFZVCxTQUFTRSxLQUExQixFQUFrQztBQUM5QjtBQUNILHFCQUZELE1BRU8sSUFBS0YsU0FBUzlCLFNBQWQsRUFBMEI7QUFDN0J1QyxrQ0FBVSxDQUFDQSxPQUFYO0FBQ0gscUJBRk0sTUFFQSxJQUFLQSxPQUFMLEVBQWU7QUFDbEJBLGtDQUFVLEtBQVY7QUFDSCxxQkFGTSxNQUVBLElBQUtULFNBQVNaLElBQVQsSUFBaUJ1QixNQUFNOUIsVUFBNUIsRUFBeUM7QUFDNUMyQztBQUNIO0FBQ0o7QUFDRDs7QUFFQW5CLDBCQUFVVCxJQUFJbUMsS0FBSixDQUFVZCxHQUFWLEVBQWVoQixPQUFPLENBQXRCLENBQVY7QUFDQUUsd0JBQVVFLFFBQVEyQixLQUFSLENBQWMsSUFBZCxDQUFWO0FBQ0E1Qix1QkFBVUQsTUFBTVcsTUFBTixHQUFlLENBQXpCOztBQUVBLG9CQUFLVixPQUFPLENBQVosRUFBZ0I7QUFDWkcsK0JBQWFTLE9BQU9aLElBQXBCO0FBQ0FJLGlDQUFhUCxPQUFPRSxNQUFNQyxJQUFOLEVBQVlVLE1BQWhDO0FBQ0gsaUJBSEQsTUFHTztBQUNIUCwrQkFBYVMsSUFBYjtBQUNBUixpQ0FBYU8sTUFBYjtBQUNIOztBQUVESCwrQkFBZSxDQUFDLFFBQUQsRUFBV2hCLElBQUltQyxLQUFKLENBQVVkLEdBQVYsRUFBZWhCLE9BQU8sQ0FBdEIsQ0FBWCxFQUNYZSxJQURXLEVBQ0xDLE1BQU9GLE1BREYsRUFFWFIsUUFGVyxFQUVETixPQUFPTyxVQUZOLENBQWY7O0FBS0FPLHlCQUFTUCxVQUFUO0FBQ0FRLHVCQUFTVCxRQUFUO0FBQ0FVLHNCQUFTaEIsSUFBVDtBQUNBOztBQUVKLGlCQUFLZixFQUFMO0FBQ0lHLDBCQUFVOEMsU0FBVixHQUFzQmxCLE1BQU0sQ0FBNUI7QUFDQTVCLDBCQUFVNkMsSUFBVixDQUFldEMsR0FBZjtBQUNBLG9CQUFLUCxVQUFVOEMsU0FBVixLQUF3QixDQUE3QixFQUFpQztBQUM3QmxDLDJCQUFPTCxJQUFJa0IsTUFBSixHQUFhLENBQXBCO0FBQ0gsaUJBRkQsTUFFTztBQUNIYiwyQkFBT1osVUFBVThDLFNBQVYsR0FBc0IsQ0FBN0I7QUFDSDs7QUFFRHZCLCtCQUFlLENBQUMsU0FBRCxFQUFZaEIsSUFBSW1DLEtBQUosQ0FBVWQsR0FBVixFQUFlaEIsT0FBTyxDQUF0QixDQUFaLEVBQ1hlLElBRFcsRUFDTEMsTUFBT0YsTUFERixFQUVYQyxJQUZXLEVBRUxmLE9BQU9jLE1BRkYsQ0FBZjs7QUFLQUUsc0JBQU1oQixJQUFOO0FBQ0E7O0FBRUosaUJBQUsvQixTQUFMO0FBQ0krQix1QkFBU2dCLEdBQVQ7QUFDQVgseUJBQVMsSUFBVDtBQUNBLHVCQUFRVixJQUFJZ0MsVUFBSixDQUFlM0IsT0FBTyxDQUF0QixNQUE2Qi9CLFNBQXJDLEVBQWlEO0FBQzdDK0IsNEJBQVMsQ0FBVDtBQUNBSyw2QkFBUyxDQUFDQSxNQUFWO0FBQ0g7QUFDRE4sdUJBQU9KLElBQUlnQyxVQUFKLENBQWUzQixPQUFPLENBQXRCLENBQVA7QUFDQSxvQkFBS0ssVUFBV04sU0FBUzdCLEtBQVQsSUFDQTZCLFNBQVMzQixLQURULElBRUEyQixTQUFTNUIsT0FGVCxJQUdBNEIsU0FBU3pCLEdBSFQsSUFJQXlCLFNBQVN4QixFQUpULElBS0F3QixTQUFTMUIsSUFMekIsRUFLa0M7QUFDOUIyQiw0QkFBUSxDQUFSO0FBQ0Esd0JBQUtULGNBQWMwQyxJQUFkLENBQW1CdEMsSUFBSXdDLE1BQUosQ0FBV25DLElBQVgsQ0FBbkIsQ0FBTCxFQUE0QztBQUN4QywrQkFBUVQsY0FBYzBDLElBQWQsQ0FBbUJ0QyxJQUFJd0MsTUFBSixDQUFXbkMsT0FBTyxDQUFsQixDQUFuQixDQUFSLEVBQW1EO0FBQy9DQSxvQ0FBUSxDQUFSO0FBQ0g7QUFDRCw0QkFBS0wsSUFBSWdDLFVBQUosQ0FBZTNCLE9BQU8sQ0FBdEIsTUFBNkI1QixLQUFsQyxFQUEwQztBQUN0QzRCLG9DQUFRLENBQVI7QUFDSDtBQUNKO0FBQ0o7O0FBRURXLCtCQUFlLENBQUMsTUFBRCxFQUFTaEIsSUFBSW1DLEtBQUosQ0FBVWQsR0FBVixFQUFlaEIsT0FBTyxDQUF0QixDQUFULEVBQ1hlLElBRFcsRUFDTEMsTUFBT0YsTUFERixFQUVYQyxJQUZXLEVBRUxmLE9BQU9jLE1BRkYsQ0FBZjs7QUFLQUUsc0JBQU1oQixJQUFOO0FBQ0E7O0FBRUo7QUFDSTtBQUNBVSxvQkFBSWYsSUFBSWdDLFVBQUosQ0FBZVgsTUFBTSxDQUFyQixDQUFKOztBQUVBLG9CQUFLakIsU0FBU1osSUFBVCxJQUFpQnVCLE1BQU05QixVQUE1QixFQUF5QztBQUNyQ29CLDJCQUFPZ0IsR0FBUDtBQUNBTzs7QUFFQW5CLDhCQUFVVCxJQUFJbUMsS0FBSixDQUFVZCxHQUFWLEVBQWVoQixPQUFPLENBQXRCLENBQVY7QUFDQUUsNEJBQVVFLFFBQVEyQixLQUFSLENBQWMsSUFBZCxDQUFWO0FBQ0E1QiwyQkFBVUQsTUFBTVcsTUFBTixHQUFlLENBQXpCOztBQUVBLHdCQUFLVixPQUFPLENBQVosRUFBZ0I7QUFDWkcsbUNBQWFTLE9BQU9aLElBQXBCO0FBQ0FJLHFDQUFhUCxPQUFPRSxNQUFNQyxJQUFOLEVBQVlVLE1BQWhDO0FBQ0gscUJBSEQsTUFHTztBQUNIUCxtQ0FBYVMsSUFBYjtBQUNBUixxQ0FBYU8sTUFBYjtBQUNIOztBQUVESCxtQ0FBZSxDQUFDLE1BQUQsRUFBU1AsT0FBVCxFQUNYVyxJQURXLEVBQ0RDLE1BQU9GLE1BRE4sRUFFWFIsUUFGVyxFQUVETixPQUFPTyxVQUZOLENBQWY7O0FBS0FPLDZCQUFTUCxVQUFUO0FBQ0FRLDJCQUFTVCxRQUFUO0FBQ0FVLDBCQUFTaEIsSUFBVDtBQUVILGlCQXpCRCxNQXlCTyxJQUFLRCxTQUFTN0IsS0FBVCxJQUFrQndDLE1BQU0zQixRQUE3QixFQUF3QztBQUMvQztBQUNJaUIsMkJBQU9MLElBQUlxQyxPQUFKLENBQVksSUFBWixFQUFrQmhCLE1BQU0sQ0FBeEIsSUFBNkIsQ0FBcEM7QUFDQSx3QkFBS2hCLFNBQVMsQ0FBZCxFQUFrQjtBQUNkLDRCQUFLSCxNQUFMLEVBQWM7QUFDVkcsbUNBQU9MLElBQUlrQixNQUFYO0FBQ0gseUJBRkQsTUFFTztBQUNITSxxQ0FBUyxTQUFUO0FBQ0g7QUFDSjs7QUFFRGYsOEJBQVVULElBQUltQyxLQUFKLENBQVVkLEdBQVYsRUFBZWhCLE9BQU8sQ0FBdEIsQ0FBVjtBQUNBRSw0QkFBVUUsUUFBUTJCLEtBQVIsQ0FBYyxJQUFkLENBQVY7QUFDQTVCLDJCQUFVRCxNQUFNVyxNQUFOLEdBQWUsQ0FBekI7O0FBRUEsd0JBQUtWLE9BQU8sQ0FBWixFQUFnQjtBQUNaRyxtQ0FBYVMsT0FBT1osSUFBcEI7QUFDQUkscUNBQWFQLE9BQU9FLE1BQU1DLElBQU4sRUFBWVUsTUFBaEM7QUFDSCxxQkFIRCxNQUdPO0FBQ0hQLG1DQUFhUyxJQUFiO0FBQ0FSLHFDQUFhTyxNQUFiO0FBQ0g7O0FBRURILG1DQUFlLENBQUMsU0FBRCxFQUFZUCxPQUFaLEVBQ1hXLElBRFcsRUFDREMsTUFBT0YsTUFETixFQUVYUixRQUZXLEVBRUROLE9BQU9PLFVBRk4sQ0FBZjs7QUFLQU8sNkJBQVNQLFVBQVQ7QUFDQVEsMkJBQVNULFFBQVQ7QUFDQVUsMEJBQVNoQixJQUFUOztBQUVKO0FBQ0MsaUJBakNNLE1BaUNBLElBQUtELFNBQVM3QixLQUFULElBQWtCd0MsTUFBTXhDLEtBQTdCLEVBQXFDO0FBQ3hDc0IsZ0NBQVkwQyxTQUFaLEdBQXdCbEIsTUFBTSxDQUE5QjtBQUNBeEIsZ0NBQVl5QyxJQUFaLENBQWlCdEMsR0FBakI7QUFDQSx3QkFBS0gsWUFBWTBDLFNBQVosS0FBMEIsQ0FBL0IsRUFBbUM7QUFDL0JsQywrQkFBT0wsSUFBSWtCLE1BQUosR0FBYSxDQUFwQjtBQUNILHFCQUZELE1BRU87QUFDSGIsK0JBQU9SLFlBQVkwQyxTQUFaLEdBQXdCLENBQS9CO0FBQ0g7O0FBRUQ5Qiw4QkFBVVQsSUFBSW1DLEtBQUosQ0FBVWQsR0FBVixFQUFlaEIsT0FBTyxDQUF0QixDQUFWOztBQUVBVyxtQ0FBZSxDQUFDLFNBQUQsRUFBWVAsT0FBWixFQUNYVyxJQURXLEVBQ0xDLE1BQU9GLE1BREYsRUFFWEMsSUFGVyxFQUVMZixPQUFPYyxNQUZGLEVBR1gsUUFIVyxDQUFmOztBQU1BRSwwQkFBTWhCLElBQU47QUFDQTtBQUVILGlCQXBCTSxNQW9CQTtBQUNIWCxnQ0FBWTZDLFNBQVosR0FBd0JsQixNQUFNLENBQTlCO0FBQ0EzQixnQ0FBWTRDLElBQVosQ0FBaUJ0QyxHQUFqQjtBQUNBLHdCQUFLTixZQUFZNkMsU0FBWixLQUEwQixDQUEvQixFQUFtQztBQUMvQmxDLCtCQUFPTCxJQUFJa0IsTUFBSixHQUFhLENBQXBCO0FBQ0gscUJBRkQsTUFFTztBQUNIYiwrQkFBT1gsWUFBWTZDLFNBQVosR0FBd0IsQ0FBL0I7QUFDSDs7QUFFRHZCLG1DQUFlLENBQUMsTUFBRCxFQUFTaEIsSUFBSW1DLEtBQUosQ0FBVWQsR0FBVixFQUFlaEIsT0FBTyxDQUF0QixDQUFULEVBQ1hlLElBRFcsRUFDTEMsTUFBT0YsTUFERixFQUVYQyxJQUZXLEVBRUxmLE9BQU9jLE1BRkYsQ0FBZjs7QUFLQUcsMkJBQU9tQixJQUFQLENBQVl6QixZQUFaOztBQUVBSywwQkFBTWhCLElBQU47QUFDSDs7QUFFRDtBQW5VSjs7QUFzVUFnQjtBQUNBLGVBQU9MLFlBQVA7QUFDSDs7QUFFRCxhQUFTMEIsSUFBVCxDQUFjQyxLQUFkLEVBQXFCO0FBQ2pCcEIsaUJBQVNrQixJQUFULENBQWNFLEtBQWQ7QUFDSDs7QUFFRCxXQUFPO0FBQ0hELGtCQURHO0FBRUhULDRCQUZHO0FBR0hOO0FBSEcsS0FBUDtBQUtIIiwiZmlsZSI6InNjc3MtdG9rZW5pemUuanMiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBTSU5HTEVfUVVPVEUgICAgICA9ICdcXCcnLmNoYXJDb2RlQXQoMCk7XG5jb25zdCBET1VCTEVfUVVPVEUgICAgICA9ICAnXCInLmNoYXJDb2RlQXQoMCk7XG5jb25zdCBCQUNLU0xBU0ggICAgICAgICA9ICdcXFxcJy5jaGFyQ29kZUF0KDApO1xuY29uc3QgU0xBU0ggICAgICAgICAgICAgPSAgJy8nLmNoYXJDb2RlQXQoMCk7XG5jb25zdCBORVdMSU5FICAgICAgICAgICA9ICdcXG4nLmNoYXJDb2RlQXQoMCk7XG5jb25zdCBTUEFDRSAgICAgICAgICAgICA9ICAnICcuY2hhckNvZGVBdCgwKTtcbmNvbnN0IEZFRUQgICAgICAgICAgICAgID0gJ1xcZicuY2hhckNvZGVBdCgwKTtcbmNvbnN0IFRBQiAgICAgICAgICAgICAgID0gJ1xcdCcuY2hhckNvZGVBdCgwKTtcbmNvbnN0IENSICAgICAgICAgICAgICAgID0gJ1xccicuY2hhckNvZGVBdCgwKTtcbmNvbnN0IE9QRU5fU1FVQVJFICAgICAgID0gICdbJy5jaGFyQ29kZUF0KDApO1xuY29uc3QgQ0xPU0VfU1FVQVJFICAgICAgPSAgJ10nLmNoYXJDb2RlQXQoMCk7XG5jb25zdCBPUEVOX1BBUkVOVEhFU0VTICA9ICAnKCcuY2hhckNvZGVBdCgwKTtcbmNvbnN0IENMT1NFX1BBUkVOVEhFU0VTID0gICcpJy5jaGFyQ29kZUF0KDApO1xuY29uc3QgT1BFTl9DVVJMWSAgICAgICAgPSAgJ3snLmNoYXJDb2RlQXQoMCk7XG5jb25zdCBDTE9TRV9DVVJMWSAgICAgICA9ICAnfScuY2hhckNvZGVBdCgwKTtcbmNvbnN0IFNFTUlDT0xPTiAgICAgICAgID0gICc7Jy5jaGFyQ29kZUF0KDApO1xuY29uc3QgQVNURVJJU0sgICAgICAgICAgPSAgJyonLmNoYXJDb2RlQXQoMCk7XG5jb25zdCBDT0xPTiAgICAgICAgICAgICA9ICAnOicuY2hhckNvZGVBdCgwKTtcbmNvbnN0IEFUICAgICAgICAgICAgICAgID0gICdAJy5jaGFyQ29kZUF0KDApO1xuXG4vLyBTQ1NTIFBBVENIIHtcbmNvbnN0IENPTU1BICAgICAgICAgICAgID0gICcsJy5jaGFyQ29kZUF0KDApO1xuY29uc3QgSEFTSCAgICAgICAgICAgICAgPSAgJyMnLmNoYXJDb2RlQXQoMCk7XG4vLyB9IFNDU1MgUEFUQ0hcblxuY29uc3QgUkVfQVRfRU5EICAgICAgPSAvWyBcXG5cXHRcXHJcXGZcXHtcXH1cXChcXCknXCJcXFxcOy9cXFtcXF0jXS9nO1xuY29uc3QgUkVfV09SRF9FTkQgICAgPSAvWyBcXG5cXHRcXHJcXGZcXChcXClcXHtcXH06O0AhJ1wiXFxcXFxcXVxcWyNdfFxcLyg/PVxcKikvZztcbmNvbnN0IFJFX0JBRF9CUkFDS0VUID0gLy5bXFxcXFxcL1xcKFwiJ1xcbl0vO1xuY29uc3QgUkVfSEVYX0VTQ0FQRSAgPSAvW2EtZjAtOV0vaTtcblxuY29uc3QgUkVfTkVXX0xJTkUgICAgPSAvW1xcclxcZlxcbl0vZzsgLy8gU0NTUyBQQVRDSFxuXG4vLyBTQ1NTIFBBVENIIGZ1bmN0aW9uIG5hbWUgd2FzIGNoYW5nZWRcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHNjc3NUb2tlbml6ZShpbnB1dCwgb3B0aW9ucyA9IHt9KSB7XG4gICAgbGV0IGNzcyA9IGlucHV0LmNzcy52YWx1ZU9mKCk7XG4gICAgbGV0IGlnbm9yZSA9IG9wdGlvbnMuaWdub3JlRXJyb3JzO1xuXG4gICAgbGV0IGNvZGUsIG5leHQsIHF1b3RlLCBsaW5lcywgbGFzdCwgY29udGVudCwgZXNjYXBlLFxuICAgICAgICBuZXh0TGluZSwgbmV4dE9mZnNldCwgZXNjYXBlZCwgcHJldiwgbiwgY3VycmVudFRva2VuO1xuXG4gICAgbGV0IGJyYWNrZXRzOyAvLyBTQ1NTIFBBVENIXG5cbiAgICBsZXQgbGVuZ3RoID0gY3NzLmxlbmd0aDtcbiAgICBsZXQgb2Zmc2V0ID0gLTE7XG4gICAgbGV0IGxpbmUgPSAxO1xuICAgIGxldCBwb3MgPSAwO1xuICAgIGxldCBidWZmZXIgPSBbXTtcbiAgICBsZXQgcmV0dXJuZWQgPSBbXTtcblxuICAgIGZ1bmN0aW9uIHVuY2xvc2VkKHdoYXQpIHtcbiAgICAgICAgdGhyb3cgaW5wdXQuZXJyb3IoJ1VuY2xvc2VkICcgKyB3aGF0LCBsaW5lLCBwb3MgLSBvZmZzZXQpO1xuICAgIH1cblxuICAgIGZ1bmN0aW9uIGVuZE9mRmlsZSgpIHtcbiAgICAgICAgcmV0dXJuIHJldHVybmVkLmxlbmd0aCA9PT0gMCAmJiBwb3MgPj0gbGVuZ3RoO1xuICAgIH1cblxuICAgIC8vIFNDU1MgUEFUQ0gge1xuICAgIGZ1bmN0aW9uIGludGVycG9sYXRpb24oKSB7XG4gICAgICAgIGxldCBkZWVwID0gMTtcbiAgICAgICAgbGV0IHN0cmluZ1F1b3RlID0gZmFsc2U7XG4gICAgICAgIGxldCBzdHJpbmdFc2NhcGVkID0gZmFsc2U7XG4gICAgICAgIHdoaWxlICggZGVlcCA+IDAgKSB7XG4gICAgICAgICAgICBuZXh0ICs9IDE7XG4gICAgICAgICAgICBpZiAoIGNzcy5sZW5ndGggPD0gbmV4dCApIHVuY2xvc2VkKCdpbnRlcnBvbGF0aW9uJyk7XG5cbiAgICAgICAgICAgIGNvZGUgPSBjc3MuY2hhckNvZGVBdChuZXh0KTtcbiAgICAgICAgICAgIG4gICAgPSBjc3MuY2hhckNvZGVBdChuZXh0ICsgMSk7XG5cbiAgICAgICAgICAgIGlmICggc3RyaW5nUXVvdGUgKSB7XG4gICAgICAgICAgICAgICAgaWYgKCAhc3RyaW5nRXNjYXBlZCAmJiBjb2RlID09PSBzdHJpbmdRdW90ZSApIHtcbiAgICAgICAgICAgICAgICAgICAgc3RyaW5nUXVvdGUgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICAgICAgc3RyaW5nRXNjYXBlZCA9IGZhbHNlO1xuICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAoIGNvZGUgPT09IEJBQ0tTTEFTSCApIHtcbiAgICAgICAgICAgICAgICAgICAgc3RyaW5nRXNjYXBlZCA9ICFlc2NhcGVkO1xuICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAoIHN0cmluZ0VzY2FwZWQgKSB7XG4gICAgICAgICAgICAgICAgICAgIHN0cmluZ0VzY2FwZWQgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9IGVsc2UgaWYgKFxuICAgICAgICAgICAgICAgIGNvZGUgPT09IFNJTkdMRV9RVU9URSB8fCBjb2RlID09PSBET1VCTEVfUVVPVEVcbiAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICAgIHN0cmluZ1F1b3RlID0gY29kZTtcbiAgICAgICAgICAgIH0gZWxzZSBpZiAoIGNvZGUgPT09IENMT1NFX0NVUkxZICkge1xuICAgICAgICAgICAgICAgIGRlZXAgLT0gMTtcbiAgICAgICAgICAgIH0gZWxzZSBpZiAoIGNvZGUgPT09IEhBU0ggJiYgbiA9PT0gT1BFTl9DVVJMWSApIHtcbiAgICAgICAgICAgICAgICBkZWVwICs9IDE7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICB9XG4gICAgLy8gfSBTQ1NTIFBBVENIXG5cbiAgICBmdW5jdGlvbiBuZXh0VG9rZW4oKSB7XG4gICAgICAgIGlmICggcmV0dXJuZWQubGVuZ3RoICkgcmV0dXJuIHJldHVybmVkLnBvcCgpO1xuICAgICAgICBpZiAoIHBvcyA+PSBsZW5ndGggKSByZXR1cm47XG5cbiAgICAgICAgY29kZSA9IGNzcy5jaGFyQ29kZUF0KHBvcyk7XG4gICAgICAgIGlmICggY29kZSA9PT0gTkVXTElORSB8fCBjb2RlID09PSBGRUVEIHx8XG4gICAgICAgICAgICAgY29kZSA9PT0gQ1IgJiYgY3NzLmNoYXJDb2RlQXQocG9zICsgMSkgIT09IE5FV0xJTkUgKSB7XG4gICAgICAgICAgICBvZmZzZXQgPSBwb3M7XG4gICAgICAgICAgICBsaW5lICs9IDE7XG4gICAgICAgIH1cblxuICAgICAgICBzd2l0Y2ggKCBjb2RlICkge1xuICAgICAgICBjYXNlIE5FV0xJTkU6XG4gICAgICAgIGNhc2UgU1BBQ0U6XG4gICAgICAgIGNhc2UgVEFCOlxuICAgICAgICBjYXNlIENSOlxuICAgICAgICBjYXNlIEZFRUQ6XG4gICAgICAgICAgICBuZXh0ID0gcG9zO1xuICAgICAgICAgICAgZG8ge1xuICAgICAgICAgICAgICAgIG5leHQgKz0gMTtcbiAgICAgICAgICAgICAgICBjb2RlID0gY3NzLmNoYXJDb2RlQXQobmV4dCk7XG4gICAgICAgICAgICAgICAgaWYgKCBjb2RlID09PSBORVdMSU5FICkge1xuICAgICAgICAgICAgICAgICAgICBvZmZzZXQgPSBuZXh0O1xuICAgICAgICAgICAgICAgICAgICBsaW5lICs9IDE7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSB3aGlsZSAoIGNvZGUgPT09IFNQQUNFICAgfHxcbiAgICAgICAgICAgICAgICAgICAgICBjb2RlID09PSBORVdMSU5FIHx8XG4gICAgICAgICAgICAgICAgICAgICAgY29kZSA9PT0gVEFCICAgICB8fFxuICAgICAgICAgICAgICAgICAgICAgIGNvZGUgPT09IENSICAgICAgfHxcbiAgICAgICAgICAgICAgICAgICAgICBjb2RlID09PSBGRUVEICk7XG5cbiAgICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnc3BhY2UnLCBjc3Muc2xpY2UocG9zLCBuZXh0KV07XG4gICAgICAgICAgICBwb3MgPSBuZXh0IC0gMTtcbiAgICAgICAgICAgIGJyZWFrO1xuXG4gICAgICAgIGNhc2UgT1BFTl9TUVVBUkU6XG4gICAgICAgICAgICBjdXJyZW50VG9rZW4gPSBbJ1snLCAnWycsIGxpbmUsIHBvcyAtIG9mZnNldF07XG4gICAgICAgICAgICBicmVhaztcblxuICAgICAgICBjYXNlIENMT1NFX1NRVUFSRTpcbiAgICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnXScsICddJywgbGluZSwgcG9zIC0gb2Zmc2V0XTtcbiAgICAgICAgICAgIGJyZWFrO1xuXG4gICAgICAgIGNhc2UgT1BFTl9DVVJMWTpcbiAgICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFsneycsICd7JywgbGluZSwgcG9zIC0gb2Zmc2V0XTtcbiAgICAgICAgICAgIGJyZWFrO1xuXG4gICAgICAgIGNhc2UgQ0xPU0VfQ1VSTFk6XG4gICAgICAgICAgICBjdXJyZW50VG9rZW4gPSBbJ30nLCAnfScsIGxpbmUsIHBvcyAtIG9mZnNldF07XG4gICAgICAgICAgICBicmVhaztcblxuICAgICAgICAvLyBTQ1NTIFBBVENIIHtcbiAgICAgICAgY2FzZSBDT01NQTpcbiAgICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFtcbiAgICAgICAgICAgICAgICAnd29yZCcsXG4gICAgICAgICAgICAgICAgJywnLFxuICAgICAgICAgICAgICAgIGxpbmUsIHBvcyAtIG9mZnNldCxcbiAgICAgICAgICAgICAgICBsaW5lLCBwb3MgLSBvZmZzZXQgKyAxXG4gICAgICAgICAgICBdO1xuICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgIC8vIH0gU0NTUyBQQVRDSFxuXG4gICAgICAgIGNhc2UgQ09MT046XG4gICAgICAgICAgICBjdXJyZW50VG9rZW4gPSBbJzonLCAnOicsIGxpbmUsIHBvcyAtIG9mZnNldF07XG4gICAgICAgICAgICBicmVhaztcblxuICAgICAgICBjYXNlIFNFTUlDT0xPTjpcbiAgICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnOycsICc7JywgbGluZSwgcG9zIC0gb2Zmc2V0XTtcbiAgICAgICAgICAgIGJyZWFrO1xuXG4gICAgICAgIGNhc2UgT1BFTl9QQVJFTlRIRVNFUzpcbiAgICAgICAgICAgIHByZXYgPSBidWZmZXIubGVuZ3RoID8gYnVmZmVyLnBvcCgpWzFdIDogJyc7XG4gICAgICAgICAgICBuICAgID0gY3NzLmNoYXJDb2RlQXQocG9zICsgMSk7XG5cbiAgICAgICAgICAgIC8vIFNDU1MgUEFUQ0gge1xuICAgICAgICAgICAgaWYgKCBwcmV2ID09PSAndXJsJyAmJiBuICE9PSBTSU5HTEVfUVVPVEUgJiYgbiAhPT0gRE9VQkxFX1FVT1RFICkge1xuICAgICAgICAgICAgICAgIGJyYWNrZXRzID0gMTtcbiAgICAgICAgICAgICAgICBlc2NhcGVkICA9IGZhbHNlO1xuICAgICAgICAgICAgICAgIG5leHQgICAgID0gcG9zICsgMTtcbiAgICAgICAgICAgICAgICB3aGlsZSAoIG5leHQgPD0gY3NzLmxlbmd0aCAtIDEgKSB7XG4gICAgICAgICAgICAgICAgICAgIG4gPSBjc3MuY2hhckNvZGVBdChuZXh0KTtcbiAgICAgICAgICAgICAgICAgICAgaWYgKCBuID09PSBCQUNLU0xBU0ggKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBlc2NhcGVkID0gIWVzY2FwZWQ7XG4gICAgICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAoIG4gPT09IE9QRU5fUEFSRU5USEVTRVMgKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBicmFja2V0cyArPSAxO1xuICAgICAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKCBuID09PSBDTE9TRV9QQVJFTlRIRVNFUyApIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGJyYWNrZXRzIC09IDE7XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoIGJyYWNrZXRzID09PSAwICkgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgbmV4dCArPSAxO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIGNvbnRlbnQgPSBjc3Muc2xpY2UocG9zLCBuZXh0ICsgMSk7XG4gICAgICAgICAgICAgICAgbGluZXMgICA9IGNvbnRlbnQuc3BsaXQoJ1xcbicpO1xuICAgICAgICAgICAgICAgIGxhc3QgICAgPSBsaW5lcy5sZW5ndGggLSAxO1xuXG4gICAgICAgICAgICAgICAgaWYgKCBsYXN0ID4gMCApIHtcbiAgICAgICAgICAgICAgICAgICAgbmV4dExpbmUgICA9IGxpbmUgKyBsYXN0O1xuICAgICAgICAgICAgICAgICAgICBuZXh0T2Zmc2V0ID0gbmV4dCAtIGxpbmVzW2xhc3RdLmxlbmd0aDtcbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICBuZXh0TGluZSAgID0gbGluZTtcbiAgICAgICAgICAgICAgICAgICAgbmV4dE9mZnNldCA9IG9mZnNldDtcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICBjdXJyZW50VG9rZW4gPSBbJ2JyYWNrZXRzJywgY29udGVudCxcbiAgICAgICAgICAgICAgICAgICAgbGluZSwgICAgIHBvcyAgLSBvZmZzZXQsXG4gICAgICAgICAgICAgICAgICAgIG5leHRMaW5lLCBuZXh0IC0gbmV4dE9mZnNldFxuICAgICAgICAgICAgICAgIF07XG5cbiAgICAgICAgICAgICAgICBvZmZzZXQgPSBuZXh0T2Zmc2V0O1xuICAgICAgICAgICAgICAgIGxpbmUgICA9IG5leHRMaW5lO1xuICAgICAgICAgICAgICAgIHBvcyAgICA9IG5leHQ7XG4gICAgICAgICAgICAvLyB9IFNDU1MgUEFUQ0hcblxuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBuZXh0ICAgID0gY3NzLmluZGV4T2YoJyknLCBwb3MgKyAxKTtcbiAgICAgICAgICAgICAgICBjb250ZW50ID0gY3NzLnNsaWNlKHBvcywgbmV4dCArIDEpO1xuXG4gICAgICAgICAgICAgICAgaWYgKCBuZXh0ID09PSAtMSB8fCBSRV9CQURfQlJBQ0tFVC50ZXN0KGNvbnRlbnQpICkge1xuICAgICAgICAgICAgICAgICAgICBjdXJyZW50VG9rZW4gPSBbJygnLCAnKCcsIGxpbmUsIHBvcyAtIG9mZnNldF07XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgY3VycmVudFRva2VuID0gWydicmFja2V0cycsIGNvbnRlbnQsXG4gICAgICAgICAgICAgICAgICAgICAgICBsaW5lLCBwb3MgIC0gb2Zmc2V0LFxuICAgICAgICAgICAgICAgICAgICAgICAgbGluZSwgbmV4dCAtIG9mZnNldFxuICAgICAgICAgICAgICAgICAgICBdO1xuICAgICAgICAgICAgICAgICAgICBwb3MgPSBuZXh0O1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgYnJlYWs7XG5cbiAgICAgICAgY2FzZSBDTE9TRV9QQVJFTlRIRVNFUzpcbiAgICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnKScsICcpJywgbGluZSwgcG9zIC0gb2Zmc2V0XTtcbiAgICAgICAgICAgIGJyZWFrO1xuXG4gICAgICAgIGNhc2UgU0lOR0xFX1FVT1RFOlxuICAgICAgICBjYXNlIERPVUJMRV9RVU9URTpcbiAgICAgICAgICAgIC8vIFNDU1MgUEFUQ0gge1xuICAgICAgICAgICAgcXVvdGUgPSBjb2RlO1xuICAgICAgICAgICAgbmV4dCAgPSBwb3M7XG5cbiAgICAgICAgICAgIGVzY2FwZWQgPSBmYWxzZTtcbiAgICAgICAgICAgIHdoaWxlICggbmV4dCA8IGxlbmd0aCApIHtcbiAgICAgICAgICAgICAgICBuZXh0Kys7XG4gICAgICAgICAgICAgICAgaWYgKCBuZXh0ID09PSBsZW5ndGggKSB1bmNsb3NlZCgnc3RyaW5nJyk7XG5cbiAgICAgICAgICAgICAgICBjb2RlID0gY3NzLmNoYXJDb2RlQXQobmV4dCk7XG4gICAgICAgICAgICAgICAgbiA9IGNzcy5jaGFyQ29kZUF0KG5leHQgKyAxKTtcblxuICAgICAgICAgICAgICAgIGlmICggIWVzY2FwZWQgJiYgY29kZSA9PT0gcXVvdGUgKSB7XG4gICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAoIGNvZGUgPT09IEJBQ0tTTEFTSCApIHtcbiAgICAgICAgICAgICAgICAgICAgZXNjYXBlZCA9ICFlc2NhcGVkO1xuICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAoIGVzY2FwZWQgKSB7XG4gICAgICAgICAgICAgICAgICAgIGVzY2FwZWQgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKCBjb2RlID09PSBIQVNIICYmIG4gPT09IE9QRU5fQ1VSTFkgKSB7XG4gICAgICAgICAgICAgICAgICAgIGludGVycG9sYXRpb24oKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICAvLyB9IFNDU1MgUEFUQ0hcblxuICAgICAgICAgICAgY29udGVudCA9IGNzcy5zbGljZShwb3MsIG5leHQgKyAxKTtcbiAgICAgICAgICAgIGxpbmVzICAgPSBjb250ZW50LnNwbGl0KCdcXG4nKTtcbiAgICAgICAgICAgIGxhc3QgICAgPSBsaW5lcy5sZW5ndGggLSAxO1xuXG4gICAgICAgICAgICBpZiAoIGxhc3QgPiAwICkge1xuICAgICAgICAgICAgICAgIG5leHRMaW5lICAgPSBsaW5lICsgbGFzdDtcbiAgICAgICAgICAgICAgICBuZXh0T2Zmc2V0ID0gbmV4dCAtIGxpbmVzW2xhc3RdLmxlbmd0aDtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgbmV4dExpbmUgICA9IGxpbmU7XG4gICAgICAgICAgICAgICAgbmV4dE9mZnNldCA9IG9mZnNldDtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgY3VycmVudFRva2VuID0gWydzdHJpbmcnLCBjc3Muc2xpY2UocG9zLCBuZXh0ICsgMSksXG4gICAgICAgICAgICAgICAgbGluZSwgcG9zICAtIG9mZnNldCxcbiAgICAgICAgICAgICAgICBuZXh0TGluZSwgbmV4dCAtIG5leHRPZmZzZXRcbiAgICAgICAgICAgIF07XG5cbiAgICAgICAgICAgIG9mZnNldCA9IG5leHRPZmZzZXQ7XG4gICAgICAgICAgICBsaW5lICAgPSBuZXh0TGluZTtcbiAgICAgICAgICAgIHBvcyAgICA9IG5leHQ7XG4gICAgICAgICAgICBicmVhaztcblxuICAgICAgICBjYXNlIEFUOlxuICAgICAgICAgICAgUkVfQVRfRU5ELmxhc3RJbmRleCA9IHBvcyArIDE7XG4gICAgICAgICAgICBSRV9BVF9FTkQudGVzdChjc3MpO1xuICAgICAgICAgICAgaWYgKCBSRV9BVF9FTkQubGFzdEluZGV4ID09PSAwICkge1xuICAgICAgICAgICAgICAgIG5leHQgPSBjc3MubGVuZ3RoIC0gMTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgbmV4dCA9IFJFX0FUX0VORC5sYXN0SW5kZXggLSAyO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBjdXJyZW50VG9rZW4gPSBbJ2F0LXdvcmQnLCBjc3Muc2xpY2UocG9zLCBuZXh0ICsgMSksXG4gICAgICAgICAgICAgICAgbGluZSwgcG9zICAtIG9mZnNldCxcbiAgICAgICAgICAgICAgICBsaW5lLCBuZXh0IC0gb2Zmc2V0XG4gICAgICAgICAgICBdO1xuXG4gICAgICAgICAgICBwb3MgPSBuZXh0O1xuICAgICAgICAgICAgYnJlYWs7XG5cbiAgICAgICAgY2FzZSBCQUNLU0xBU0g6XG4gICAgICAgICAgICBuZXh0ICAgPSBwb3M7XG4gICAgICAgICAgICBlc2NhcGUgPSB0cnVlO1xuICAgICAgICAgICAgd2hpbGUgKCBjc3MuY2hhckNvZGVBdChuZXh0ICsgMSkgPT09IEJBQ0tTTEFTSCApIHtcbiAgICAgICAgICAgICAgICBuZXh0ICArPSAxO1xuICAgICAgICAgICAgICAgIGVzY2FwZSA9ICFlc2NhcGU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBjb2RlID0gY3NzLmNoYXJDb2RlQXQobmV4dCArIDEpO1xuICAgICAgICAgICAgaWYgKCBlc2NhcGUgJiYgKGNvZGUgIT09IFNMQVNIICAgJiZcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlICE9PSBTUEFDRSAgICYmXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZSAhPT0gTkVXTElORSAmJlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGUgIT09IFRBQiAgICAgJiZcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlICE9PSBDUiAgICAgICYmXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZSAhPT0gRkVFRCApICkge1xuICAgICAgICAgICAgICAgIG5leHQgKz0gMTtcbiAgICAgICAgICAgICAgICBpZiAoIFJFX0hFWF9FU0NBUEUudGVzdChjc3MuY2hhckF0KG5leHQpKSApIHtcbiAgICAgICAgICAgICAgICAgICAgd2hpbGUgKCBSRV9IRVhfRVNDQVBFLnRlc3QoY3NzLmNoYXJBdChuZXh0ICsgMSkpICkge1xuICAgICAgICAgICAgICAgICAgICAgICAgbmV4dCArPSAxO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIGlmICggY3NzLmNoYXJDb2RlQXQobmV4dCArIDEpID09PSBTUEFDRSApIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIG5leHQgKz0gMTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgY3VycmVudFRva2VuID0gWyd3b3JkJywgY3NzLnNsaWNlKHBvcywgbmV4dCArIDEpLFxuICAgICAgICAgICAgICAgIGxpbmUsIHBvcyAgLSBvZmZzZXQsXG4gICAgICAgICAgICAgICAgbGluZSwgbmV4dCAtIG9mZnNldFxuICAgICAgICAgICAgXTtcblxuICAgICAgICAgICAgcG9zID0gbmV4dDtcbiAgICAgICAgICAgIGJyZWFrO1xuXG4gICAgICAgIGRlZmF1bHQ6XG4gICAgICAgICAgICAvLyBTQ1NTIFBBVENIIHtcbiAgICAgICAgICAgIG4gPSBjc3MuY2hhckNvZGVBdChwb3MgKyAxKTtcblxuICAgICAgICAgICAgaWYgKCBjb2RlID09PSBIQVNIICYmIG4gPT09IE9QRU5fQ1VSTFkgKSB7XG4gICAgICAgICAgICAgICAgbmV4dCA9IHBvcztcbiAgICAgICAgICAgICAgICBpbnRlcnBvbGF0aW9uKCk7XG5cbiAgICAgICAgICAgICAgICBjb250ZW50ID0gY3NzLnNsaWNlKHBvcywgbmV4dCArIDEpO1xuICAgICAgICAgICAgICAgIGxpbmVzICAgPSBjb250ZW50LnNwbGl0KCdcXG4nKTtcbiAgICAgICAgICAgICAgICBsYXN0ICAgID0gbGluZXMubGVuZ3RoIC0gMTtcblxuICAgICAgICAgICAgICAgIGlmICggbGFzdCA+IDAgKSB7XG4gICAgICAgICAgICAgICAgICAgIG5leHRMaW5lICAgPSBsaW5lICsgbGFzdDtcbiAgICAgICAgICAgICAgICAgICAgbmV4dE9mZnNldCA9IG5leHQgLSBsaW5lc1tsYXN0XS5sZW5ndGg7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgbmV4dExpbmUgICA9IGxpbmU7XG4gICAgICAgICAgICAgICAgICAgIG5leHRPZmZzZXQgPSBvZmZzZXQ7XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgY3VycmVudFRva2VuID0gWyd3b3JkJywgY29udGVudCxcbiAgICAgICAgICAgICAgICAgICAgbGluZSwgICAgIHBvcyAgLSBvZmZzZXQsXG4gICAgICAgICAgICAgICAgICAgIG5leHRMaW5lLCBuZXh0IC0gbmV4dE9mZnNldFxuICAgICAgICAgICAgICAgIF07XG5cbiAgICAgICAgICAgICAgICBvZmZzZXQgPSBuZXh0T2Zmc2V0O1xuICAgICAgICAgICAgICAgIGxpbmUgICA9IG5leHRMaW5lO1xuICAgICAgICAgICAgICAgIHBvcyAgICA9IG5leHQ7XG5cbiAgICAgICAgICAgIH0gZWxzZSBpZiAoIGNvZGUgPT09IFNMQVNIICYmIG4gPT09IEFTVEVSSVNLICkge1xuICAgICAgICAgICAgLy8gfSBTQ1NTIFBBVENIXG4gICAgICAgICAgICAgICAgbmV4dCA9IGNzcy5pbmRleE9mKCcqLycsIHBvcyArIDIpICsgMTtcbiAgICAgICAgICAgICAgICBpZiAoIG5leHQgPT09IDAgKSB7XG4gICAgICAgICAgICAgICAgICAgIGlmICggaWdub3JlICkge1xuICAgICAgICAgICAgICAgICAgICAgICAgbmV4dCA9IGNzcy5sZW5ndGg7XG4gICAgICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB1bmNsb3NlZCgnY29tbWVudCcpO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgY29udGVudCA9IGNzcy5zbGljZShwb3MsIG5leHQgKyAxKTtcbiAgICAgICAgICAgICAgICBsaW5lcyAgID0gY29udGVudC5zcGxpdCgnXFxuJyk7XG4gICAgICAgICAgICAgICAgbGFzdCAgICA9IGxpbmVzLmxlbmd0aCAtIDE7XG5cbiAgICAgICAgICAgICAgICBpZiAoIGxhc3QgPiAwICkge1xuICAgICAgICAgICAgICAgICAgICBuZXh0TGluZSAgID0gbGluZSArIGxhc3Q7XG4gICAgICAgICAgICAgICAgICAgIG5leHRPZmZzZXQgPSBuZXh0IC0gbGluZXNbbGFzdF0ubGVuZ3RoO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIG5leHRMaW5lICAgPSBsaW5lO1xuICAgICAgICAgICAgICAgICAgICBuZXh0T2Zmc2V0ID0gb2Zmc2V0O1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnY29tbWVudCcsIGNvbnRlbnQsXG4gICAgICAgICAgICAgICAgICAgIGxpbmUsICAgICBwb3MgIC0gb2Zmc2V0LFxuICAgICAgICAgICAgICAgICAgICBuZXh0TGluZSwgbmV4dCAtIG5leHRPZmZzZXRcbiAgICAgICAgICAgICAgICBdO1xuXG4gICAgICAgICAgICAgICAgb2Zmc2V0ID0gbmV4dE9mZnNldDtcbiAgICAgICAgICAgICAgICBsaW5lICAgPSBuZXh0TGluZTtcbiAgICAgICAgICAgICAgICBwb3MgICAgPSBuZXh0O1xuXG4gICAgICAgICAgICAvLyBTQ1NTIFBBVENIIHtcbiAgICAgICAgICAgIH0gZWxzZSBpZiAoIGNvZGUgPT09IFNMQVNIICYmIG4gPT09IFNMQVNIICkge1xuICAgICAgICAgICAgICAgIFJFX05FV19MSU5FLmxhc3RJbmRleCA9IHBvcyArIDE7XG4gICAgICAgICAgICAgICAgUkVfTkVXX0xJTkUudGVzdChjc3MpO1xuICAgICAgICAgICAgICAgIGlmICggUkVfTkVXX0xJTkUubGFzdEluZGV4ID09PSAwICkge1xuICAgICAgICAgICAgICAgICAgICBuZXh0ID0gY3NzLmxlbmd0aCAtIDE7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgbmV4dCA9IFJFX05FV19MSU5FLmxhc3RJbmRleCAtIDI7XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgY29udGVudCA9IGNzcy5zbGljZShwb3MsIG5leHQgKyAxKTtcblxuICAgICAgICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnY29tbWVudCcsIGNvbnRlbnQsXG4gICAgICAgICAgICAgICAgICAgIGxpbmUsIHBvcyAgLSBvZmZzZXQsXG4gICAgICAgICAgICAgICAgICAgIGxpbmUsIG5leHQgLSBvZmZzZXQsXG4gICAgICAgICAgICAgICAgICAgICdpbmxpbmUnXG4gICAgICAgICAgICAgICAgXTtcblxuICAgICAgICAgICAgICAgIHBvcyA9IG5leHQ7XG4gICAgICAgICAgICAgICAgLy8gfSBTQ1NTIFBBVENIXG5cbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgUkVfV09SRF9FTkQubGFzdEluZGV4ID0gcG9zICsgMTtcbiAgICAgICAgICAgICAgICBSRV9XT1JEX0VORC50ZXN0KGNzcyk7XG4gICAgICAgICAgICAgICAgaWYgKCBSRV9XT1JEX0VORC5sYXN0SW5kZXggPT09IDAgKSB7XG4gICAgICAgICAgICAgICAgICAgIG5leHQgPSBjc3MubGVuZ3RoIC0gMTtcbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICBuZXh0ID0gUkVfV09SRF9FTkQubGFzdEluZGV4IC0gMjtcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICBjdXJyZW50VG9rZW4gPSBbJ3dvcmQnLCBjc3Muc2xpY2UocG9zLCBuZXh0ICsgMSksXG4gICAgICAgICAgICAgICAgICAgIGxpbmUsIHBvcyAgLSBvZmZzZXQsXG4gICAgICAgICAgICAgICAgICAgIGxpbmUsIG5leHQgLSBvZmZzZXRcbiAgICAgICAgICAgICAgICBdO1xuXG4gICAgICAgICAgICAgICAgYnVmZmVyLnB1c2goY3VycmVudFRva2VuKTtcblxuICAgICAgICAgICAgICAgIHBvcyA9IG5leHQ7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICB9XG5cbiAgICAgICAgcG9zKys7XG4gICAgICAgIHJldHVybiBjdXJyZW50VG9rZW47XG4gICAgfVxuXG4gICAgZnVuY3Rpb24gYmFjayh0b2tlbikge1xuICAgICAgICByZXR1cm5lZC5wdXNoKHRva2VuKTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgICBiYWNrLFxuICAgICAgICBuZXh0VG9rZW4sXG4gICAgICAgIGVuZE9mRmlsZVxuICAgIH07XG59XG4iXX0=
