"use strict";

// start: 准备阶段
// load: 载入文件
// assets: 代码生成
// uglify: 压缩
// emit: 写文件
// 阶段是一个区间，而webpack hooks只能在某个时间点记录时间
// 因此，start阶段表示，compiler.compile到compiler.compilation的时间，以下类似。
var STEPS = {
  // 开始
  'compiler.compile': null,
  // 准备阶段 结束
  'compiler.compilation': 'start',
  // 载入文件 结束
  'compilation.finishModules': 'load',
  // 代码生成 结束
  'compilation.additionalAssets': 'assets',
  // 代码压缩 结束
  'compilation.afterOptimizeChunkAssets': 'uglify',
  // 写文件 结束
  'compiler.done': 'emit'
}; // webpack新旧版本的Hooks映射，
// 旧版本： compilation.plugin('additional-assets',callback=>{});
// 新版本： compilation.hooks.additionalAssets.tapAsync('随意写的一个名字', callback=>{});

var HOOKS = {
  compile: 'tap',
  compilation: 'tap',
  finishModules: 'tap',
  additionalAssets: 'tapAsync',
  afterOptimizeChunkAssets: 'tap',
  done: 'tap',
  invalid: 'tap'
};
var LOG_HEAD = 'build-statistics-webpack-plugin';
var TRACE_NAME = `${LOG_HEAD}:trace`;
var ERROR_NAME = `${LOG_HEAD}:error`;
module.exports = {
  STEPS,
  HOOKS,
  TRACE_NAME,
  ERROR_NAME
};