import React, { Component } from 'react';
import { Modal, Icon } from 'antd';
import SelectUser from "../SelectUser";
import { systemComDepartGetTreeDepart } from "../../services/api";
import './index.less';

const userdata = [
  {
    "title": "测试二部",
    "key": "395149020382625792",
    "clildren": [
      {
        "title": "测试一部",
        "key": "395241451308449792",
        "clildren": null
      }
    ]
  },
  {
    "title": "测试二部",
    "key": "395149020382625792",
    "clildren": [
      {
        "title": "测试一部",
        "key": "395241451308449792",
        "clildren": null
      }
    ]
  },
  {
    "title": "测试一部",
    "key": "395241451308449792",
    "clildren": []
  }
];
class DepartmentPopSelect extends Component {
  constructor(props, context) {
    super(props, context);
    this.generatorAllUser(userdata);
    this.state = {
      checkedkeys: this.props.value || [],
      visible: this.props.visible,
      userdata: []
    };

  }


  componentDidMount() {
    systemComDepartGetTreeDepart().then((data) => {
      this.setState({ userdata: data.data });
    }, (err) => {
      console.log(err, "systemComDepartGetTreeDepart-err");
    });
  }
  componentWillReceiveProps(state) {
    this.setState({ visible: state.visible, checkedkeys: state.value || [] });
  }

  handleCancel = () => {
    this.setState({
      visible: false,
    });
  }

  handleOk = () => {
    this.setState({
      visible: false,
    });
    this.props.onCheck(this.state.checkedkeys);
  }

  showModal = (e) => {
    const targetClass = e.target.className;
    if (targetClass === "ant-select-selection__rendered" || targetClass === "ant-select-selection__placeholder" ||
      targetClass.indexOf("ant-select-selection--multiple") !== -1
    ) {
      this.setState({ visible: true });
    }

  }

  allUser = []
  /* 遍历所有人员用做搜索 */
  generatorAllUser = (data) => {
    data.forEach((val) => {
      if (val.treeType === "2") {
        this.allUser.push(val);
      }
      if (val.treeType === "1") {
        if (val.clildren) {
          this.generatorAllUser(val.clildren);
        }
      }
    });
  }

  render() {
    const selectedList = () => {
      return this.state.checkedkeys.map((val) => {
        let param = "";
        this.allUser.forEach((val1) => {
          if (val === val1.key) {
            param = val1;
          }
        });

        if (param) {
          return (
            <div key={param.key} className="PartmentSelect-list-item">
              <Icon type="user" /> {param.title}<Icon
                onClick={() => {
                  const checkedkeys = this.state.checkedkeys.slice();
                  const newcheckedkeys = checkedkeys.filter((value) => {
                    return param.key !== value;
                  });
                  this.setState({ checkedkeys: newcheckedkeys });
                }}
                type="close-circle-o"
              />
            </div>
          );
        } else {
          return "";
        }
      });
    };


    return (
      <div onClick={this.showModal}>
        <Modal
          title={this.props.title || "选择人员"}
          wrapClassName="PartmentSelect"
          closable={false}
          visible={this.state.visible}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          width={700}
        >
          <div className="PartmentSelect-title"><h2>选择：</h2><h2>已选：</h2></div>
          <div className="PartmentSelect-box">
            <SelectUser value={this.state.checkedkeys || []} type="checkbox" data={this.state.userdata} onSelect={(checkedkeys) => { this.setState({ checkedkeys }); }} />
            <div className="PartmentSelect-wrap PartmentSelect-wrap-selected">
              {selectedList()}
            </div>
          </div>
        </Modal>
      </div>
    );
  }
}

export default DepartmentPopSelect;
