package com.bcxin.flink.cdc.kafka.source.task.cdcs.dynamic;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.sink.config.MongoWriteOptions;
import org.apache.flink.connector.mongodb.sink.writer.serializer.MongoSerializationSchema;

import static org.apache.flink.util.Preconditions.checkNotNull;

public class DynamicDbCollectionMongoSink<IN> implements Sink<IN> {

    private static final long serialVersionUID = 1L;

    private final MongoConnectionOptions connectionOptions;
    private final MongoWriteOptions writeOptions;
    private final MongoSerializationSchema<IN> serializationSchema;

    DynamicDbCollectionMongoSink(
            MongoConnectionOptions connectionOptions,
            MongoWriteOptions writeOptions,
            MongoSerializationSchema<IN> serializationSchema) {
        this.connectionOptions = checkNotNull(connectionOptions);
        this.writeOptions = checkNotNull(writeOptions);
        this.serializationSchema = checkNotNull(serializationSchema);
        ClosureCleaner.clean(
                serializationSchema, ExecutionConfig.ClosureCleanerLevel.RECURSIVE, true);
    }

    public static <IN> DynamicDbCollectionMongoSinkBuilder<IN> builder() {
        return new DynamicDbCollectionMongoSinkBuilder<>();
    }

    @Override
    public SinkWriter<IN> createWriter(InitContext context) {
        return new DynamicDbCollectionMongoWriter<>(
                connectionOptions,
                writeOptions,
                writeOptions.getDeliveryGuarantee() == DeliveryGuarantee.AT_LEAST_ONCE,
                context,
                serializationSchema);
    }
}
