package com.bcxin.flink.cdc.kafka.source.task.cdcs;

import com.mongodb.client.model.InsertOneModel;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.mongodb.sink.MongoSink;
import org.bson.BsonDocument;

public class MongoSinkBuilder {
    public static MongoSink<String> build(String url,String db, String collection) {
        MongoSink<String> sink = MongoSink.<String>builder()
                //.setUri("mongodb://user:password@127.0.0.1:27017")
                .setUri(url)
                .setDatabase(db)
                .setCollection(collection)
                .setBatchSize(1000)
                .setBatchIntervalMs(1000)
                .setMaxRetries(3)
                .setDeliveryGuarantee(DeliveryGuarantee.AT_LEAST_ONCE)
                .setSerializationSchema(
                        (input, context) -> new InsertOneModel<>(BsonDocument.parse(input)))
                .build();

        return sink;
    }
}
