package com.bcxin.flink.cdc.kafka.source.task.cdcs;

import com.alibaba.fastjson.annotation.JSONField;
import com.bcxin.event.core.KafkaConstants;
import com.bcxin.event.core.exceptions.BadEventException;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class CdcSourceMeta implements Serializable {

    private String op;

    /**
     * 变更前
     */
    private CoreData before;
    /**
     * 变更后
     */
    private CoreData after;

    private SourceData source;

    private String superviseDepartId;

    public String getServerId() {
        if (this.getSource() == null) {
            return null;
        }

        return this.getSource().getServerId();
    }

    public String getTopicKey1() {
        if (this.getSource() == null) {
            return null;
        }

        return String.format(
                "streaming.topic.data.%s.%s",
                this.getDbName(),
                this.getTableName()
        );
    }

    public String getDomainId()
    {
        if("tenant_organizations".equalsIgnoreCase(this.getTableName()) || "tenant_companies".equalsIgnoreCase(this.getTableName())) {
            return this.getId();
        }

        String dataId = null;
        if (this.getBefore() != null) {
            dataId = this.getBefore().getDomainId();

            if (!org.springframework.util.StringUtils.hasLength(dataId)) {
                dataId = this.getBefore().getOrganizationId();
            }
        }

        if (StringUtils.isEmpty(dataId) && this.getAfter() != null) {
            dataId = this.getAfter().getDomainId();

            if (!org.springframework.util.StringUtils.hasLength(dataId)) {
                dataId = this.getAfter().getOrganizationId();
            }
        }

        return dataId;
    }

    public String getId() {
        String dataId = null;
        if (this.getBefore() != null) {
            dataId = this.getBefore().getPrimaryKeyValue();
        }

        if (StringUtils.isEmpty(dataId) && this.getAfter() != null) {
            dataId = this.getAfter().getPrimaryKeyValue();
        }

        return dataId;
    }

    public String getPartitionKey() {
        String dataId = null;
        if (this.getBefore() != null) {
            dataId = this.getBefore().getPartitionKey();
        }

        if (StringUtils.isEmpty(dataId) && this.getAfter() != null) {
            dataId = this.getAfter().getPartitionKey();
        }

        return dataId;
    }

    public String getDbName() {
        if (this.getSource() == null) {
            return null;
        }

        return this.getSource().getDbName();
    }

    public String getTableName() {
        if (this.getSource() == null) {
            return null;
        }

        return this.getSource().getTableName();
    }


    public String getFile() {
        if (this.getSource() == null) {
            return null;
        }

        return this.getSource().getFile();
    }

    public int getPos() {
        if (this.getSource() == null) {
            return 0;
        }

        return this.getSource().getPos();
    }

    /**
     * 默认设置10个分区进行消费
     *
     * @return
     */
    public int getPartition() {
        if (this.getId() == null) {
            return 0;
        }

        int partition_Count = KafkaConstants.DEFAULT_PARTITION_COUNT;

        int partition =
                Math.abs(this.getPartitionKey().hashCode()) % partition_Count;

        if (partition >= partition_Count) {
            throw new BadEventException(String.format("无效分区数据:%s", partition));
        }

        return partition;
    }

    @Data
    public static class CoreData {
        @JSONField(name = "pk_id")
        private String pkId;
        @JSONField(name = "pkId")
        private String pkId2;

        private String id;

        @JSONField(name = "organization_id")
        private String organizationId;
        @JSONField(name = "DOMAINID")
        private String domainId;
        /**
         * 针对职员数据
         */
        @JSONField(name = "tenant_user_id")
        private String tenantUserId;

        public String getPartitionKey() {
            if (!StringUtils.isEmpty(this.getOrganizationId()) &&
                    this.getOrganizationId().trim().length() > 1) {
                return this.getOrganizationId();
            }
            if (!StringUtils.isEmpty(this.getDomainId()) &&
                    this.getDomainId().trim().length() > 1) {
                return this.getDomainId();
            }

            if (!StringUtils.isEmpty(this.getTenantUserId()) &&
                    this.getTenantUserId().trim().length() > 1) {
                return this.getTenantUserId();
            }

            return this.getId();
        }

        public String getPrimaryKeyValue() {
            if (org.springframework.util.StringUtils.hasLength(this.getPkId())) {
                return this.getPkId();
            }
            if (org.springframework.util.StringUtils.hasLength(this.getPkId2())) {
                return this.getPkId2();
            }

            if (org.springframework.util.StringUtils.hasLength(this.getId())) {
                return this.getId();
            }

            return null;
        }
    }

    @Data
    public static class SourceData {
        @JSONField(name = "db")
        private String dbName;
        private String connector;
        private String name;
        @JSONField(name = "table")
        private String tableName;
        @JSONField(name = "server_id")
        private String serverId;

        @JSONField(name = "file")
        private String file;
        @JSONField(name = "pos")
        private int pos;
    }
}
