package com.bcxin.flink.cdc.kafka.source.task.cdcs;

import com.bcxin.event.core.exceptions.BadEventException;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class BinlogCdcValue implements Serializable {
    private String id;
    private String db;
    private String table;

    private String value;
    private Date lastSyncTime;
    private Map<String, ?> sourceMeta;
    private BinlogOffsetValue binlogOffsetValue;

    public static BinlogCdcValue create(String id, String db, String table, String value, Date lastSyncTime) {
        BinlogCdcValue cdcValue = new BinlogCdcValue();
        cdcValue.setId(id);
        cdcValue.setValue(value);
        cdcValue.setDb(db);
        cdcValue.setTable(table);
        cdcValue.setLastSyncTime(lastSyncTime);

        return cdcValue;
    }

    public void changeBinlog(Map<String, ?> sourceMeta) {
        if (CollectionUtils.isEmpty(sourceMeta)) {
            throw new BadEventException("无效的binlog元数据信息");
        }

        this.setSourceMeta(sourceMeta);

        Object file = sourceMeta.get("file");
        if (file == null) {
            throw new BadEventException("找不到binlog文件的file信息:" +
                    sourceMeta.keySet().stream().map(ix -> String.format("%s=%s", ix, sourceMeta.get(ix))).collect(Collectors.joining(";"))
            );
        }

        Object pos = sourceMeta.get("pos");
        if (pos == null) {
            throw new BadEventException("找不到binlog文件的pos信息:" +
                    sourceMeta.keySet().stream().map(ix -> String.format("%s=%s", ix, sourceMeta.get(ix))).collect(Collectors.joining(";"))
            );
        }

        Object gtIds = sourceMeta.get("gtids");

        BinlogOffsetValue offsetValue =
                BinlogOffsetValue.create(String.valueOf(file), (long) pos, gtIds == null ? null : String.valueOf(gtIds));
        offsetValue.changeNote(String.format("%s.%s=%s", this.getDb(), this.getTable(), this.getId()));

        this.setBinlogOffsetValue(offsetValue);
    }

    public String getBinlogFile() {
        if (this.getBinlogOffsetValue() == null) {
            throw new BadEventException("找不到binlog的配置信息");
        }

        return this.getBinlogOffsetValue().getFile();
    }

    public String getFullTable() {
        return String.format("%s.%s", this.getDb(), this.getTable());
    }
}
