package com.bcxin.flink.cdc.kafka.source.task;

import com.bcxin.event.core.SuperviseDepartLevelDTO;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.CdcDatabaseSourceProperty;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.HttpRegionSinkProperty;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.KafkaConfigProperty;
import com.bcxin.flink.streaming.cores.CoreJobContext;
import com.bcxin.flink.streaming.cores.TableConstant;
import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import lombok.Getter;
import org.apache.commons.collections.MapUtils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Getter
public class JobContext implements CoreJobContext {
    private final String name;
    private final Map<String, String> flinkConfig;
    private final Collection<HttpRegionSinkProperty> httpRegionSinkProperties;

    private JobContext(
            String name,
            Collection<HttpRegionSinkProperty> httpRegionSinkProperties,
            CdcDatabaseSourceProperty databaseProperty,
            CheckpointConfigProperty configProperty,
            KafkaConfigProperty kafkaConfigProperty) {
        this.name = name;
        this.httpRegionSinkProperties = httpRegionSinkProperties;
        this.flinkConfig = new HashMap<>();
        this.configProperty = configProperty;
        this.kafkaConfigProperty = kafkaConfigProperty;
        this.databaseProperty = databaseProperty;
    }

    private final CheckpointConfigProperty configProperty;

    private final KafkaConfigProperty kafkaConfigProperty;

    private final CdcDatabaseSourceProperty databaseProperty;

    public void assign(HashMap<String, String> optionConfig) {
        if (MapUtils.isEmpty(optionConfig)) {
            return;
        }

        for (String key : optionConfig.keySet()) {
            this.getFlinkConfig().put(key, optionConfig.get(key));
        }
    }

    public boolean isSkipBinlogRedisCalculated() {
        if (true) {
            return true;
        }

        if (System.getProperty(TableConstant.PARAM_BINLOG_SKIP_REDIS_CALCULATE) == null) {
            return false;
        }

        return TableConstant.PARAM_BINLOG_SKIP_REDIS_CALCULATE_VALUE.equalsIgnoreCase(System.getProperty(TableConstant.PARAM_BINLOG_SKIP_REDIS_CALCULATE));
    }

    private static JobContext _instance;

    public static void init(
            String name,
            Collection<HttpRegionSinkProperty> httpRegionSinkProperties,
            CdcDatabaseSourceProperty databaseProperty,
            CheckpointConfigProperty configProperty,
            KafkaConfigProperty kafkaConfigProperty) {
        if (_instance == null) {
            synchronized (JobContext.class) {
                if (_instance == null) {
                    _instance = new JobContext(name, httpRegionSinkProperties, databaseProperty,
                            configProperty,
                            kafkaConfigProperty);
                }
            }
        }
    }


    public static void initHttpSink(            String name,
                                                Collection<HttpRegionSinkProperty> httpRegionSinkProperties,
                                                CdcDatabaseSourceProperty databaseProperty,
                                                CheckpointConfigProperty configProperty) {
        JobContext.init(name, httpRegionSinkProperties, databaseProperty, configProperty, null);
    }

    public static void initKafkaSink(            String name,
                                                CdcDatabaseSourceProperty databaseProperty,
                                                CheckpointConfigProperty configProperty,
                                                 KafkaConfigProperty kafkaConfigProperty) {
        JobContext.init(name, null, databaseProperty, configProperty, kafkaConfigProperty);
    }


    public static JobContext getInstance() {

        if (_instance == null) {
            throw new IllegalArgumentException("未对JobContext进行初始化操作-V3");
        }

        return _instance;
    }

    public String getEnv() {
        return System.getProperty(TableConstant.PARAM_ENV);
    }

    private static ThreadLocal<ThreadContext> threadLocal = new InheritableThreadLocal<>();
    public static ThreadContext getCurrentContext() {
        ThreadContext context = threadLocal.get();
        if (context == null) {
            context = new ThreadContext();
            threadLocal.set(context);
        }

        return context;
    }
}
