package com.bcxin.flink.cdc.kafka.source.task;

import com.bcxin.event.core.KafkaConstants;
import org.bson.BsonInt32;
import org.bson.BsonNull;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FlinkConstants {
    private static final Logger logger = LoggerFactory.getLogger(FlinkConstants.class);
    public final static Collection<String> DATETIME_FIELD_NAMES = Stream.of("LASTMODIFIED", "CREATED", "TIME", "DATE", "FZRQ").collect(Collectors.toList());

    public static Object formatValue(String nodeKey, Object nodeValue) {
        if (nodeValue == null || nodeValue instanceof BsonNull) {
            return null;
        }

        if(nodeValue instanceof BsonString ) {
            String bsStr = ((BsonString) nodeValue).getValue();

            if (isDateTimeField(nodeKey) && (bsStr.contains("0000-00-00") || bsStr.contains("9999-"))) {
                return null;
            }
        }

        if (nodeValue instanceof BsonNumber) {
            try {
                if (isDateTimeField(nodeKey)) {
                    return (new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date(getTimeValue(nodeKey, ((BsonNumber) nodeValue).longValue()))));
                } else {
                    return nodeValue;
                }
            } catch (Exception ex) {
                logger.error("formatValue.key={};value={};转换出错=%s;尝试转为Double", nodeKey, nodeValue, ex);
                ex.printStackTrace();
            }
        }

        return nodeValue;
    }

    private static long getTimeValue(String key, Object value) {
        try {
            return Long.parseLong(String.valueOf(value));
        } catch (Exception ex) {
            logger.error("key={};value={};转换出错=%s;尝试转为Double", key, value, ex);
            return (long) Double.parseDouble(String.valueOf(value));
        }
    }

    public static boolean isDateTimeField(String nodeKey) {
        return FlinkConstants.DATETIME_FIELD_NAMES.stream().anyMatch(ix -> nodeKey.toUpperCase().contains(ix));
    }
}
