package com.bcxin.event.job.domain.commands;

import com.bcxin.event.core.commands.CommandAbstract;
import com.bcxin.event.job.domain.enums.JobType;
import lombok.Getter;

@Getter
public class CreateJobCommand extends CommandAbstract {
    private final String name;
    private final String title;
    private final JobType jobType;
    private final String parameterJson;
    private final String description;
    private final boolean isOnline;

    public CreateJobCommand(String name,String title, boolean isOnline, JobType jobType, String parameterJson, String description) {
        this.name = name;
        this.jobType = jobType;
        this.parameterJson = parameterJson;
        this.description = description;
        this.isOnline = isOnline;
        this.title = title;
    }

    public static CreateJobCommand create(String name,String title, boolean isOnline, JobType jobType, String parameterJson, String description) {
        return new CreateJobCommand(name, title, isOnline, jobType, parameterJson, description);
    }
}
