package com.bcxin.event.job.domain.commands;

import com.bcxin.event.job.domain.enums.JobType;
import lombok.Getter;

@Getter
public class UpdateJobCommand extends CreateJobCommand {
    private final int id;


    public UpdateJobCommand(int id, String name, String title, boolean isOnline, JobType jobType, String parameterJson, String description) {
        super(name, title, isOnline, jobType, parameterJson, description);
        this.id = id;
    }

    public static UpdateJobCommand create(int id, String name, String title, boolean isOnline, JobType jobType, String parameterJson, String description) {
        return new UpdateJobCommand(id, name, title, isOnline, jobType, parameterJson, description);
    }
}
