package com.bcxin.event.job.domain.repository.impls;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.event.core.EntityCollection;
import com.bcxin.event.core.exceptions.ConflictEventException;
import com.bcxin.event.core.exceptions.NoFoundEventException;
import com.bcxin.event.job.domain.entities.JobEntity;
import com.bcxin.event.job.domain.repositories.JobRepository;
import com.bcxin.event.job.domain.repositories.criterias.JobMetaCriteria;
import com.bcxin.event.job.domain.repository.mapper.JobMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Repository
public class JobRepositoryImpl implements JobRepository {
    private final JobMapper jobMapper;

    public JobRepositoryImpl(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }

    @Override
    public void create(JobEntity entity) {
        try {
            this.jobMapper.insert(entity);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_job_name")) {
                throw new ConflictEventException("该名称的Job已经存在");
            }

            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    public void update(JobEntity entity) {
        try {
            this.jobMapper.updateById(entity);
        } catch (Exception ex) {
            if (ex.toString().contains("unique_job_name")) {
                throw new ConflictEventException("该名称的Job已经存在");
            }

            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    public void delete(Integer id) {

        int count = this.jobMapper.deleteById(id);
        if (count == 0) {
            throw new NoFoundEventException(String.format("找不到该数据(%s)", id));
        }
    }

    @Override
    public JobEntity getById(Integer id) {
        return this.jobMapper.selectById(id);
    }

    @Override
    public Collection<JobEntity> findAll() {
        LambdaQueryWrapper<JobEntity> queryWrapper = new LambdaQueryWrapper<JobEntity>();
        queryWrapper.eq(JobEntity::isOnline, true);

        return this.jobMapper.selectList(queryWrapper);
    }

    @Override
    public JobEntity findByName(String name) {
        LambdaQueryWrapper<JobEntity> queryWrapper = new LambdaQueryWrapper<JobEntity>();
        queryWrapper.eq(JobEntity::getName, name);

        return this.jobMapper.selectOne(queryWrapper);
    }

    @Override
    public EntityCollection<JobEntity> search(JobMetaCriteria criteria) {
        LambdaQueryWrapper<JobEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JobEntity::isDeleted,false);

        if (StringUtils.hasLength(criteria.getKeyword())) {
            queryWrapper.and(ic ->
                    ic.or(cc -> cc.like(JobEntity::getTitle, criteria.getKeyword()))
                            .or(ix -> ix.like(JobEntity::getDescription, criteria.getKeyword()))
                            .or(ix -> ix.like(JobEntity::getName, criteria.getKeyword()))
            );
        }

        IPage<JobEntity> page = new Page<>(criteria.getPageIndex(), criteria.getPageSize());
        IPage<JobEntity> data = this.jobMapper.selectPage(page, queryWrapper);

        return EntityCollection.create(data.getRecords(), criteria.getPageSize(), data.getTotal());
    }
}
