package com.bcxin.event.job.domain.repository.impls;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bcxin.event.core.exceptions.ConflictEventException;
import com.bcxin.event.job.domain.entities.JdbcDefinitionEntity;
import com.bcxin.event.job.domain.repositories.JdbcDefinitionRepository;
import com.bcxin.event.job.domain.repository.mapper.JdbcDefinitionMapper;
import org.springframework.stereotype.Repository;

import java.util.Collection;

@Repository
public class JdbcDefinitionRepositoryImpl implements JdbcDefinitionRepository {
    private final JdbcDefinitionMapper jdbcDefinitionMapper;

    public JdbcDefinitionRepositoryImpl(JdbcDefinitionMapper jdbcDefinitionMapper) {
        this.jdbcDefinitionMapper = jdbcDefinitionMapper;
    }


    @Override
    public void create(JdbcDefinitionEntity entity) {
        try {
            this.jdbcDefinitionMapper.insert(entity);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_jdbc_name")) {
                throw new ConflictEventException("该名称的Jdbc配置已经存在");
            }

            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    public void update(JdbcDefinitionEntity entity) {
        try {
            this.jdbcDefinitionMapper.updateById(entity);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_jdbc_name")) {
                throw new ConflictEventException("该名称的Jdbc配置已经存在");
            }

            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    public void delete(Long id) {

    }

    @Override
    public JdbcDefinitionEntity getById(Long id) {
        return this.jdbcDefinitionMapper.selectById(id);
    }

    @Override
    public Collection<JdbcDefinitionEntity> findAll() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();

        return this.jdbcDefinitionMapper.selectList(wrapper);
    }

    @Override
    public Collection<JdbcDefinitionEntity> getAllByIds(Collection<Long> ids) {
        LambdaQueryWrapper<JdbcDefinitionEntity> wrapper = new LambdaQueryWrapper<JdbcDefinitionEntity>();
        wrapper.in( JdbcDefinitionEntity::getId, ids);

        return this.jdbcDefinitionMapper.selectList(wrapper);
    }
}
