/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.domain.services.impls;

import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.exceptions.ConflictEventException;
import com.bcxin.event.core.exceptions.NoFoundEventException;
import com.bcxin.event.job.domain.commands.CreateJobCommand;
import com.bcxin.event.job.domain.commands.DeleteJobCommand;
import com.bcxin.event.job.domain.commands.DeleteLogicJobCommand;
import com.bcxin.event.job.domain.commands.UpdateJobCommand;
import com.bcxin.event.job.domain.entities.JobEntity;
import com.bcxin.event.job.domain.repositories.JdbcDefinitionRepository;
import com.bcxin.event.job.domain.repositories.JobRepository;
import com.bcxin.event.job.domain.services.JobService;

public class JobServiceImpl
implements JobService {
    private final JobRepository jobRepository;
    private final JsonProvider jsonProvider;
    private final JdbcDefinitionRepository jdbcDefinitionRepository;

    public JobServiceImpl(JobRepository jobRepository, JsonProvider jsonProvider, JdbcDefinitionRepository jdbcDefinitionRepository) {
        this.jobRepository = jobRepository;
        this.jsonProvider = jsonProvider;
        this.jdbcDefinitionRepository = jdbcDefinitionRepository;
    }

    @Override
    public void dispatch(CreateJobCommand command) {
        JobEntity job = JobEntity.create(command.getName(), command.getTitle(), command.getJobType(), command.getParameterJson(), command.getDescription(), this.jsonProvider, this.jdbcDefinitionRepository);
        try {
            this.jobRepository.create(job);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_job_name")) {
                throw new ConflictEventException("\u8be5\u540d\u79f0\u7684Job\u5df2\u7ecf\u5b58\u5728");
            }
            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    public void dispatch(UpdateJobCommand command) {
        JobEntity job = (JobEntity)this.jobRepository.getById(command.getId());
        if (job == null) {
            throw new NoFoundEventException();
        }
        job.change(command.getName(), command.getTitle(), command.getJobType(), command.getParameterJson(), command.getDescription(), this.jsonProvider, this.jdbcDefinitionRepository);
        try {
            this.jobRepository.update(job);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_job_name")) {
                throw new ConflictEventException("\u8be5\u540d\u79f0\u7684Job\u5df2\u7ecf\u5b58\u5728");
            }
            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    public void dispatch(DeleteJobCommand command) {
        this.jobRepository.delete(command.getId());
    }

    @Override
    public void dispatch(DeleteLogicJobCommand command) {
        JobEntity job = (JobEntity)this.jobRepository.getById(command.getId());
        if (job == null) {
            throw new NoFoundEventException();
        }
        job.markDeleted();
        try {
            this.jobRepository.update(job);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_job_name")) {
                throw new ConflictEventException("\u8be5\u540d\u79f0\u7684Job\u5df2\u7ecf\u5b58\u5728");
            }
            ex.printStackTrace();
            throw ex;
        }
    }
}

