/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core.jdbc;

import com.bcxin.event.core.exceptions.BadEventException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.namedparam.ParsedSql;

public class ParseSqlParameter
implements Serializable {
    private final ParsedSql parsedSql;
    private final PreparedStatementCreatorFactory pscf;
    private List<String> _parameterNames;
    private List<int[]> _parameterIndexes;
    private Integer _totalParameterCount;

    public ParseSqlParameter(ParsedSql parsedSql, PreparedStatementCreatorFactory pscf) {
        this.parsedSql = parsedSql;
        this.pscf = pscf;
    }

    public static ParseSqlParameter create(ParsedSql parsedSql, PreparedStatementCreatorFactory pscf) {
        return new ParseSqlParameter(parsedSql, pscf);
    }

    public List<String> getParameterNames() {
        if (this._parameterNames == null) {
            this._parameterNames = (List)this.getFieldValue(this.getParsedSql(), "parameterNames");
        }
        return this._parameterNames;
    }

    public List<int[]> getParameterIndexes() {
        if (this._parameterIndexes == null) {
            this._parameterIndexes = (List)this.getFieldValue(this.getParsedSql(), "parameterIndexes");
        }
        return this._parameterIndexes;
    }

    private Integer getTotalParameterCount() {
        if (this._totalParameterCount == null) {
            this._totalParameterCount = (int)((Integer)this.getFieldValue(this.getParsedSql(), "totalParameterCount"));
        }
        return this._totalParameterCount;
    }

    private Object getFieldValue(Object value, String fieldName) {
        if (value == null) {
            return null;
        }
        try {
            Class<?> tClass = value.getClass();
            Field field = tClass.getDeclaredField(fieldName);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            return field.get(value);
        }
        catch (Exception ex) {
            throw new BadEventException(ex);
        }
    }

    public ParsedSql getParsedSql() {
        return this.parsedSql;
    }

    public PreparedStatementCreatorFactory getPscf() {
        return this.pscf;
    }

    private List<String> get_parameterNames() {
        return this._parameterNames;
    }

    private List<int[]> get_parameterIndexes() {
        return this._parameterIndexes;
    }

    private Integer get_totalParameterCount() {
        return this._totalParameterCount;
    }
}

