/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.streaming.cores.utils;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.flink.streaming.cores.dtos.DebeziumJsonNodeDto;
import com.bcxin.flink.streaming.cores.utils.JsonNodeUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumJsonNodeDtoUtils {
    private static final Logger logger = LoggerFactory.getLogger(DebeziumJsonNodeDtoUtils.class);

    public static DebeziumJsonNodeDto translate(JsonNode ix, String pkName) {
        String op = ix.get("op").asText();
        JsonNode after = ix.get("after");
        JsonNode idNode = JsonNodeUtils.getSubJsonNodeByName(after, pkName);
        String id = null;
        if (idNode != null) {
            id = idNode.isNumber() ? String.valueOf(idNode.asLong()) : idNode.asText();
        }
        JsonNode before = ix.get("before");
        JsonNode source = ix.get("source");
        Long ts_ms = ix.get("ts_ms").asLong();
        if (StringUtils.isEmpty((CharSequence)id) && "d".equalsIgnoreCase(op) && (idNode = JsonNodeUtils.getSubJsonNodeByName(before, pkName)) != null) {
            id = idNode.isNumber() ? String.valueOf(idNode.asLong()) : idNode.asText();
        }
        return DebeziumJsonNodeDto.create(id, op, ts_ms, before, after, source);
    }

    public static Date getLastSyncTimeValue(JSONObject contentNode) {
        if (contentNode == null) {
            throw new BadEventException("Source\u8282\u70b9\u65e0\u6548\u6570\u636e;");
        }
        JSONObject dataNode = contentNode.getJSONObject("after");
        if (dataNode == null) {
            dataNode = contentNode.getJSONObject("before");
        }
        if (dataNode == null) {
            throw new BadEventException("DataNode\u8282\u70b9\u65e0\u6548\u6570\u636e;");
        }
        Optional<String> selectedKeyOptional = null;
        selectedKeyOptional = dataNode.keySet().stream().filter(ix -> ix.equalsIgnoreCase("LASTMODIFIED")).findFirst();
        if (!selectedKeyOptional.isPresent()) {
            selectedKeyOptional = dataNode.keySet().stream().filter(ix -> ix.equalsIgnoreCase("last_sync_time")).findFirst();
        }
        if (!selectedKeyOptional.isPresent() && !(selectedKeyOptional = dataNode.keySet().stream().filter(ix -> ix.equalsIgnoreCase("last_updated_time")).findFirst()).isPresent()) {
            selectedKeyOptional = dataNode.keySet().stream().filter(ix -> ix.toLowerCase().replace("_", "").contains("updatedtime")).findFirst();
        }
        if (!selectedKeyOptional.isPresent()) {
            selectedKeyOptional = dataNode.keySet().stream().filter(ix -> ix.replace("_", "").equalsIgnoreCase("createdtime")).findFirst();
        }
        if (!selectedKeyOptional.isPresent()) {
            JSONObject sourceDataNode = contentNode.getJSONObject("source");
            selectedKeyOptional = sourceDataNode.keySet().stream().filter(ix -> ix.replace("_", "").equalsIgnoreCase("tsms")).findFirst();
            if (selectedKeyOptional.isPresent()) {
                try {
                    return new Date(sourceDataNode.getLong(selectedKeyOptional.get()));
                }
                catch (Exception ex) {
                    logger.info("\u83b7\u53d6\u65f6\u95f4\u8282\u70b9(\u5c5e\u6027={};value={})\u4fe1\u606f\u53d1\u751f\u5f02\u5e38:{}", new Object[]{selectedKeyOptional.get(), sourceDataNode.get((Object)selectedKeyOptional.get()), ex});
                }
            }
        } else {
            Long value = dataNode.getLong(selectedKeyOptional.get());
            if (value != null) {
                try {
                    return new Date(value);
                }
                catch (Exception ex) {
                    logger.info("\u83b7\u53d6\u65f6\u95f4\u8282\u70b9(\u5c5e\u6027={};sourceDataNodeValue={})\u4fe1\u606f\u53d1\u751f\u5f02\u5e38:{}; ", new Object[]{selectedKeyOptional.get(), dataNode.get((Object)selectedKeyOptional.get()), ex});
                }
            }
        }
        return new Date();
    }
}

