/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core.utils;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.FlinkConstants;
import com.bcxin.event.core.utils.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DebeziumUtil {
    public static final String META_TABLE_NAME = "table";
    public static final String META_DB_NAME = "db";
    public static final String SYNC_DATE_TIME = "cdc_sync_time";
    public static final String META_ROW_DOMAIN_ID_NAME = "domainid";
    public static final String META_ROW_ID_NAME = "id";
    public static final String META_ROW_LASTMODIFIED_NAME = "lastmodified";

    public static Map<String, String> getCleanFlatMapResult(JSONObject data) {
        HashMap<String, String> flatMap = new HashMap<String, String>();
        JSONObject sourceMap = data.getJSONObject("source");
        for (String key : sourceMap.keySet()) {
            if (sourceMap.get((Object)key) == null) continue;
            DebeziumUtil.putValue(flatMap, String.format("source.%s", key), String.valueOf(sourceMap.get((Object)key)));
        }
        String tableName = (String)sourceMap.get((Object)META_TABLE_NAME);
        String dbName = (String)sourceMap.get((Object)META_DB_NAME);
        Object domainId = null;
        Object id = null;
        Object LASTMODIFIED = null;
        if (data.getJSONObject("before") != null) {
            JSONObject before = data.getJSONObject("before");
            domainId = DebeziumUtil.getValue(before, META_ROW_DOMAIN_ID_NAME);
            id = DebeziumUtil.getValue(before, META_ROW_ID_NAME);
            LASTMODIFIED = DebeziumUtil.getValue(before, META_ROW_LASTMODIFIED_NAME);
            for (String key : before.keySet()) {
                if (before.get((Object)key) == null) continue;
                DebeziumUtil.putValue(flatMap, String.format("before.%s", key), String.valueOf(before.get((Object)key)));
            }
            if (domainId == null) {
                domainId = DebeziumUtil.getValue(before, "organization_id");
            }
        }
        if (data.getJSONObject("after") != null) {
            JSONObject after = data.getJSONObject("after");
            domainId = DebeziumUtil.getValue(after, "domainId");
            id = DebeziumUtil.getValue(after, META_ROW_ID_NAME);
            LASTMODIFIED = DebeziumUtil.getValue(after, "LASTMODIFIED");
            for (String key : after.keySet()) {
                if (after.get((Object)key) == null) continue;
                DebeziumUtil.putValue(flatMap, String.format("after.%s", key), String.valueOf(after.get((Object)key)));
            }
            if (domainId == null) {
                domainId = DebeziumUtil.getValue(after, "organization_id");
            }
        }
        if (domainId != null) {
            DebeziumUtil.putValue(flatMap, META_ROW_DOMAIN_ID_NAME, String.valueOf(domainId));
        }
        if (id != null) {
            DebeziumUtil.putValue(flatMap, META_ROW_ID_NAME, String.valueOf(id));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tableName)) {
            DebeziumUtil.putValue(flatMap, META_TABLE_NAME, tableName);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dbName)) {
            DebeziumUtil.putValue(flatMap, META_DB_NAME, dbName);
        }
        if (LASTMODIFIED != null) {
            DebeziumUtil.putValue(flatMap, META_ROW_LASTMODIFIED_NAME, String.valueOf(LASTMODIFIED));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        DebeziumUtil.putValue(flatMap, SYNC_DATE_TIME, dateFormat.format(Timestamp.from(Instant.now())));
        return flatMap;
    }

    private static Object getValue(JSONObject data, String fieldName) {
        if (data == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fieldName)) {
            return null;
        }
        Optional<String> selectedFieldNameOptional = data.keySet().stream().filter(ix -> ix.equalsIgnoreCase(fieldName)).findFirst();
        if (!selectedFieldNameOptional.isPresent()) {
            return null;
        }
        return data.get((Object)selectedFieldNameOptional.get());
    }

    private static void putValue(Map<String, String> flatMap, String key, String value) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        if (FlinkConstants.isDateTimeField(key)) {
            flatMap.put(key.toLowerCase(), FlinkConstants.formatValue(key, value));
        }
        flatMap.put(key.toLowerCase(), value);
    }

    public static String getMapValue(Map<String, String> data, String key) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)key) || data == null) {
            return null;
        }
        Optional<String> selectedFieldNameOptional = data.keySet().stream().filter(ix -> ix.equalsIgnoreCase(key)).findFirst();
        if (!selectedFieldNameOptional.isPresent()) {
            return null;
        }
        return data.get(selectedFieldNameOptional.get());
    }

    public static Date getDateFromDateType(String dayValue) {
        if (StringUtils.hasAlpha(dayValue)) {
            return null;
        }
        try {
            long valueInMils = 0L;
            valueInMils = dayValue.length() < 8 ? DebeziumUtil.translate2ValueInMils(Long.valueOf(dayValue)) : Long.valueOf(dayValue);
            return new Date(valueInMils);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static long translate2ValueInMils(long valueInDay) {
        return valueInDay * 24L * 60L * 60L * 1000L;
    }
}

