/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core.jdbc;

import com.bcxin.event.core.definitions.JdbcConnectorDefinition;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.core.jdbc.JdbcMetaRepository;
import com.bcxin.event.core.jdbc.JdbcMetaRepositoryImpl;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class JdbcMetaRepositoryBuilder {
    private static final Map<String, JdbcMetaRepository> repositoryMap = new ConcurrentHashMap<String, JdbcMetaRepository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcMetaRepository build(JdbcConnectorDefinition definition) {
        if (definition == null) {
            throw new BadEventException("JdbcConnectorDefinition \u4e0d\u8be5\u4e3anull");
        }
        JdbcMetaRepository repository = repositoryMap.get(definition.getUniqueKey());
        if (repository == null) {
            Map<String, JdbcMetaRepository> map = repositoryMap;
            synchronized (map) {
                if (repository == null) {
                    HikariConfig config = new HikariConfig();
                    config.setJdbcUrl(definition.getUrl());
                    config.setUsername(definition.getUsername());
                    config.setPassword(definition.getPassword());
                    HikariDataSource dataSource = new HikariDataSource(config);
                    repository = new JdbcMetaRepositoryImpl((DataSource)dataSource);
                    repositoryMap.put(definition.getUniqueKey(), repository);
                }
            }
        }
        return repository;
    }
}

