/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.domain.entities;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.event.core.JobExecutorParam;
import com.bcxin.event.core.JobParameterDTO;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.Kafka2JdbcDefinitionWrapperDTO;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.job.domain.entities.JdbcDefinitionEntity;
import com.bcxin.event.job.domain.entities.TableEntityAbstract;
import com.bcxin.event.job.domain.enums.JobType;
import com.bcxin.event.job.domain.repositories.JdbcDefinitionRepository;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@TableName(value="flink_jobs", autoResultMap=true)
public class JobEntity
extends TableEntityAbstract {
    @TableId(value="id", type=IdType.AUTO)
    private Integer id;
    @TableField(insertStrategy=FieldStrategy.NOT_EMPTY, updateStrategy=FieldStrategy.NOT_EMPTY)
    private String name;
    @TableField(insertStrategy=FieldStrategy.NOT_EMPTY, updateStrategy=FieldStrategy.NOT_EMPTY)
    private String title;
    @TableField(value="job_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private JobType jobType;
    @TableField(value="parameter_json", jdbcType=JdbcType.CLOB)
    private String parameterJson;
    private String description;
    @TableField(value="is_online", jdbcType=JdbcType.BOOLEAN, insertStrategy=FieldStrategy.NOT_NULL, updateStrategy=FieldStrategy.NOT_NULL)
    private boolean online;
    @TableField(value="last_updated_time", jdbcType=JdbcType.TIMESTAMP, updateStrategy=FieldStrategy.NOT_NULL)
    private Timestamp lastUpdatedTime;
    @TableField(value="created_time", jdbcType=JdbcType.TIMESTAMP, updateStrategy=FieldStrategy.NOT_NULL)
    private Timestamp createdTime;
    @TableField(value="flink_job_id")
    private String jobId;
    @TableField(value="flink_job_started_time", jdbcType=JdbcType.TIMESTAMP)
    private Timestamp startJobTime;
    @TableField(value="flink_job_started_response", jdbcType=JdbcType.CLOB)
    private String startJobResponse;
    @TableField(value="is_deleted", jdbcType=JdbcType.TIMESTAMP, insertStrategy=FieldStrategy.NOT_NULL, updateStrategy=FieldStrategy.NOT_NULL)
    private boolean deleted;

    public JobParameterDTO getParameter(JsonProvider jsonProvider) {
        if (StringUtils.isEmpty((CharSequence)this.getParameterJson())) {
            return null;
        }
        return (JobParameterDTO)jsonProvider.toObject(JobParameterDTO.class, this.getParameterJson());
    }

    protected JobEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setOnline(true);
        this.setDeleted(false);
    }

    public void change(String name, String title, JobType jobType, String parameterJson, String description, JsonProvider jsonProvider, JdbcDefinitionRepository jdbcDefinitionRepository) {
        this.setName(name);
        this.setTitle(title);
        this.setJobType(jobType);
        JobEntity.validateParameterJson(parameterJson, jsonProvider, jdbcDefinitionRepository);
        this.setParameterJson(parameterJson);
        this.setDescription(description);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void markOnline(boolean isOnline) {
        this.setOnline(isOnline);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void markDeleted() {
        this.setDeleted(true);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setName(String.format("%s-%s-%s", this.getName(), this.getId(), Instant.now()));
    }

    public static JobEntity create(String name, String title, JobType jobType, String parameterJson, String description, JsonProvider jsonProvider, JdbcDefinitionRepository jdbcDefinitionRepository) {
        JobEntity job = new JobEntity();
        job.change(name, title, jobType, parameterJson, description, jsonProvider, jdbcDefinitionRepository);
        return job;
    }

    private static void validateParameterJson(String parameterJson, JsonProvider jsonProvider, JdbcDefinitionRepository jdbcDefinitionRepository) {
        JobExecutorParam jobExecutorParam = (JobExecutorParam)jsonProvider.toObject(JobExecutorParam.class, parameterJson);
        if (jobExecutorParam == null) {
            throw new BadEventException(String.format("\u65e0\u6548\u53c2\u6570:%s", parameterJson));
        }
        Kafka2JdbcDefinitionWrapperDTO Kafka2JdbcDefinitionWrapper = (Kafka2JdbcDefinitionWrapperDTO)jsonProvider.toObject(Kafka2JdbcDefinitionWrapperDTO.class, jobExecutorParam.getParam2());
        if (Kafka2JdbcDefinitionWrapper == null) {
            throw new BadEventException(String.format("\u65e0\u6548Param2\u53c2\u6570:%s", jobExecutorParam.getParam2()));
        }
        Collection kafka2JdbcDefinitions = Kafka2JdbcDefinitionWrapper.getKafka2JdbcDefinitions();
        Collection ids = kafka2JdbcDefinitions.stream().filter(ii -> ii.getJdbcDefinitions() != null).flatMap(ix -> ix.getJdbcDefinitions().stream().map(it -> it.getJdbcId())).distinct().collect(Collectors.toList());
        Collection<JdbcDefinitionEntity> jdbcDefinitions = jdbcDefinitionRepository.getAllByIds(ids);
        Collection notMatchedIds = ids.stream().filter(ix -> !jdbcDefinitions.stream().anyMatch(it -> it.getId().equals(ix))).collect(Collectors.toList());
        if (!notMatchedIds.isEmpty()) {
            throw new BadEventException(String.format("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684jdbcIds=%s", notMatchedIds.stream().map(ix -> String.valueOf(ix)).collect(Collectors.joining(","))));
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public String getParameterJson() {
        return this.parameterJson;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOnline() {
        return this.online;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Timestamp getStartJobTime() {
        return this.startJobTime;
    }

    public String getStartJobResponse() {
        return this.startJobResponse;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected void setId(Integer id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    protected void setParameterJson(String parameterJson) {
        this.parameterJson = parameterJson;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setOnline(boolean online) {
        this.online = online;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setJobId(String jobId) {
        this.jobId = jobId;
    }

    protected void setStartJobTime(Timestamp startJobTime) {
        this.startJobTime = startJobTime;
    }

    protected void setStartJobResponse(String startJobResponse) {
        this.startJobResponse = startJobResponse;
    }

    protected void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}

