/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.core.domain;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.FlinkConstants;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.event.job.core.domain.dtos.BinlogMapDTO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class BinlogMapTranslator
implements Serializable {
    public static BinlogMapDTO translate(JSONObject data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        JSONObject sourceMap = data.getJSONObject("source");
        String db = sourceMap.getString("db");
        String table = sourceMap.getString("table");
        DocumentType documentType = null;
        switch (table) {
            case "tenant_employees": {
                documentType = DocumentType.Employee;
                break;
            }
            case "tenant_departments": {
                documentType = DocumentType.Department;
                break;
            }
            case "tenant_organizations": {
                documentType = DocumentType.Organization;
                break;
            }
            case "tenant_users": {
                documentType = DocumentType.User;
                break;
            }
            case "tenant_user_credentials": {
                documentType = DocumentType.User_Credentials;
                break;
            }
            case "tlk_attendance_site_person_info": {
                documentType = DocumentType.SecurityStationPerson;
                break;
            }
            case "tlk_attendance_site_base_info": {
                documentType = DocumentType.SecurityStation;
                break;
            }
            default: {
                return null;
            }
        }
        JSONObject after = data.getJSONObject("after");
        String id = null;
        String domainId = null;
        HashMap<String, String> flatMap_after = new HashMap<String, String>();
        if (after != null) {
            id = BinlogMapTranslator.getKeyValue(after, "id");
            domainId = BinlogMapTranslator.getKeyValue(after, "domainid");
            for (String key : after.keySet()) {
                if (after.get((Object)key) == null) continue;
                BinlogMapTranslator.putValue(flatMap_after, key, String.valueOf(after.get((Object)key)));
            }
        }
        JSONObject before = data.getJSONObject("before");
        HashMap<String, String> flatMap_before = new HashMap<String, String>();
        if (before != null) {
            if (StringUtils.isEmpty((CharSequence)id)) {
                id = BinlogMapTranslator.getKeyValue(after, "id");
                domainId = BinlogMapTranslator.getKeyValue(after, "domainid");
            }
            for (String key : before.keySet()) {
                if (before.get((Object)key) == null) continue;
                BinlogMapTranslator.putValue(flatMap_before, key, String.valueOf(before.get((Object)key)));
            }
        }
        long ts_ms = data.getLong("ts_ms");
        HashMap<String, String> content = flatMap_after;
        if (content == null || content.isEmpty()) {
            content = flatMap_before;
        }
        return BinlogMapDTO.create(db, table, domainId, id, ts_ms, documentType, content, flatMap_before);
    }

    private static void putValue(Map<String, String> flatMap, String key, String value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        if (FlinkConstants.isDateTimeField((String)key)) {
            flatMap.put(key.toLowerCase(), FlinkConstants.formatValue((String)key, (String)value));
        }
        flatMap.put(key.toLowerCase(), value);
    }

    private static String getKeyValue(JSONObject data, String orgKey) {
        if (data == null || StringUtils.isEmpty((CharSequence)orgKey)) {
            return null;
        }
        Optional<String> mapKeyOptional = data.keySet().stream().filter(ix -> ix.equalsIgnoreCase(orgKey) || "domainid".equalsIgnoreCase(orgKey) && (ix.equalsIgnoreCase(orgKey) || ix.equalsIgnoreCase("organization_id"))).findFirst();
        if (mapKeyOptional.isPresent()) {
            return data.getString(mapKeyOptional.get());
        }
        return null;
    }
}

