import { getCurrentSetting } from "@/api/tenant-user-controller";
// import store from "@/store";

const app = {
  state: {
    settings: {
      title: "",
      logo: "",
    },
    showHeatmap: false,
    version: process.env.PACKAGE_VERSION || "",
  },
  getters: {
    settings: (state) => {
      const url = process.env.NODE_ENV === "production" ? "https://v5qy.baibaodun.cn" : "https://v5qy.te.baibaodun.com.cn";
      return {
        ...state.settings,
        logo: `${url}/obpm${state.settings.logo}`,
      };
    },
    showHeatmap: (state) => state.showHeatmap,
    version: (state) => state.version,
  },
  mutations: {
    SET_APP_SETTING(state, setting) {
      state.settings = { ...state.settings, ...setting };
    },
    TOGGLE_SHOW_HEATMAP(state) {
      state.showHeatmap = !state.showHeatmap;
    },
  },
  actions: {
    getSettings({ commit }) {
      // 获取配置
      return getCurrentSetting().then((setting) => {
        console.log(setting);
        commit("SET_APP_SETTING", { ...{}, ...setting });
        return Promise.resolve(setting);
      });
    },
  },
};

export default app;
