import { createGroup as createGroupTTM } from "@/utils/im-tim";
import { createGroup as createGroupWF } from "@/utils/im-wf";
import { character as characterWF } from "@/utils/im-wf";
import { character as characterTIM } from "@/utils/im-tim";

const client = localStorage.getItem("dispatchClient");

export default {
  createGroup: async function (form) {
    if (client === "tencent") {
      return createGroupTTM(form);
    } else {
      return createGroupWF(form);
    }
  },
  character: async function (info) {
    if (client === "tencent") {
      return characterTIM(info);
    } else {
      return characterWF(info);
    }
  },
};
