import Vue from "vue";
import App from "./App.vue";
import VueRouter from "vue-router";
import router from "./router";
import VueTippy, { TippyComponent } from "vue-tippy";
import VueContext from "vue-context";
import VModal from "vue-js-modal";
import "./global.css";
import "./wfc.css";
import "./assets/fonts/icomoon/style.css";
import store from "./store/index";
import visibility from "vue-visibility-change";
import { getItem } from "./ui/util/storageHelper";
import VueI18n from "vue-i18n";
import Notifications from "vue-notification";
import Alert from "./ui/common/Alert.js";
import Picker from "./ui/common/Picker";
import Forward from "./ui/common/Forward";
import Voip from "./ui/common/Voip";
import VirtualList from "vue-virtual-scroll-list/src";
import xss from "xss";
import ElementUI from "element-ui"; // elementUI
import TIM from "tim-js-sdk/tim-js-friendship";
import "element-ui/lib/theme-chalk/index.css";
import "normalize.css";
import "@/styles/index.scss"; // 公共样式
import "@/api/auth"; // 权限控制
import "@/utils/directive"; // 拖拽弹窗，在需要用到拖拽功能的弹窗标签上加v-dialogDrag
import drag from "@/utils/drag";

Vue.config.productionTip = false;
// init end
Vue.use(VueRouter);

Vue.use(VueTippy);
Vue.component("tippy", TippyComponent);

Vue.use(VueContext);
Vue.component("vue-context", VueContext);
Vue.component("virtual-list", VirtualList);

Vue.use(VModal);

Vue.use(visibility);

Vue.use(VueI18n);
Vue.use(Alert);
Vue.use(Picker);
Vue.use(Forward);
Vue.use(Voip);

const i18n = new VueI18n({
  // 使用localStorage存储语言状态是为了保证页面刷新之后还是保持原来选择的语言状态
  locale: getItem("lang") ? getItem("lang") : "zh-CN", // 定义默认语言为中文
  messages: {
    "zh-CN": require("@/assets/lang/zh-CN.json"),
    "zh-TW": require("@/assets/lang/zh-TW.json"),
    en: require("@/assets/lang/en.json"),
  },
});

Vue.use(Notifications);
Vue.prototype.$eventBus = new Vue();
Vue.prototype.xss = xss;
Vue.prototype.xssOptions = () => {
  let whiteList = xss.getDefaultWhiteList();
  window.__whiteList = whiteList;
  //xss 处理的时候，默认会将 img 便签的class属性去除，导致 emoji 表情显示太大
  //这儿配置保留 img 标签的style、class、src、alt、id 属性
  whiteList.img = ["style", "class", "src", "alt", "id"];
  return {
    whiteList,
  };
};

Vue.prototype.$store = store;
Vue.prototype.TIM = TIM;
Vue.prototype.$bus = new Vue(); // event Bus 用于无关系组件间的通信。

Vue.directive("drag", drag);

Vue.use(ElementUI, {
  size: "medium",
});

new Vue({
  router,
  store,
  i18n,
  render: (h) => h(App),
}).$mount("#app");

// vm.store = WFStore.state;

// window.vm = vm;
