import request from "@/api/request";

//查询各等级的警情案件数
export function getLevelCount(params) {
  return request({
    url: "/policeIncidents/levelCount",
    method: "POST",
    data: params,
  });
}

//查询警情上报信息
export function getPoliceIncidents(params) {
  return request({
    url: "/policeIncidents/search",
    method: "POST",
    data: params,
  });
}

//查询警情上报信息，限定只查询非已处理的上报记录
export function getPoliceIncidentsNeOver(params) {
  return request({
    url: "/policeIncidents/searchNeOver",
    method: "POST",
    data: params,
  });
}

//警情上报详细信息
export function policeIncidentsDetail(id) {
  return request({
    url: "/policeIncidents/" + id,
    method: "GET",
  });
}

//修改警情上报信息为已处理
export function policeIncidentsHandle(id) {
  return request({
    url: "/policeIncidents/" + id,
    method: "PUT",
  });
}
