### 腾讯云实时音视频通话 TRTC CALLING SDK

<font size=4 color="red">**尊敬的开发者，因产品策略调整，该 SDK 不再更新，欢迎使用新的 [tuicall-engine-webrtc](https://www.npmjs.com/package/tuicall-engine-webrtc) SDK。新的 [tuicall-engine-webrtc](https://www.npmjs.com/package/tuicall-engine-webrtc)  SDK 功能更多，稳定性更好。**</font>

#### 接入方式
> 从v0.6.0起，需要手动安装依赖 [trtc-js-sdk](https://www.npmjs.com/package/trtc-js-sdk) 和 [tim-js-sdk](https://www.npmjs.com/package/tim-js-sdk) 以及 [tsignaling](https://www.npmjs.com/package/tsignaling)
>- 为了减小 trtc-calling-js.js 的体积，避免和接入侧已使用的 trtc-js-sdk 和 tim-js-sdk 以及 tsignaling 发生版本冲突，trtc-js-sdk 和 tim-js-sdk 以及 tsignaling 不再被打包到 trtc-calling-js.js，在使用前您需要手动安装依赖。
```javascript
  npm i trtc-js-sdk --save
  npm i tim-js-sdk --save
  npm i tsignaling --save
  npm i trtc-calling-js --save
  // 如果是通过node下载的依赖，则使用 import 引入
  import TRTCCalling from 'trtc-calling-js';
 
  // 如果您通过 script 方式使用 trtc-calling-js，需要按顺序
  // 手动引入 trtc.js
  <script src="./trtc.js"></script>
  // 接着手动引入 tim-js.js
  <script src="./tim-js.js"></script>
  // 然后再手动引入 tsignaling.js
  <script src="./tsignaling.js"></script>
  // 最后再手动引入 trtc-calling-js.js
  <script src="./trtc-calling-js.js"></script>

  let options = {
  SDKAppID: 0, // 接入时需要将0替换为您的云通信应用的 SDKAppID
    // 从v0.10.2起，新增 tim 参数
    // tim 参数适用于业务中已存在 TIM 实例，为保证 TIM 实例唯一性
    tim: tim
  };
  let trtcCalling = new TRTCCalling(options);
```



### API list

| API                               | 含义               |
| :-------------------------------- | :----------------- |
| new TRTCCalling(params)           | 初始化 SDK         |
| setLogLevel(level)                | 设置日志级别       |
| on(eventName, callback, context)  | 监听事件           |
| off(eventName, callback, context) | 取消监听事件       |
| login(params)                     | 登录               |
| logout()                          | 登出               |
| call(params)                      | 邀请通话           |
| groupCall(params)                 | 邀请群通话         |
| accept(params)                    | 接受通话邀请       |
| reject(params)                    | 拒绝通话邀请       |
| hangup()                          | 挂断               |
| startRemoteView(params)           | 启动远端画面渲染   |
| stopRemoteView(params)            | 停止远端画面渲染   |
| startLocalView(params)            | 启动本地画面渲染   |
| stopLocalView(params)             | 停止本地画面渲染   |
| openCamera()                      | 启动摄像头         |
| closeCamera()                     | 关闭摄像头         |
| setMicMute(isMute)                | 设备麦克风是否静音 |
| setVideoQuality(profile)          | 设置视频质量 |
| switchToAudioCall()               | 视频通话切换语音通话 |
| switchToVideoCall()               | 语音通话切换视频通话 |
| getCameras()                      | 获取摄像头设备列表 |
| getMicrophones()                  | 获取麦克风设备列表 |
| switchDevice()                    | 切换摄像头或麦克风设备 |
| setSelfInfo()                    | 设置自己的昵称或头像 |



### event list
| event                                            | 含义                      |
| :----------------------------------------------- | :------------------------ |
| TRTCCalling.EVENT.INVITED,                       | 收到邀请通知              |
| TRTCCalling.EVENT.REJECT,                        | 被邀用户拒绝通话          |
| TRTCCalling.EVENT.NO_RESP,                       | 被邀用户超时无应答        |
| TRTCCalling.EVENT.LINE_BUSY,                     | 被邀用户正在通话中，忙线  |
| TRTCCalling.EVENT.CALLING_CANCEL,                | 本次通话被取消了          |
| TRTCCalling.EVENT.CALLING_TIMEOUT,               | 本次通话超时未应答        |
| TRTCCalling.EVENT.CALLING_END,                   | 本次通话结束              |
| TRTCCalling.EVENT.USER_ENTER,                    | 用户进入通话              |
| TRTCCalling.EVENT.USER_LEAVE,                    | 用户离开通话              |
| TRTCCalling.EVENT.KICKED_OUT,                    | 重复登录，被踢出          |
| TRTCCalling.EVENT.USER_VIDEO_AVAILABLE,          | 远端用户开启/关闭了摄像头 |
| TRTCCalling.EVENT.USER_AUDIO_AVAILABLE,          | 远端用户开启/关闭了麦克风 |
| TRTCCalling.EVENT.SDK_READY,                     | SDK 进入 ready 状态 |
| TRTCCalling.EVENT.SDK_NOT_READY,                 | SDK 没有 ready 状态 |
| TRTCCalling.EVENT.GROUP_CALL_INVITEE_LIST_UPDATE | 群聊更新邀请列表 |
| TRTCCalling.EVENT.CALL_TYPE_CHANGED | 通话类型切换收到该回调 |
| TRTCCalling.EVENT.DEVICED_UPDATED | 设备列表更新 |

### Error code
| code               | 错误类型           | 含义                             |
| :----------------- | :---------------- | :------------------------------ |
| 60001              | 方法调用失败        | switchToAudioCall 调用失败        |
| 60002              | 方法调用失败        | switchToVideoCall 调用失败        |
| 60003              | 权限获取失败        | 没有可用的麦克风设备                |
| 60004              | 权限获取失败        | 没有可用的摄像头设备                |
| 60005              | 权限获取失败        | 用户禁止使用设备                   |
| 60006              | 环境检测失败        | 当前环境不支持webRTC              |


### 参考文档
- [腾讯实时音视频 TRTC](https://cloud.tencent.com/document/product/647/16788)
- [腾讯云即时通信 IM](https://cloud.tencent.com/document/product/269/1498)

