# @turf/transform-scale

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## transformScale

Scale a GeoJSON from a given point by a factor of scaling (ex: factor=2 would make the GeoJSON 200% larger).
If a FeatureCollection is provided, the origin point will be calculated based on each individual Feature.

**Parameters**

-   `geojson` **[GeoJSON][1]** GeoJSON to be scaled
-   `factor` **[number][2]** of scaling, positive or negative values greater than 0
-   `options` **[Object][3]** Optional parameters (optional, default `{}`)
    -   `options.origin` **([string][4] \| [Coord][5])** Point from which the scaling will occur (string options: sw/se/nw/ne/center/centroid) (optional, default `'centroid'`)
    -   `options.mutate` **[boolean][6]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

**Examples**

```javascript
var poly = turf.polygon([[[0,29],[3.5,29],[2.5,32],[0,29]]]);
var scaledPoly = turf.transformScale(poly, 3);

//addToMap
var addToMap = [poly, scaledPoly];
scaledPoly.properties = {stroke: '#F00', 'stroke-width': 4};
```

Returns **[GeoJSON][1]** scaled GeoJSON

[1]: https://tools.ietf.org/html/rfc7946#section-3

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[5]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/transform-scale
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
